/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.informix.data;

import com.dbeaver.db.informix.data.InformixTimeSeriesCursor;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.util.Map;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCRowId;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCObjectValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class InformixTimeSeriesHandler
extends JDBCObjectValueHandler {
    private static final Log log = Log.getLog(InformixTimeSeriesHandler.class);
    public static final InformixTimeSeriesHandler INSTANCE = new InformixTimeSeriesHandler();

    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException, SQLException {
        if (session instanceof JDBCSession) {
            JDBCSession jdbcSession = (JDBCSession)session;
            if (type.getTypeName().contains("timeseries")) {
                Object value;
                try {
                    ClassLoader driverClassLoader;
                    Map<String, Class<?>> typeMap = jdbcSession.getExecutionContext().getConnection(session.getProgressMonitor()).getTypeMap();
                    if (!typeMap.containsKey(type.getTypeName()) && (driverClassLoader = session.getDataSource().getContainer().getDriver().getDriverLoader(session.getDataSource().getContainer()).getClassLoader()) != null) {
                        Class<?> tsClass = driverClassLoader.loadClass("com.informix.timeseries.IfmxTimeSeries");
                        typeMap.put(type.getTypeName(), tsClass);
                    }
                }
                catch (Throwable throwable) {
                    log.debug((Object)("Error initializing connection type map for " + type.getTypeName()));
                }
                if ((value = resultSet.getObject(index)) instanceof ResultSet) {
                    ResultSet rs = (ResultSet)value;
                    value = new InformixTimeSeriesCursor(jdbcSession, rs, type.getTypeName());
                } else if (value instanceof RowId) {
                    RowId rowId = (RowId)value;
                    value = new JDBCRowId(rowId);
                }
                return value;
            }
        }
        return super.fetchColumnValue(session, resultSet, type, index);
    }
}

