/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.data;

import com.dbeaver.db.mongodb.MGUtils;
import com.dbeaver.db.mongodb.model.MGDataSource;
import com.dbeaver.model.document.data.DBAbstractDocument;
import com.dbeaver.model.document.data.DBDocumentElement;
import com.dbeaver.model.document.data.DBMapValue;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.bson.Document;
import org.bson.types.Binary;
import org.bson.types.ObjectId;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class MGDocument
extends DBAbstractDocument<MGDataSource, Document>
implements DBDValueCloneable {
    private static final Log log = Log.getLog(MGDocument.class);
    private final Document sourceData;

    public MGDocument(@NotNull MGDataSource dataSource, @NotNull Document sourceData) {
        super((DBPDataSource)dataSource, (Object)sourceData);
        this.sourceData = sourceData;
    }

    @Nullable
    public Object getDocumentId() {
        Object id = ((Document)this.getRawValue()).get((Object)"_id");
        if (id instanceof DBDocumentElement) {
            DBDocumentElement functionWrapper = (DBDocumentElement)id;
            id = functionWrapper.objectValue();
        }
        if (id instanceof Binary) {
            return MGUtils.wrapMongoValue((MGDataSource)this.getDataSource(), id, null);
        }
        return id;
    }

    public Object getDocumentProperty(String name) {
        switch (name) {
            case "id": {
                return this.getDocumentId();
            }
            case "createTime": {
                Object id = ((Document)this.getRawValue()).get((Object)"_id");
                if (!(id instanceof ObjectId)) break;
                return ((ObjectId)id).getDate();
            }
            case "idAttributeName": {
                return "_id";
            }
        }
        return null;
    }

    @NotNull
    public String getDocumentContentType() {
        return "text/json";
    }

    public void serializeDocument(@NotNull DBRProgressMonitor monitor, @NotNull Writer writer) {
        Map document = (Map)MGUtils.unwrapMongoValue((MGDataSource)this.dataSource, null, (Object)this.getRootNode());
        ((MGDataSource)this.getDataSource()).serializeDocument(document, writer);
    }

    public void updateDocument(@NotNull DBRProgressMonitor monitor, @NotNull Reader reader) {
        this.rawMap = MGUtils.wrapMongoMap((MGDataSource)this.dataSource, ((MGDataSource)this.dataSource).deserializeDocument(reader), (Object)this);
        this.rawValue = this.makeMongoDocument((DBMapValue<MGDataSource>)this.rawMap);
        this.markModified();
    }

    protected DBMapValue<MGDataSource> makeRawMap() {
        return (DBMapValue)MGUtils.wrapMongoValue((MGDataSource)this.getDataSource(), this.rawValue, null);
    }

    public Document makeNativeValue() {
        return this.makeMongoDocument((DBMapValue<MGDataSource>)this.rawMap);
    }

    private Document makeMongoDocument(DBMapValue<MGDataSource> rawMap) {
        Document document = rawMap == null ? (Document)this.getRawValue() : Document.parse((String)rawMap.toJson());
        ((MGDataSource)this.dataSource).updateParseResults((Map<String, Object>)document);
        for (Map.Entry entry : document.entrySet()) {
            DBDocumentElement wrapper;
            Object v = entry.getValue();
            if (!(v instanceof DBDocumentElement) || !((wrapper = (DBDocumentElement)v).objectValue() instanceof ObjectId)) continue;
            try {
                document.put((String)entry.getKey(), wrapper.objectValue());
            }
            catch (Exception e) {
                log.error((Object)"Error converting object ID", (Throwable)e);
            }
        }
        return document;
    }

    public DBDValueCloneable cloneValue(DBRProgressMonitor monitor) throws DBCException {
        return new MGDocument((MGDataSource)this.dataSource, this.sourceData);
    }
}

