/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.data;

import com.dbeaver.db.mongodb.MGUtils;
import com.dbeaver.db.mongodb.model.MGDataSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.impl.data.AbstractDatabaseList;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class MGListValue
extends AbstractDatabaseList
implements DBDValueCloneable {
    private final MGDataSource dataSource;
    private final DBSDataType elementType;
    private DBDValueHandler valueHandler;
    private List<Object> listValues;
    private boolean modified;

    public MGListValue(MGDataSource dataSource, List<Object> list) {
        this(dataSource, list, null);
    }

    public MGListValue(MGDataSource dataSource, List<Object> contents, DBSDataType elementType) {
        this.dataSource = dataSource;
        if (contents == null || contents.isEmpty()) {
            this.elementType = elementType == null ? dataSource.getDocumentDataType(3) : elementType;
            this.listValues = new ArrayList<Object>();
        } else {
            this.elementType = (DBSDataType)contents.stream().map(MGUtils::resolveValueType).map(dataSource::getDocumentDataType).reduce(DBUtils::getMoreCommonType).get();
            this.listValues = new ArrayList<Object>(contents.size());
            for (Object item : contents) {
                this.listValues.add(MGUtils.wrapMongoValue(dataSource, item, (Object)this));
            }
        }
    }

    @NotNull
    public DBSDataType getComponentType() {
        return this.elementType;
    }

    @NotNull
    public DBDValueHandler getComponentValueHandler() {
        if (this.valueHandler == null) {
            this.valueHandler = DBUtils.findValueHandler((DBPDataSource)this.dataSource, (DBSTypedObject)this.elementType);
        }
        return this.valueHandler;
    }

    public DBDValueCloneable cloneValue(DBRProgressMonitor monitor) {
        return new MGListValue(this.dataSource, new ArrayList<Object>(this.listValues));
    }

    public List<Object> getRawValue() {
        return this.listValues;
    }

    public boolean isNull() {
        return this.listValues == null;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void release() {
        this.listValues = null;
    }

    public String toString() {
        if (this.isNull()) {
            return "[NULL]";
        }
        return this.makeArrayString();
    }

    @NotNull
    public String makeArrayString() {
        if (this.isNull()) {
            return "NULL";
        }
        return this.listValues.toString();
    }

    public int getItemCount() {
        return this.listValues == null ? 0 : this.listValues.size();
    }

    public Object getItem(int index) {
        return this.listValues.get(index);
    }

    public void setItem(int index, Object value) {
        this.listValues.set(index, DBUtils.getRawValue((Object)value));
        this.modified = true;
    }

    public void setContents(Object[] contents) {
        this.listValues.clear();
        Collections.addAll(this.listValues, contents);
        this.modified = true;
    }
}

