/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.exec;

import com.dbeaver.db.mongodb.MGUtils;
import com.dbeaver.db.mongodb.exec.MGBaseStatement;
import com.dbeaver.db.mongodb.exec.MGSession;
import com.dbeaver.db.mongodb.exec.js.MongoJSCollection;
import com.dbeaver.db.mongodb.exec.js.MongoJSDatabase;
import com.dbeaver.db.mongodb.exec.js.MongoJSProcessor;
import com.dbeaver.db.mongodb.model.MGDatabase;
import java.util.Collection;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.utils.CommonUtils;

public class MGEvalStatement
extends MGBaseStatement {
    private static final Log log = Log.getLog(MGEvalStatement.class);

    public MGEvalStatement(MGSession session, String query) {
        super(session, query);
    }

    public boolean executeStatement() throws DBCException {
        this.beforeExecute();
        try {
            MGDatabase activeDatabase = ((MGSession)this.getSession()).getExecutionContext().getDefaultCatalog();
            if (activeDatabase == null) {
                throw new DBCException("No current database set. Please, specify default database in connection settings.");
            }
            String js = this.getQueryString();
            if (this.isEvalSupported()) {
                this.runInEval(activeDatabase, js);
            } else {
                try {
                    MongoJSProcessor jsProcessor = MongoJSProcessor.forStatement((MGSession)this.getSession(), (DBCStatement)this, activeDatabase);
                    Object result = jsProcessor.eval(js);
                    if (result != null && !(result instanceof MongoJSCollection) && !(result instanceof MongoJSDatabase)) {
                        this.setExecutionResult(result);
                    }
                }
                catch (Exception e) {
                    throw new DBCException(CommonUtils.getRootCause((Throwable)e), (DBCExecutionContext)((MGSession)this.getSession()).getExecutionContext());
                }
            }
            boolean bl = this.result != null || this.iterableResult != null || !CommonUtils.isEmpty((Collection)this.resultList);
            return bl;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
        }
    }

    private boolean isEvalSupported() {
        return ((MGSession)this.getSession()).getDataSource().isEvalSupported();
    }

    private void runInEval(MGDatabase activeDatabase, String js) throws DBCException {
        js = js.replace('\n', ' ');
        Document commandResult = activeDatabase.getDatabase((MGSession)this.getSession()).runCommand((Bson)new Document("eval", (Object)js));
        if (!MGUtils.isCommandResultOk(commandResult)) {
            throw new DBCException("JavaScript error - " + MGUtils.getCommandResultError(commandResult));
        }
        this.setExecutionResult(commandResult);
    }
}

