/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.exec;

import com.dbeaver.db.mongodb.exec.MGEvalStatement;
import com.dbeaver.db.mongodb.exec.MGExecutionContext;
import com.dbeaver.db.mongodb.exec.sql.MGCustomStatement;
import com.dbeaver.db.mongodb.model.MGDataSource;
import com.dbeaver.model.NoSQLConstants;
import com.mongodb.client.ClientSession;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.impl.AbstractSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;

public class MGSession
extends AbstractSession {
    private final MGExecutionContext executionContext;

    public MGSession(DBRProgressMonitor monitor, DBCExecutionPurpose purpose, String taskTitle, MGExecutionContext executionContext) {
        super(monitor, purpose, taskTitle);
        this.executionContext = executionContext;
    }

    @NotNull
    public MGExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @NotNull
    public MGDataSource getDataSource() {
        return (MGDataSource)this.executionContext.getDataSource();
    }

    @Nullable
    public ClientSession getClientSession() {
        return this.executionContext.getClientSession();
    }

    @NotNull
    public DBCStatement prepareStatement(@NotNull DBCStatementType type, @NotNull String query, boolean scrollable, boolean updatable, boolean returnGeneratedKeys) throws DBCException {
        if (NoSQLConstants.SQL_PATTERN.matcher(SQLUtils.stripComments((SQLDialect)this.getDataSource().getSQLDialect(), (String)query)).matches()) {
            return new MGCustomStatement(this, query);
        }
        return new MGEvalStatement(this, query);
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        if (blockThread != null) {
            blockThread.interrupt();
        }
    }

    public void close() {
        super.close();
    }
}

