/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.exec.sql;

import com.dbeaver.db.mongodb.data.MGDocument;
import com.dbeaver.db.mongodb.exec.MGBaseStatement;
import com.dbeaver.db.mongodb.exec.MGSession;
import com.dbeaver.db.mongodb.model.MGCollection;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;

public class MGDeleteStatement
extends MGBaseStatement {
    private DBSAttributeBase[] keyAttributes;
    private Object[] rowValues;

    public MGDeleteStatement(MGSession session, MGCollection mongoCollection, DBSAttributeBase[] keyAttributes, Object[] rowValues) {
        super(session, MGDeleteStatement.makeQuery(mongoCollection, keyAttributes, rowValues));
        this.collection = mongoCollection;
        this.keyAttributes = keyAttributes;
        this.rowValues = rowValues;
    }

    public void setRowValues(Object[] rowValues) {
        this.rowValues = rowValues;
    }

    public boolean executeStatement() throws DBCException {
        if (this.keyAttributes.length == 0) {
            throw new DBCException("Empty key specified for delete");
        }
        this.beforeExecute();
        try {
            Document query = new Document();
            int i = 0;
            while (i < this.keyAttributes.length) {
                Object keyValue = this.rowValues[i];
                if (keyValue instanceof MGDocument) {
                    query.put("_id", ((MGDocument)((Object)keyValue)).getDocumentId());
                    this.updateRowCount = this.collection.getMongoCollection((MGSession)this.getSession()).deleteOne((Bson)query).getDeletedCount();
                } else if (this.keyAttributes[i].getName().equals("_id")) {
                    if (keyValue instanceof String) {
                        String oldValue = (String)keyValue;
                        if (ObjectId.isValid((String)oldValue)) {
                            keyValue = new ObjectId(oldValue);
                        }
                        query.put("_id", keyValue);
                        this.updateRowCount = this.collection.getMongoCollection((MGSession)this.getSession()).deleteOne((Bson)query).getDeletedCount();
                        if (this.updateRowCount != 0L) break;
                        query.put("_id", (Object)oldValue);
                    } else {
                        query.put("_id", keyValue);
                    }
                    this.updateRowCount = this.collection.getMongoCollection((MGSession)this.getSession()).deleteOne((Bson)query).getDeletedCount();
                    break;
                }
                ++i;
            }
            if (this.updateRowCount == 0L) {
                throw new DBCException("Document wasn't deleted");
            }
            return false;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
        }
    }

    private static String makeQuery(MGCollection collection, DBSAttributeBase[] keyAttributes, Object[] rowValues) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ").append(collection.getFullyQualifiedName(DBPEvaluationContext.DML));
        if (keyAttributes.length > 0) {
            sql.append(" WHERE ");
            int i = 0;
            while (i < keyAttributes.length) {
                if (i > 0) {
                    sql.append(" AND ");
                }
                sql.append(collection.getAttributeName(keyAttributes[i])).append("=").append(collection.getAttributeValue(keyAttributes[i], rowValues[i]));
                ++i;
            }
        }
        return sql.toString();
    }
}

