/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mssql.model.plan;

import com.dbeaver.db.mssql.model.plan.schemas.RelOpType;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanCostNode;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlanNode;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class SQLServerPlanNode
extends AbstractExecutionPlanNode
implements DBCPlanCostNode,
DBPPropertySource {
    private final RelOpType node;
    private String name;
    private final String type;
    private final SQLServerPlanNode parent;
    private final List<SQLServerPlanNode> nested = new ArrayList<SQLServerPlanNode>();
    private double estimatedTotalSubtreeCost;
    private double estimateRows;
    private Double estimatedRowsRead;
    private String nodeCondition;
    Map<String, String> attributes = new LinkedHashMap<String, String>();

    public SQLServerPlanNode(String name, String type, RelOpType node, SQLServerPlanNode parent) {
        this.name = name;
        this.type = type;
        this.parent = parent;
        this.node = node;
    }

    public SQLServerPlanNode(SQLServerPlanNode parent, JsonObject object) {
        this.parent = parent;
        this.node = null;
        this.name = object.get("name").getAsString();
        this.type = object.get("type").getAsString();
        JsonArray attrs = object.getAsJsonArray("attributes");
        for (JsonElement attr : attrs) {
            for (Map.Entry p : attr.getAsJsonObject().entrySet()) {
                this.attributes.put((String)p.getKey(), ((JsonElement)p.getValue()).getAsString());
            }
        }
    }

    @Property(order=1, viewable=true)
    public String getNodeName() {
        return this.name;
    }

    @Property(order=0, viewable=true)
    public String getNodeType() {
        return this.type;
    }

    public DBCPlanNode getParent() {
        return this.parent;
    }

    public Collection<? extends DBCPlanNode> getNested() {
        return this.nested;
    }

    public RelOpType getNode() {
        return this.node;
    }

    public void addNested(SQLServerPlanNode node) {
        this.nested.add(node);
    }

    public String toString() {
        return "SQLServerPlanNode [name=" + this.name + ", type=" + this.type + "]";
    }

    public void setName(String name) {
        this.name = name;
    }

    @Property(order=2, viewable=true)
    public double getEstimatedTotalSubtreeCost() {
        return this.estimatedTotalSubtreeCost;
    }

    public void setEstimatedTotalSubtreeCost(double estimatedTotalSubtreeCost) {
        this.estimatedTotalSubtreeCost = estimatedTotalSubtreeCost;
    }

    @Property(order=3, viewable=true)
    public double getEstimateRows() {
        return this.estimateRows;
    }

    public void setEstimateRows(double estimateRows) {
        this.estimateRows = estimateRows;
    }

    @Property(order=4, viewable=true)
    public Double getEstimatedRowsRead() {
        return this.estimatedRowsRead;
    }

    public void setEstimatedRowsRead(Double estimatedRowsRead) {
        this.estimatedRowsRead = estimatedRowsRead;
    }

    public void setAvgRowSize(double avgRowSize) {
        if (avgRowSize != 0.0) {
            this.attributes.put("Average Row Size", String.valueOf(avgRowSize));
        }
    }

    @Property(order=5, viewable=true)
    public String getAvgRowSize() {
        return this.attributes.containsKey("Average Row Size") ? this.attributes.get("Average Row Size") : null;
    }

    @Property(order=6, viewable=true)
    public String getEstimateCPU() {
        return this.attributes.containsKey("Estimate CPU") ? this.attributes.get("Estimate CPU") : null;
    }

    @Property(order=7, viewable=true)
    public String getEstimateIO() {
        return this.attributes.containsKey("Estimate IO") ? this.attributes.get("Estimate IO") : null;
    }

    public void setEstimateCPU(double estimateCPU) {
        if (estimateCPU != 0.0) {
            this.attributes.put("Estimate CPU", String.valueOf(estimateCPU));
        }
    }

    public void setEstimateIO(double estimateIO) {
        if (estimateIO != 0.0) {
            this.attributes.put("Estimate IO", String.valueOf(estimateIO));
        }
    }

    public void setEstimateRebinds(double estimateRebinds) {
        if (estimateRebinds != 0.0) {
            this.attributes.put("Estimate Rebinds", String.valueOf(estimateRebinds));
        }
    }

    public void setEstimateRewinds(double estimateRewinds) {
        if (estimateRewinds != 0.0) {
            this.attributes.put("Estimate Rewinds", String.valueOf(estimateRewinds));
        }
    }

    public void setGroupExecuted(Boolean groupExecuted) {
        if (groupExecuted != null) {
            this.attributes.put("Group Executed", String.valueOf(groupExecuted));
        }
    }

    public void setNodeId(int nodeId) {
        this.attributes.put("Node ID", String.valueOf(nodeId));
    }

    public void setParallel(boolean parallel) {
        this.attributes.put("Parallel", String.valueOf(parallel));
    }

    public void setRemoteDataAccess(Boolean remoteDataAccess) {
        if (remoteDataAccess != null) {
            this.attributes.put("Remote Data Access", String.valueOf(remoteDataAccess));
        }
    }

    public void setPartitioned(Boolean partitioned) {
        if (partitioned != null) {
            this.attributes.put("Partitioned", String.valueOf(partitioned));
        }
    }

    public void setAdaptive(Boolean adaptive) {
        if (adaptive != null) {
            this.attributes.put("Adaptive", String.valueOf(adaptive));
        }
    }

    public void setAdaptiveThresholdRows(Double adaptiveThresholdRows) {
        if (adaptiveThresholdRows != null && adaptiveThresholdRows != 0.0) {
            this.attributes.put("Adaptive Threshold Rows", String.valueOf(adaptiveThresholdRows));
        }
    }

    public void setTableCardinality(Double tableCardinality) {
        if (tableCardinality != null && tableCardinality != 0.0) {
            this.attributes.put("Table Cardinality", String.valueOf(tableCardinality));
        }
    }

    public void setStatsCollectionId(BigInteger statsCollectionId) {
        if (statsCollectionId != null && statsCollectionId.longValue() != 0L) {
            this.attributes.put("Stats  Collection Id", String.valueOf(statsCollectionId));
        }
    }

    public Number getNodeCost() {
        return this.estimatedTotalSubtreeCost;
    }

    public Number getNodeRowCount() {
        if (this.estimatedRowsRead == null) {
            return this.estimatedRowsRead;
        }
        return this.estimateRows;
    }

    public Number getNodePercent() {
        return null;
    }

    public Number getNodeDuration() {
        return null;
    }

    public String getNodeCondition() {
        return this.nodeCondition;
    }

    public void setNodeCondition(String nodeCondition) {
        this.nodeCondition = nodeCondition;
    }

    @NotNull
    public Object getEditableValue() {
        return this;
    }

    @NotNull
    public DBPPropertyDescriptor[] getProperties() {
        DBPPropertyDescriptor[] props = new DBPPropertyDescriptor[this.attributes.size()];
        int index = 0;
        for (Map.Entry<String, String> attr : this.attributes.entrySet()) {
            props[index++] = new PropertyDescriptor("Details", attr.getKey(), attr.getKey(), null, String.class, false, null, null, false);
        }
        return props;
    }

    @Nullable
    public Object getPropertyValue(@NotNull DBRProgressMonitor monitor, @NotNull String id) {
        return this.attributes.get(id);
    }

    public boolean isPropertySet(@NotNull String id) {
        return false;
    }

    public boolean isPropertyResettable(@NotNull String id) {
        return false;
    }

    public void resetPropertyValue(@Nullable DBRProgressMonitor monitor, @NotNull String id) {
    }

    public void resetPropertyValueToDefault(@NotNull String id) {
    }

    public void setPropertyValue(@Nullable DBRProgressMonitor monitor, @NotNull String id, @Nullable Object value) {
    }
}

