/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mysql.model;

import com.dbeaver.db.mysql.model.MySQLDataSourceExt;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.MySQLConstants;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.utils.CommonUtils;

public class SingleStoreDataSource
extends MySQLDataSourceExt {
    private static final String CONN_ATTR_NAME = "connectionAttributes";
    private static final String PROP_APPLICATION_NAME = "program_name";

    public SingleStoreDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        super(monitor, container);
    }

    protected Map<String, String> getInternalConnectionProperties(@NotNull DBRProgressMonitor monitor, @NotNull DBPDriver driver, @NotNull JDBCExecutionContext context, @NotNull String purpose, @NotNull DBPConnectionConfiguration connectionInfo) throws DBCException {
        Map props = super.getInternalConnectionProperties(monitor, driver, context, purpose, connectionInfo);
        Object appName = DBUtils.getClientApplicationName((DBPDataSourceContainer)this.getContainer(), (DBCExecutionContext)context, (String)purpose);
        appName = "dbeaver_singlestore_plugin" + (String)(CommonUtils.isEmpty((String)appName) ? "" : "(" + (String)appName + ")");
        Object connAttr = (String)props.get(CONN_ATTR_NAME);
        connAttr = "program_name:" + (String)appName + (String)(CommonUtils.isEmpty((String)connAttr) ? "" : "," + (String)connAttr);
        props.put(CONN_ATTR_NAME, connAttr);
        return props;
    }

    public List<DBSIndexType> supportedIndexTypes() {
        return Arrays.asList(MySQLConstants.INDEX_TYPE_BTREE, MySQLConstants.INDEX_TYPE_HASH);
    }

    public boolean supportsAlterTableRenameSyntax() {
        return true;
    }

    public boolean supportsConditionForShowDatabasesStatement() {
        return false;
    }

    public boolean readKeysWithColumns() {
        return false;
    }
}

