/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.neo4j.model;

import com.dbeaver.db.neo4j.model.data.Neo4jDocument;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPAttributeReferencePurpose;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLQueryGenerator;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSContextBoundAttribute;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public class Neo4jDialectQueryGenerator
implements SQLQueryGenerator {
    public static Neo4jDialectQueryGenerator INSTANCE = new Neo4jDialectQueryGenerator();
    private static final Log log = Log.getLog(Neo4jDialectQueryGenerator.class);

    protected Neo4jDialectQueryGenerator() {
    }

    public void appendConditionString(@NotNull DBDDataFilter filter, @NotNull List<DBDAttributeConstraint> constraints, @NotNull DBPDataSource dataSource, @Nullable String tableAliase, @NotNull StringBuilder query, boolean inlineCriteria, boolean subQuery) throws DBException {
        if (filter.isUseDisjunctiveNormalForm() && constraints.size() > 1) {
            throw new DBException("Generation of a condition in a disjunctive normal form is not supported yet");
        }
        String operator = filter.isAnyConstraint() ? " OR " : " AND ";
        int index = 0;
        while (index < constraints.size()) {
            DBDAttributeConstraint constraint = constraints.get(index);
            if (index > 0) {
                query.append(operator);
            }
            if (constraints.size() > 1) {
                query.append('(');
            }
            String attrName = this.extractAttributeLabel(dataSource, constraint, tableAliase);
            String constraintCondition = this.getConstraintCondition(dataSource, constraint, tableAliase, inlineCriteria);
            query.append(attrName).append(' ').append(constraintCondition);
            if (constraints.size() > 1) {
                query.append(')');
            }
            ++index;
        }
        if (!CommonUtils.isEmpty((String)filter.getWhere())) {
            if (constraints.size() > 0) {
                query.append(operator).append('(').append(filter.getWhere()).append(')');
            } else {
                query.append(filter.getWhere());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String extractAttributeLabel(@NotNull DBPDataSource dataSource, @NotNull DBDAttributeConstraint constraint, String tableAliase) {
        String attrName = null;
        DBSAttributeBase dbAttribute = constraint.getAttribute();
        if (dbAttribute instanceof DBDAttributeBinding) {
            DBDAttributeBinding binding = (DBDAttributeBinding)dbAttribute;
            if (!CommonUtils.isEmpty((String)tableAliase)) {
                return tableAliase + "." + binding.getLabel();
            }
        }
        if (dbAttribute instanceof DBDAttributeBinding) {
            DBDAttributeBinding binding = (DBDAttributeBinding)dbAttribute;
            if (CommonUtils.isEmpty((String)tableAliase)) {
                DBDAttributeBinding parent = binding.getParentObject();
                return parent.getName() + "." + binding.getLabel();
            }
        }
        if (tableAliase == null) return DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)constraint.getAttributeName());
        return tableAliase + "." + DBUtils.getObjectFullName((DBPDataSource)dataSource, (DBPNamedObject)dbAttribute, (DBPEvaluationContext)DBPEvaluationContext.DML, (DBPAttributeReferencePurpose)DBPAttributeReferencePurpose.DATA_SELECTION);
    }

    @NotNull
    public String getWrappedFilterQuery(@NotNull DBPDataSource dataSource, @NotNull String sqlQuery, @NotNull DBDDataFilter dataFilter) throws DBException {
        StringBuilder modifiedQuery = new StringBuilder();
        String[] split = sqlQuery.split("RETURN");
        if (split.length > 0) {
            modifiedQuery.append(split[0]);
            if (dataFilter.hasConditions()) {
                modifiedQuery.append(" WHERE ");
                SQLUtils.appendConditionString((DBDDataFilter)dataFilter, (DBPDataSource)dataSource, null, (StringBuilder)modifiedQuery, (boolean)true, (boolean)true);
            }
            modifiedQuery.append(" RETURN ").append(split[1]);
        }
        if (dataFilter.hasOrdering()) {
            modifiedQuery.append("\n ").append(" ORDER BY ");
            SQLUtils.appendOrderString((DBDDataFilter)dataFilter, (DBPDataSource)dataSource, null, (boolean)true, (StringBuilder)modifiedQuery);
        }
        modifiedQuery.append(";");
        return modifiedQuery.toString();
    }

    public void appendQueryConditions(@NotNull DBPDataSource dataSource, @NotNull StringBuilder query, @Nullable String tableAlias, @Nullable DBDDataFilter dataFilter) throws DBException {
        if (dataFilter != null && dataFilter.hasConditions()) {
            query.append("\nWHERE ");
            this.appendConditionString(dataFilter, dataSource, tableAlias, query, true);
            query.append("\n ");
        }
    }

    public void appendQueryOrder(@NotNull DBPDataSource dataSource, @NotNull StringBuilder query, String tableAlias, DBDDataFilter dataFilter) {
        if (dataFilter != null && dataFilter.hasOrdering()) {
            query.append("\nORDER BY ");
            this.appendOrderString(dataFilter, dataSource, tableAlias, false, query);
        }
    }

    @NotNull
    public String getQueryWithAppliedFilters(@Nullable DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull String sqlQuery, @NotNull DBDDataFilter dataFilter) throws DBException {
        boolean isForceFilterSubQuery;
        boolean bl = isForceFilterSubQuery = dataSource.getSQLDialect().supportsSubqueries() && dataSource.getContainer().getPreferenceStore().getBoolean("sql.query.filter.force.subselect");
        if (isForceFilterSubQuery) {
            return this.getWrappedFilterQuery(dataSource, sqlQuery, dataFilter);
        }
        try {
            return SQLSemanticProcessor.injectFiltersToQuery((DBRProgressMonitor)monitor, (DBPDataSource)dataSource, (String)sqlQuery, (DBDDataFilter)dataFilter);
        }
        catch (DBException dBException) {
            return this.getWrappedFilterQuery(dataSource, sqlQuery, dataFilter);
        }
    }

    public void appendOrderString(@NotNull DBDDataFilter filter, @NotNull DBPDataSource dataSource, @Nullable String conditionTable, boolean subQuery, @NotNull StringBuilder query) {
        boolean hasOrder = false;
        for (DBDAttributeConstraint co : filter.getOrderConstraints()) {
            String orderString;
            if (hasOrder) {
                query.append(',');
            }
            if ((orderString = this.extractAttributeLabel(dataSource, co, conditionTable)) == null) {
                int orderIndex = SQLUtils.getConstraintOrderIndex((DBDDataFilter)filter, (DBDAttributeConstraint)co);
                if (orderIndex == -1) continue;
                orderString = String.valueOf(orderIndex);
            }
            query.append(orderString);
            if (co.isOrderDescending()) {
                query.append(" DESC");
            }
            hasOrder = true;
        }
        if (!CommonUtils.isEmpty((String)filter.getOrder())) {
            if (hasOrder) {
                query.append(',');
            }
            query.append(filter.getOrder());
        }
    }

    public String getConstraintCondition(@NotNull DBPDataSource dataSource, @NotNull DBDAttributeConstraint constraint, String conditionTable, boolean inlineCriteria) {
        String criteria = constraint.getCriteria();
        if (!CommonUtils.isEmpty((String)criteria)) {
            char firstChar = criteria.trim().charAt(0);
            if (!Character.isLetter(firstChar) && firstChar != '=' && firstChar != '>' && firstChar != '<' && firstChar != '!') {
                return "=" + criteria;
            }
            return criteria;
        }
        if (constraint.getOperator() != null) {
            DBCLogicalOperator operator = constraint.getOperator();
            StringBuilder conString = new StringBuilder();
            Object[] value = constraint.getValue();
            if (DBUtils.isNullValue((Object)value)) {
                if (operator.getArgumentCount() == 0) {
                    return operator.getExpression();
                }
                if (dataSource.getSQLDialect().useEmptyStringForNulls()) {
                    conString.append("=''");
                } else {
                    conString.append("IS ");
                    if (constraint.isReverseOperator()) {
                        conString.append("NOT ");
                    }
                    conString.append("NULL");
                }
                return conString.toString();
            }
            if (constraint.isReverseOperator()) {
                conString.append("NOT ");
            }
            if (operator.getArgumentCount() > 0) {
                if (operator.equals((Object)DBCLogicalOperator.EQUALS) && value instanceof Object[]) {
                    Object[] array = value;
                    int i = 0;
                    while (i < array.length) {
                        if (i > 0) {
                            conString.append(" OR ");
                            conString.append(this.extractAttributeLabel(dataSource, constraint, conditionTable));
                            conString.append(' ');
                        }
                        conString.append(operator.getExpression());
                        String strValue = Neo4jDialectQueryGenerator.getStringValue(dataSource, array[i]);
                        conString.append(' ').append(strValue);
                        ++i;
                    }
                } else {
                    conString.append(operator.getExpression());
                    int i = 0;
                    while (i < operator.getArgumentCount()) {
                        if (i > 0) {
                            conString.append(" AND");
                        }
                        String strValue = Neo4jDialectQueryGenerator.getStringValue(dataSource, value);
                        conString.append(' ').append(strValue);
                        ++i;
                    }
                }
            } else if (operator.getArgumentCount() < 0) {
                int valueCount = Array.getLength(value);
                boolean hasNull = false;
                boolean hasNotNull = false;
                int i = 0;
                while (i < valueCount) {
                    boolean isNull = DBUtils.isNullValue((Object)Array.get(value, i));
                    if (isNull && !hasNull) {
                        hasNull = true;
                    }
                    if (!isNull && !hasNotNull) {
                        hasNotNull = true;
                    }
                    ++i;
                }
                if (!hasNotNull) {
                    return "IS NULL";
                }
                if (hasNull) {
                    conString.append("IS NULL OR ");
                    DBSAttributeBase attr = constraint.getAttribute();
                    if (attr instanceof DBDAttributeBinding && ((DBDAttributeBinding)attr).getEntityAttribute() instanceof DBSContextBoundAttribute) {
                        DBDAttributeBinding attrBinding = (DBDAttributeBinding)attr;
                        DBSContextBoundAttribute entityAttribute = (DBSContextBoundAttribute)attrBinding.getEntityAttribute();
                        conString.append(entityAttribute.formatMemberReference(true, conditionTable, DBPAttributeReferencePurpose.DATA_SELECTION));
                    } else {
                        if (constraint.getEntityAlias() != null) {
                            conString.append(constraint.getEntityAlias()).append('.');
                        } else if (conditionTable != null) {
                            conString.append(conditionTable).append('.');
                        }
                        conString.append(DBUtils.getObjectFullName((DBPDataSource)dataSource, (DBPNamedObject)constraint.getAttribute(), (DBPEvaluationContext)DBPEvaluationContext.DML, (DBPAttributeReferencePurpose)DBPAttributeReferencePurpose.DATA_SELECTION));
                    }
                    conString.append(" ");
                }
                Pair brackets = dataSource.getSQLDialect().getInClauseParentheses();
                conString.append(operator.getExpression());
                conString.append(' ').append((String)brackets.getFirst());
                if (!value.getClass().isArray()) {
                    value = new Object[]{value};
                }
                boolean hasValue = false;
                int i2 = 0;
                while (i2 < valueCount) {
                    Object itemValue = Array.get(value, i2);
                    if (!DBUtils.isNullValue((Object)itemValue)) {
                        if (hasValue) {
                            conString.append(",");
                        }
                        hasValue = true;
                        if (inlineCriteria) {
                            conString.append(SQLUtils.convertValueToSQL((DBPDataSource)dataSource, (DBSTypedObject)constraint.getAttribute(), (Object)itemValue));
                        } else {
                            conString.append(dataSource.getSQLDialect().getTypeCastClause((DBSTypedObject)constraint.getAttribute(), "?", true));
                        }
                    }
                    ++i2;
                }
                conString.append((String)brackets.getSecond());
            }
            return conString.toString();
        }
        return null;
    }

    private static String getStringValue(@NotNull DBPDataSource dataSource, @NotNull Object value) {
        Object strValue = "";
        if (value instanceof CharSequence) {
            strValue = "\"" + value.toString() + "\"";
        } else if (value instanceof Neo4jDocument) {
            Neo4jDocument document = (Neo4jDocument)((Object)value);
            Map rawValue = (Map)document.getRawValue();
            for (Map.Entry entry : rawValue.entrySet()) {
                strValue = ((String)entry.getKey()).equals("STRING") ? "\"" + String.valueOf(entry.getValue()) + "\"" : entry.getValue().toString();
            }
        } else {
            strValue = CommonUtils.toString((Object)value);
        }
        return strValue;
    }
}

