/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.neo4j.model;

import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCResultSetMetaDataImpl;
import org.jkiss.utils.CommonUtils;

public class Neo4jDocumentResultSet
extends JDBCResultSetMetaDataImpl {
    private static final Pattern TABLE_PATTERN = Pattern.compile("MATCH.*(\\w:.*?)(\\w+)", 8);

    public Neo4jDocumentResultSet(JDBCResultSet resultSet) throws SQLException {
        super(resultSet);
    }

    public String getTableName(int column) throws SQLException {
        JDBCStatement statement = (JDBCStatement)this.resultSet.getStatement();
        Matcher matcher = TABLE_PATTERN.matcher(statement.getQueryString());
        String tableName = "";
        while (matcher.find()) {
            tableName = matcher.group(2);
        }
        if (!CommonUtils.isEmpty((String)tableName)) {
            return tableName;
        }
        return super.getTableName(column);
    }
}

