/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.oracle.ui.gis;

import java.sql.Struct;
import org.eclipse.swt.widgets.Control;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataType;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.gis.DBGeometry;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCompositeStatic;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.editors.ComplexValueInlineEditor;
import org.jkiss.dbeaver.ui.gis.IGeometryValueEditor;
import org.jkiss.dbeaver.ui.gis.IGeometryViewer;
import org.jkiss.utils.CommonUtils;
import org.locationtech.jts.geom.Geometry;

public class OracleGeometryStructureViewer
extends ComplexValueInlineEditor
implements IGeometryViewer,
IGeometryValueEditor {
    private static final Log log = Log.getLog(OracleGeometryStructureViewer.class);
    private int valueSRID;

    public OracleGeometryStructureViewer(IValueController controller) {
        super(controller);
    }

    public void primeEditorValue(@Nullable Object value) throws DBException {
        Object userData;
        Object rawValue;
        if (value instanceof DBGeometry && ((rawValue = ((DBGeometry)value).getRawValue()) instanceof Geometry || value instanceof Struct)) {
            value = rawValue;
        }
        if (value instanceof Geometry && (userData = ((Geometry)value).getUserData()) instanceof Struct) {
            value = userData;
        }
        if (value instanceof Struct) {
            VoidProgressMonitor monitor = new VoidProgressMonitor();
            OracleDataType sdoType = ((OracleDataSource)this.getValueController().getExecutionContext().getDataSource()).resolveDataType((DBRProgressMonitor)monitor, "PUBLIC.SDO_GEOMETRY");
            if (sdoType != null) {
                Throwable throwable = null;
                Object var5_6 = null;
                try (DBCSession session = this.getValueController().getExecutionContext().openSession((DBRProgressMonitor)monitor, DBCExecutionPurpose.UTIL, "");){
                    JDBCCompositeStatic composite = new JDBCCompositeStatic(session, (DBSDataType)sdoType, (Struct)value);
                    Object sdoSrid = composite.getAttributeValue("SDO_SRID");
                    if (sdoSrid != null) {
                        this.valueSRID = CommonUtils.toInt((Object)sdoSrid);
                    }
                    value = composite;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        super.primeEditorValue(value);
    }

    public Control getEditorControl() {
        return this.editor.getControl();
    }

    public int getValueSRID() {
        return this.valueSRID;
    }

    public void setValueSRID(int srid) {
        this.valueSRID = this.valueSRID;
    }

    public void refresh() {
        this.editor.refresh();
    }
}

