/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.oracle.edit;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleJob;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class OracleJobManager
extends SQLObjectEditor<OracleJob, OracleSchema> {
    private static final String DATE_REGEX = "^\\d{4}-(0[1-9]|1[0-2])-(0[1-9]|[12]\\d|3[01]) ([01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d$";

    protected OracleJob createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) throws DBException {
        OracleJob oracleJob = new OracleJob((OracleSchema)container, "NEW_JOB");
        oracleJob.setObjectDefinitionText("");
        return oracleJob;
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) throws DBException {
        Map properties = command.getProperties();
        OracleJob oracleJob = (OracleJob)command.getObject();
        String action = SQLUtils.quoteString((DBSObject)oracleJob, (String)String.valueOf(properties.get("action")));
        String interval = SQLUtils.quoteString((DBSObject)oracleJob, (String)String.valueOf(properties.get("interval")));
        String isBroken = String.valueOf(properties.get("broken")).toUpperCase(Locale.ROOT);
        String nextDate = this.formatDate(oracleJob, String.valueOf(properties.get("nextDate")));
        String sql = String.format("DECLARE\n  l_job NUMBER;\nBEGIN\n  DBMS_JOB.SUBMIT(\n    job       => l_job,\n    what      => %s,\n    next_date => %s,\n    interval  => %s\n  );\n  COMMIT;\n  DBMS_JOB.BROKEN(l_job, %s);\nEND;\n", action, nextDate, interval, isBroken);
        Object nlsEnv = properties.get("nlsEnv");
        if (nlsEnv != null) {
            actions.add((DBEPersistAction)this.modifyNlsEnv(nlsEnv));
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create New Job", sql));
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) throws DBException {
        OracleJob oracleJob = (OracleJob)command.getObject();
        Map properties = command.getProperties();
        String action = SQLUtils.quoteString((DBSObject)oracleJob, (String)String.valueOf(properties.getOrDefault("action", oracleJob.getAction())));
        String interval = SQLUtils.quoteString((DBSObject)oracleJob, (String)String.valueOf(properties.getOrDefault("interval", oracleJob.getInterval())));
        String isBroken = String.valueOf(properties.get("broken")).toUpperCase(Locale.ROOT);
        long job = oracleJob.getJob();
        String nextDate = this.formatDate(oracleJob, String.valueOf(properties.get("nextDate")));
        String sql = String.format("BEGIN\n  DBMS_JOB.CHANGE(\n    job       => %s,\n    what      => %s,\n    next_date => %s,\n    interval  => %s\n  );\n  DBMS_JOB.BROKEN(%s, %s);\n  COMMIT;\nEND;\n", job, action, nextDate, interval, job, isBroken);
        Object nlsEnv = properties.get("nlsEnv");
        if (nlsEnv != null) {
            actionList.add((DBEPersistAction)this.modifyNlsEnv(nlsEnv));
        }
        actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Update Job", sql));
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) throws DBException {
        String sql = String.format("BEGIN\n  DBMS_JOB.REMOVE(%s);\n  COMMIT;\nEND;\n", ((OracleJob)command.getObject()).getJob());
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Delete Job", sql));
    }

    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return 4L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, OracleJob> getObjectsCache(OracleJob object) {
        return object.getSchema().jobCache;
    }

    private SQLDatabasePersistAction modifyNlsEnv(@NotNull Object nlsEnv) {
        String sql = String.format("ALTER SESSION SET %s", nlsEnv);
        return new SQLDatabasePersistAction("Edit NLS ENV", sql);
    }

    private String formatDate(OracleJob oracleJob, String date) {
        return date.matches(DATE_REGEX) ? "TO_DATE(%s,'yyyy-mm-dd hh24:mi:ss')".formatted(SQLUtils.quoteString((DBSObject)oracleJob, (String)date)) : date;
    }
}

