/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.oracle.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleUser;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class OracleUserManager
extends SQLObjectEditor<OracleUser, OracleDataSource> {
    protected OracleUser createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) throws DBException {
        OracleUser newUser = new OracleUser((OracleDataSource)container, null);
        if (copyFrom != null) {
            throw new DBException("Cloning or copying of users is unsupported");
        }
        return newUser;
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        OracleUser user = (OracleUser)command.getObject();
        String sql = "CREATE USER " + DBUtils.getQuotedIdentifier((DBSObject)user);
        if (!CommonUtils.isEmpty((String)user.getPassword())) {
            sql = sql + " IDENTIFIED BY \"" + user.getPassword() + "\"";
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create user", sql));
        user.setPassword("");
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop user", "DROP USER " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject())) + " CASCADE"));
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) throws DBException {
        OracleUser user = (OracleUser)command.getObject();
        StringBuilder sql = new StringBuilder();
        String alterBegin = "ALTER USER " + DBUtils.getQuotedIdentifier((DBSObject)user);
        sql.append(alterBegin);
        if (command.hasProperty((Object)"locked")) {
            if (((Boolean)command.getProperty((Object)"locked")).booleanValue()) {
                sql.append(" ACCOUNT LOCK");
            } else {
                sql.append(" ACCOUNT UNLOCK");
            }
        }
        if (command.getProperty((Object)"password") != null) {
            String password = (String)command.getProperty((Object)"password");
            String confirmPassword = (String)command.getProperty((Object)"confirmPassword");
            if (CommonUtils.isEmpty((String)confirmPassword)) {
                throw new DBException("Confirm password is empty");
            }
            if (!password.equals(confirmPassword)) {
                throw new DBException("Password and confirmation do not match");
            }
            sql.append(" IDENTIFIED BY \"").append(user.getPassword()).append("\"");
        }
        if (!alterBegin.contentEquals(sql)) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Modify user", sql.toString()));
        }
    }

    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return 1L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, OracleUser> getObjectsCache(OracleUser object) {
        return object.getDataSource().getUserCache();
    }
}

