/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redis.views;

import com.dbeaver.db.redis.Activator;
import com.dbeaver.db.redis.RedisMessages;
import com.dbeaver.db.redis.model.RedisDeploymentType;
import com.dbeaver.db.redis.views.RedisKeysConfigPage;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.utils.CommonUtils;

public class RedisConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private static final Log log = Log.getLog(RedisConnectionPage.class);
    private static ImageDescriptor logoImage = Activator.getImageDescriptor("icons/redis_logo.png");
    private Composite settingsGroup;
    private Button typeManualRadio;
    private Button typeURLRadio;
    private Composite urlGroup;
    private Composite addrGroup;
    private Text urlText;
    private Text hostText;
    private Text portText;
    private Combo databaseText;
    private Text connectTimeout;
    private Text socketTimeout;
    private boolean activated;
    private Button setClientCheck;
    private Combo deploymentCombo;
    private Composite masterCredsGroup;
    private Composite deploymentGroup;
    private Text masterNameText;

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        this.createGeneralTab(composite);
        this.setControl((Control)this.settingsGroup);
    }

    private Composite createGeneralTab(final Composite parent) {
        ModifyListener textListener = e -> {
            if (this.activated) {
                this.saveAndUpdate();
            }
        };
        this.settingsGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        this.settingsGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        this.settingsGroup.setLayoutData((Object)gd);
        Group serverGroup = UIUtils.createControlGroup((Composite)this.settingsGroup, (String)RedisMessages.connection_page_group_server, (int)1, (int)768, (int)-1);
        Composite typeComposite = UIUtils.createComposite((Composite)serverGroup, (int)3);
        UIUtils.createControlLabel((Composite)typeComposite, (String)"Type");
        SelectionAdapter typeSwitcher = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RedisConnectionPage.this.showTypeControls((Boolean)e.widget.getData());
            }
        };
        this.typeManualRadio = UIUtils.createRadioButton((Composite)typeComposite, (String)"Manual", (Object)false, (SelectionListener)typeSwitcher);
        this.typeURLRadio = UIUtils.createRadioButton((Composite)typeComposite, (String)"URL", (Object)true, (SelectionListener)typeSwitcher);
        this.urlGroup = UIUtils.createComposite((Composite)serverGroup, (int)2);
        this.urlGroup.setLayoutData((Object)new GridData(768));
        this.urlText = UIUtils.createLabelText((Composite)this.urlGroup, (String)"URL", (String)"");
        this.urlText.setLayoutData((Object)new GridData(768));
        this.urlText.addModifyListener(textListener);
        UIUtils.createEmptyLabel((Composite)this.urlGroup, (int)1, (int)1);
        UIUtils.createLabel((Composite)this.urlGroup, (String)"Redis service URI, starts with redis: or rediss:. May contain user name and password");
        this.addrGroup = UIUtils.createComposite((Composite)serverGroup, (int)4);
        this.addrGroup.setLayoutData((Object)new GridData(768));
        this.hostText = UIUtils.createLabelText((Composite)this.addrGroup, (String)RedisMessages.connection_page_group_host, (String)"");
        gd = new GridData(768);
        this.hostText.setLayoutData((Object)gd);
        UIUtils.setDefaultTextControlWidthHint((Control)this.hostText);
        this.hostText.addModifyListener(textListener);
        this.portText = UIUtils.createLabelText((Composite)this.addrGroup, (String)RedisMessages.connection_page_label_text_port, (String)"");
        gd = new GridData(2);
        gd.widthHint = 60;
        this.portText.setLayoutData((Object)gd);
        this.portText.addModifyListener(textListener);
        this.databaseText = UIUtils.createLabelCombo((Composite)this.addrGroup, (String)RedisMessages.connection_page_label_text_database, (String)RedisMessages.connection_page_label_text_database_tip, (int)2060);
        gd = new GridData(32);
        this.databaseText.setLayoutData((Object)gd);
        this.databaseText.addModifyListener(textListener);
        int i = 0;
        while (i < 16) {
            this.databaseText.add(String.valueOf(i));
            ++i;
        }
        this.deploymentGroup = UIUtils.createComposite((Composite)serverGroup, (int)2);
        this.deploymentGroup.setLayoutData((Object)new GridData(32));
        this.deploymentCombo = UIUtils.createLabelCombo((Composite)this.deploymentGroup, (String)"Deployment", (String)"Use multi-node cluster or Sentinel connection.\nSome Redis features may not work in this mode", (int)8);
        RedisDeploymentType[] redisDeploymentTypeArray = RedisDeploymentType.values();
        int n = redisDeploymentTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RedisDeploymentType value = redisDeploymentTypeArray[n2];
            this.deploymentCombo.add(value.getDescription(), value.ordinal());
            ++n2;
        }
        this.masterCredsGroup = UIUtils.createPlaceholder((Composite)serverGroup, (int)2);
        this.masterCredsGroup.setLayoutData((Object)new GridData(768));
        this.masterNameText = UIUtils.createLabelText((Composite)this.masterCredsGroup, (String)"Master Group", (String)"");
        gd = new GridData(768);
        gd.widthHint = 32;
        this.masterNameText.setLayoutData((Object)gd);
        this.deploymentCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RedisConnectionPage.this.updateMasterNameVisibility();
            }
        });
        this.createAuthPanel(this.settingsGroup, 3);
        ExpandableComposite extSettingsGroup = new ExpandableComposite(this.settingsGroup, 0);
        extSettingsGroup.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                UIUtils.resizeShell((Shell)parent.getShell());
            }
        });
        extSettingsGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        extSettingsGroup.setText(RedisMessages.connection_page_group_connection_settings);
        Group serverSettings = UIUtils.createControlGroup((Composite)extSettingsGroup, (String)RedisMessages.connection_page_group_connection_settings, (int)4, (int)1808, (int)0);
        extSettingsGroup.setClient((Control)serverSettings);
        this.connectTimeout = UIUtils.createLabelText((Composite)serverSettings, (String)RedisMessages.connection_page_label_spinner_connect_timeout, (String)String.valueOf(10000));
        this.connectTimeout.setToolTipText(RedisMessages.connection_page_label_spinner_tip_connect_timeout);
        gd = new GridData(32);
        gd.widthHint = UIUtils.getFontHeight((Control)this.connectTimeout) * 10;
        this.connectTimeout.setLayoutData((Object)gd);
        this.connectTimeout.addModifyListener(textListener);
        this.socketTimeout = UIUtils.createLabelText((Composite)serverSettings, (String)RedisMessages.connection_page_label_spinner_socket_timeout, (String)String.valueOf(100000));
        this.socketTimeout.setToolTipText(RedisMessages.connection_page_label_spinner_tip_socket_timeout);
        gd = new GridData(2);
        gd.widthHint = UIUtils.getFontHeight((Control)this.socketTimeout) * 10;
        this.socketTimeout.setLayoutData((Object)gd);
        this.socketTimeout.addModifyListener(textListener);
        this.setClientCheck = UIUtils.createCheckbox((Composite)serverSettings, (String)RedisMessages.connection_page_label_set_client, (String)RedisMessages.connection_page_label_set_client_tip, (boolean)true, (int)4);
        this.createDriverPanel(this.settingsGroup);
        return this.settingsGroup;
    }

    private void updateMasterNameVisibility() {
        UIUtils.setControlVisible((Control)this.masterCredsGroup, (this.deploymentCombo.getSelectionIndex() == RedisDeploymentType.SENTINEL.ordinal() ? 1 : 0) != 0);
        this.settingsGroup.layout(true, true);
    }

    private void showTypeControls(boolean showURL) {
        UIUtils.setControlVisible((Control)this.urlGroup, (boolean)showURL);
        UIUtils.setControlVisible((Control)this.addrGroup, (!showURL ? 1 : 0) != 0);
        this.settingsGroup.layout(true, true);
        this.site.updateButtons();
    }

    public boolean isComplete() {
        boolean isValidDeployment;
        boolean bl = isValidDeployment = this.deploymentCombo.getSelectionIndex() != RedisDeploymentType.SENTINEL.ordinal() || !this.masterNameText.getText().isEmpty();
        return !this.hostText.getText().isEmpty() && !this.portText.getText().isEmpty() && isValidDeployment;
    }

    public void loadSettings() {
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.urlText != null) {
            this.urlText.setText(CommonUtils.notEmpty((String)connectionInfo.getUrl()));
        }
        if (this.hostText != null) {
            String timeout;
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                this.hostText.setText(CommonUtils.notEmpty((String)connectionInfo.getHostName()));
            } else {
                this.hostText.setText("localhost");
            }
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                this.portText.setText(connectionInfo.getHostPort());
            } else if (this.site.getDriver().getDefaultPort() != null) {
                this.portText.setText(this.site.getDriver().getDefaultPort());
            } else {
                this.portText.setText("");
            }
            String dbName = connectionInfo.getDatabaseName();
            if (CommonUtils.isEmpty((String)dbName)) {
                dbName = String.valueOf(0);
            }
            this.databaseText.setText(dbName);
            String type = connectionInfo.getProviderProperty("redis.deployment.type");
            if (CommonUtils.isEmpty((String)type)) {
                if (CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("redis.use.cluster"))) {
                    this.deploymentCombo.select(RedisDeploymentType.CLUSTER.ordinal());
                } else {
                    this.deploymentCombo.select(RedisDeploymentType.STANDALONE.ordinal());
                }
            } else {
                this.deploymentCombo.select(RedisDeploymentType.valueOf((String)type).ordinal());
            }
            this.updateMasterNameVisibility();
            if (this.deploymentCombo.getSelectionIndex() == RedisDeploymentType.SENTINEL.ordinal()) {
                this.masterNameText.setText(CommonUtils.notEmpty((String)connectionInfo.getProviderProperty("redis.sentinel.master")));
            }
            if ((timeout = connectionInfo.getProviderProperty("@dbeaver-redis.timeout.connect")) == null) {
                timeout = String.valueOf(10000);
            }
            this.connectTimeout.setText(timeout);
            timeout = connectionInfo.getProviderProperty("@dbeaver-redis.timeout.socket");
            if (timeout == null) {
                timeout = String.valueOf(100000);
            }
            this.socketTimeout.setText(timeout);
            this.setClientCheck.setSelection(CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("redis.set.client"), (boolean)true));
        }
        super.loadSettings();
        this.activated = true;
        boolean showURL = connectionInfo.getConfigurationType() == DBPDriverConfigurationType.URL;
        this.typeURLRadio.setSelection(showURL);
        this.typeManualRadio.setSelection(!showURL);
        this.showTypeControls(showURL);
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.masterNameText != null) {
            connectionInfo.setProviderProperty("redis.sentinel.master", this.masterNameText.getText());
        }
        if (this.hostText != null) {
            connectionInfo.setHostName(this.hostText.getText().trim());
            connectionInfo.setHostPort(this.portText.getText().trim());
            connectionInfo.setDatabaseName(this.databaseText.getText().trim());
            connectionInfo.removeProviderProperty("redis.use.cluster");
            connectionInfo.setProviderProperty("redis.deployment.type", RedisDeploymentType.values()[this.deploymentCombo.getSelectionIndex()].name());
        }
        connectionInfo.setProviderProperty("@dbeaver-redis.timeout.connect", this.connectTimeout.getText());
        connectionInfo.setProviderProperty("@dbeaver-redis.timeout.socket", this.socketTimeout.getText());
        connectionInfo.setProviderProperty("redis.set.client", String.valueOf(this.setClientCheck.getSelection()));
        connectionInfo.setConfigurationType(this.typeURLRadio.getSelection() ? DBPDriverConfigurationType.URL : DBPDriverConfigurationType.MANUAL);
        super.saveSettings(dataSource);
    }

    protected void saveConnectionURL(DBPConnectionConfiguration connectionInfo) {
        if (this.typeURLRadio.getSelection()) {
            connectionInfo.setUrl(this.urlText.getText().trim());
        } else {
            connectionInfo.setUrl("");
        }
    }

    private void saveAndUpdate() {
        this.site.updateButtons();
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new RedisKeysConfigPage()};
    }
}

