/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redshift.auth;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.ArrayUtils;

public enum RedshiftAuthFSPlugin {
    ADFS("adfs", "Active Directory Federation Services", "com.amazon.redshift.plugin.AdfsCredentialsProvider", true, true, new String[]{"idp_host", "idp_port", "preferred_role"}),
    AZURE_AD("azure", "Microsoft Entra ID (formerly Azure AD)", "com.amazon.redshift.plugin.AzureCredentialsProvider", false, false, new String[]{"idp_tenant", "client_id", "client_secret"}),
    AZURE_SSO_MFA("browser azure ad", "Microsoft Entra ID SSO with MFA", "com.amazon.redshift.plugin.BrowserAzureCredentialsProvider", false, false, new String[]{"idp_tenant", "client_id", "client_secret"}),
    OKTA("okta", "Okta", "com.amazon.redshift.plugin.OktaCredentialsProvider", true, true, new String[]{"idp_host", "idp_port", "app_id"}),
    PingFederate("ping", "PingFederate", "com.amazon.redshift.plugin.PingCredentialsProvider", true, true, new String[]{"idp_host", "idp_port", "app_id"});

    @NotNull
    private final String id;
    @NotNull
    private final String title;
    @NotNull
    private final String providerClassName;
    private final boolean needsCredentials;
    private final boolean supportsCredentials;
    private final String[] pluginProperties;

    private RedshiftAuthFSPlugin(@NotNull String id, String title, String providerClassName, boolean needsCredentials, boolean supportsCredentials, String[] pluginProperties) {
        this.id = id;
        this.title = title;
        this.providerClassName = providerClassName;
        this.needsCredentials = needsCredentials;
        this.supportsCredentials = supportsCredentials;
        this.pluginProperties = pluginProperties;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getTitle() {
        return this.title;
    }

    @NotNull
    public String getProviderClassName() {
        return this.providerClassName;
    }

    public boolean needsCredentials() {
        return this.needsCredentials;
    }

    public boolean supportsCredentials() {
        return this.supportsCredentials;
    }

    public String[] getPluginProperties() {
        return this.pluginProperties;
    }

    public boolean supportsProperty(String prop) {
        return ArrayUtils.contains((Object[])this.pluginProperties, (Object)prop);
    }

    @Nullable
    public static RedshiftAuthFSPlugin getById(String id) {
        RedshiftAuthFSPlugin[] redshiftAuthFSPluginArray = RedshiftAuthFSPlugin.values();
        int n = redshiftAuthFSPluginArray.length;
        int n2 = 0;
        while (n2 < n) {
            RedshiftAuthFSPlugin p = redshiftAuthFSPluginArray[n2];
            if (p.id.equals(id)) {
                return p;
            }
            ++n2;
        }
        return null;
    }
}

