/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redshift.model;

import com.dbeaver.db.redshift.model.RedshiftPermissionOwner;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeGrant;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class RedshiftRole
extends RedshiftPermissionOwner {
    private static final Log log = Log.getLog(RedshiftRole.class);
    private String externalID;
    private String roleOwner;

    public RedshiftRole(@NotNull PostgreDatabase database, @NotNull String name) {
        super(database, name, null, false);
    }

    public RedshiftRole(@NotNull DBRProgressMonitor monitor, @NotNull PostgreDatabase database, @NotNull ResultSet dbResult) throws SQLException {
        super(database, dbResult);
        this.loadInfo(monitor, dbResult);
    }

    protected void loadInfo(ResultSet dbResult) {
    }

    private void loadInfo(@NotNull DBRProgressMonitor monitor, @NotNull ResultSet dbResult) {
        this.persisted = true;
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"role_name");
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"role_id");
        this.externalID = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"external_id");
        this.roleOwner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"role_owner");
    }

    @Property(editable=true, updatable=true, order=3)
    @Nullable
    public String getExternalID() {
        return this.externalID;
    }

    @Property(order=4)
    public String getRoleOwner() {
        return this.roleOwner;
    }

    @Nullable
    public String getSpecificRoleType() {
        return "ROLE";
    }

    public boolean supportsRoutinesPermissions() {
        return false;
    }

    @Override
    public List<PostgrePrivilege> getPrivileges(@NotNull DBRProgressMonitor monitor, boolean includeNestedObjects) throws DBCException {
        ArrayList<PostgrePrivilege> permissions = new ArrayList<PostgrePrivilege>();
        Throwable throwable = null;
        Object var5_6 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read role privileges");){
            JDBCPreparedStatement dbStat;
            Object var8_14;
            try {
                Throwable throwable2 = null;
                var8_14 = null;
                try {
                    dbStat = session.prepareStatement("SELECT namespace_name as table_schema, relation_name as table_name, * FROM pg_catalog.svv_relation_privileges\nWHERE identity_type ='role' AND identity_id=?");
                    try {
                        dbStat.setLong(1, this.getObjectId());
                        permissions.addAll(RedshiftRole.getRolePermissions((DBRProgressMonitor)monitor, (PostgreRole)this, (PostgrePrivilegeGrant.Kind)PostgrePrivilegeGrant.Kind.TABLE, (JDBCPreparedStatement)dbStat));
                    }
                    finally {
                        if (dbStat != null) {
                            dbStat.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable e) {
                log.error((Object)"Error reading table privileges", e);
            }
            try {
                e = null;
                var8_14 = null;
                try {
                    dbStat = session.prepareStatement("SELECT namespace_name as table_schema, * FROM pg_catalog.svv_schema_privileges WHERE identity_type ='role' AND identity_id=?");
                    try {
                        dbStat.setLong(1, this.getObjectId());
                        permissions.addAll(RedshiftRole.getRolePermissions((DBRProgressMonitor)monitor, (PostgreRole)this, (PostgrePrivilegeGrant.Kind)PostgrePrivilegeGrant.Kind.SCHEMA, (JDBCPreparedStatement)dbStat));
                    }
                    finally {
                        if (dbStat != null) {
                            dbStat.close();
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (e == null) {
                        e = throwable4;
                    } else if (e != throwable4) {
                        e.addSuppressed(throwable4);
                    }
                    throw e;
                }
            }
            catch (Throwable e) {
                log.error((Object)"Error reading schemas privileges", e);
            }
            Collections.sort(permissions);
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
        return permissions;
    }

    @Override
    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) {
        return super.refreshObject(monitor);
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        StringBuilder sql = new StringBuilder("CREATE ROLE " + DBUtils.getQuotedIdentifier((DBSObject)this) + (String)(CommonUtils.isNotEmpty((String)this.externalID) ? " EXTERNALID \"" + this.externalID + "\"" : "") + ";");
        this.addPermissionsToDefinition(monitor, sql, options);
        return sql.toString();
    }
}

