/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.salesforce.ui.cdp;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.DatabaseNativeAuthModelConfigurator;
import org.jkiss.utils.CommonUtils;

public class SalesForceCDPPasswordAuthConfigurator
extends DatabaseNativeAuthModelConfigurator {
    private Text clientIdText;
    private Text clientSecretText;

    public void createControl(@NotNull Composite authPanel, DBAAuthModel<?> object, @NotNull Runnable propertyChangeListener) {
        super.createControl(authPanel, object, propertyChangeListener);
        this.clientIdText = UIUtils.createLabelText((Composite)authPanel, (String)"Client ID", (String)"", (int)2048);
        this.clientSecretText = UIUtils.createLabelText((Composite)authPanel, (String)"Client Secret", (String)"", (int)0x400800);
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.loadSettings(dataSource);
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        this.clientIdText.setText(CommonUtils.notEmpty((String)configuration.getAuthProperty("clientId")));
        this.clientSecretText.setText(CommonUtils.notEmpty((String)configuration.getAuthProperty("clientSecret")));
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        configuration.setAuthProperty("clientId", this.clientIdText.getText().trim());
        configuration.setAuthProperty("clientSecret", this.clientSecretText.getText().trim());
    }
}

