/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.salesforce.model.auth;

import com.dbeaver.db.salesforce.model.auth.SalesForcePasswordAuthCredentials;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNative;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class SalesForcePasswordAuthModel
extends AuthModelDatabaseNative<SalesForcePasswordAuthCredentials> {
    public static final String ID = "salesforce";

    public boolean isUserNameApplicable() {
        return true;
    }

    public boolean isUserPasswordApplicable() {
        return true;
    }

    @NotNull
    public SalesForcePasswordAuthCredentials createCredentials() {
        return new SalesForcePasswordAuthCredentials();
    }

    @NotNull
    public SalesForcePasswordAuthCredentials loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        SalesForcePasswordAuthCredentials credentials = (SalesForcePasswordAuthCredentials)super.loadCredentials(dataSource, configuration);
        credentials.setAuthToken(configuration.getAuthProperty("auth-token"));
        return credentials;
    }

    public void saveCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull SalesForcePasswordAuthCredentials credentials) {
        configuration.setAuthProperty("auth-token", credentials.getAuthToken());
        super.saveCredentials(dataSource, configuration, (AuthModelDatabaseNativeCredentials)credentials);
    }

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull SalesForcePasswordAuthCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connectProps) throws DBException {
        String authToken = credentials.getAuthToken();
        if (!CommonUtils.isEmpty((String)authToken)) {
            connectProps.put("auth-token", authToken);
        }
        return super.initAuthentication(monitor, dataSource, (AuthModelDatabaseNativeCredentials)credentials, configuration, connectProps);
    }
}

