/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.salesforce.model.auth.cdp;

import com.dbeaver.db.salesforce.model.auth.cdp.SalesForceCDPPasswordAuthCredentials;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNative;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class SalesForceCDPPasswordAuthModel
extends AuthModelDatabaseNative<SalesForceCDPPasswordAuthCredentials> {
    public static final String PROP_CLIENT_ID = "clientId";
    public static final String PROP_CLIENT_SECRET = "clientSecret";

    @NotNull
    public SalesForceCDPPasswordAuthCredentials createCredentials() {
        return new SalesForceCDPPasswordAuthCredentials();
    }

    @NotNull
    public SalesForceCDPPasswordAuthCredentials loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        SalesForceCDPPasswordAuthCredentials credentials = (SalesForceCDPPasswordAuthCredentials)super.loadCredentials(dataSource, configuration);
        credentials.setClientId(configuration.getAuthProperty(PROP_CLIENT_ID));
        credentials.setClientSecret(configuration.getAuthProperty(PROP_CLIENT_SECRET));
        return credentials;
    }

    public void saveCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull SalesForceCDPPasswordAuthCredentials credentials) {
        configuration.setAuthProperty(PROP_CLIENT_ID, credentials.getClientId());
        configuration.setAuthProperty(PROP_CLIENT_SECRET, credentials.getClientSecret());
        super.saveCredentials(dataSource, configuration, (AuthModelDatabaseNativeCredentials)credentials);
    }

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull SalesForceCDPPasswordAuthCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connectProps) throws DBException {
        String clientSecret;
        String clientId = credentials.getClientId();
        if (CommonUtils.isNotEmpty((String)clientId)) {
            connectProps.setProperty(PROP_CLIENT_ID, clientId);
        }
        if (CommonUtils.isNotEmpty((String)(clientSecret = credentials.getClientSecret()))) {
            connectProps.setProperty(PROP_CLIENT_SECRET, clientSecret);
        }
        return super.initAuthentication(monitor, dataSource, (AuthModelDatabaseNativeCredentials)credentials, configuration, connectProps);
    }
}

