/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.snowflake.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericFunctionResultType;
import org.jkiss.dbeaver.ext.generic.model.GenericPackage;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPOverloadedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectWithScript;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.utils.CommonUtils;

public class SnowflakeProcedure
extends GenericProcedure
implements DBSObjectWithScript,
DBPOverloadedObject,
DBPNamedObject2,
DBPRefreshableObject {
    private DBSProcedureType dbsProcedureType;
    private String argumentSignature;
    private String normalizedSignature;
    private String dataType;
    private String language;
    private Date createTime;
    private Date lastAlter;
    private String objectDefinitionText;

    public SnowflakeProcedure(GenericStructContainer container, String procedureName, @Nullable String description, @NotNull DBSProcedureType procedureType, @Nullable GenericFunctionResultType resultType, @NotNull JDBCResultSet dbResult) {
        super(container, procedureName, null, description, procedureType, resultType);
        this.dbsProcedureType = procedureType;
        this.argumentSignature = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ARGUMENT_SIGNATURE");
        this.normalizedSignature = SQLUtils.extractProcedureParameterTypes((String)this.argumentSignature);
        this.dataType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DATA_TYPE");
        this.language = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"P_LANGUAGE");
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATED");
        this.lastAlter = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_ALTERED");
    }

    public SnowflakeProcedure(@NotNull GenericStructContainer container, @NotNull String procedureName) {
        super(container, procedureName, null, null, DBSProcedureType.PROCEDURE, GenericFunctionResultType.UNKNOWN);
        this.dbsProcedureType = DBSProcedureType.PROCEDURE;
        this.setPersisted(false);
        this.argumentSignature = "()";
        this.normalizedSignature = "()";
    }

    public GenericPackage getPackage() {
        return super.getPackage();
    }

    public GenericFunctionResultType getFunctionResultType() {
        return super.getFunctionResultType();
    }

    @Property(viewable=true, order=7)
    public String getDataType() {
        return this.dataType;
    }

    @Property(viewable=true, order=8)
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    @Property(viewable=true, order=9)
    public DBSProcedureType getProcedureType() {
        return this.dbsProcedureType;
    }

    public void setDbsProcedureType(DBSProcedureType dbsProcedureType) {
        this.dbsProcedureType = dbsProcedureType;
    }

    @Property(viewable=true, order=10)
    public Date getCreateTime() {
        return this.createTime;
    }

    @Property(viewable=true, order=11)
    public Date getLastAlter() {
        return this.lastAlter;
    }

    @NotNull
    public String getOverloadedName() {
        return this.getName() + (CommonUtils.isEmpty((String)this.argumentSignature) ? "()" : this.argumentSignature);
    }

    @NotNull
    public String getUniqueName() {
        String fq = DBUtils.getObjectFullName((DBPDataSource)this.getDataSource(), (DBPNamedObject)this, (DBPEvaluationContext)DBPEvaluationContext.DDL);
        return fq + (CommonUtils.isEmpty((String)this.normalizedSignature) ? "()" : this.normalizedSignature);
    }

    public String signatureForDDL() {
        return CommonUtils.isEmpty((String)this.normalizedSignature) ? "()" : this.normalizedSignature;
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return super.getDescription();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Property(hidden=true, editable=true, updatable=true, order=-1)
    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        if (this.objectDefinitionText != null) {
            return this.objectDefinitionText;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read routine DDL");){
                JDBCResultSet rs;
                block25: {
                    String type = this.getProcedureType() == DBSProcedureType.FUNCTION ? "FUNCTION" : "PROCEDURE";
                    String qname = DBUtils.getObjectFullName((DBPDataSource)this.getDataSource(), (DBPNamedObject)this, (DBPEvaluationContext)DBPEvaluationContext.DDL);
                    String target = qname + this.signatureForDDL();
                    Throwable throwable2 = null;
                    Object var10_14 = null;
                    try {
                        String string;
                        JDBCPreparedStatement ps = session.prepareStatement("SELECT GET_DDL(?, ?) AS DDL");
                        ps.setString(1, type);
                        ps.setString(2, target);
                        Throwable throwable3 = null;
                        Object var13_19 = null;
                        try {
                            block26: {
                                rs = ps.executeQuery();
                                try {
                                    String ddl;
                                    if (!rs.next() || CommonUtils.isEmpty((String)(ddl = JDBCUtils.safeGetString((ResultSet)rs, (String)"DDL")))) break block25;
                                    this.objectDefinitionText = ddl;
                                    string = ddl;
                                    if (rs == null) break block26;
                                }
                                catch (Throwable throwable4) {
                                    if (rs == null) throw throwable4;
                                    rs.close();
                                    throw throwable4;
                                }
                                rs.close();
                            }
                            if (ps == null) return string;
                        }
                        catch (Throwable throwable5) {
                            if (throwable3 == null) {
                                throwable3 = throwable5;
                                throw throwable3;
                            }
                            if (throwable3 == throwable5) throw throwable3;
                            throwable3.addSuppressed(throwable5);
                            throw throwable3;
                        }
                        ps.close();
                        return string;
                    }
                    catch (Throwable throwable6) {
                        if (throwable2 == null) {
                            throwable2 = throwable6;
                            throw throwable2;
                        }
                        if (throwable2 == throwable6) throw throwable2;
                        throwable2.addSuppressed(throwable6);
                        throw throwable2;
                    }
                }
                if (rs == null) return super.getObjectDefinitionText(monitor, options);
                rs.close();
                return super.getObjectDefinitionText(monitor, options);
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                    throw throwable;
                }
                if (throwable == throwable7) throw throwable;
                throwable.addSuppressed(throwable7);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error reading DDL", (Throwable)e);
        }
    }

    public void setObjectDefinitionText(String sourceText) {
        this.objectDefinitionText = sourceText;
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.objectDefinitionText = null;
        return super.refreshObject(monitor);
    }
}

