/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.sqlite.ui.views;

import com.dbeaver.db.sqlite.ui.internal.SQLiteUIMessages;
import com.dbeaver.db.sqlite.ui.views.SQLiteExtensionsPage;
import java.util.Arrays;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.jkiss.dbeaver.ext.generic.views.GenericConnectionPage;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class SQLiteConnectionPage
extends GenericConnectionPage {
    private Button databaseIsRemoteCheck;

    public void createAdvancedSettingsGroup(final Composite composite) {
        if (Arrays.stream(this.site.getDriver().getProviderPropertyDescriptors()).anyMatch(pd -> "sqlite-remote-enabled".equals(pd.getId()))) {
            Group group = UIUtils.createControlGroup((Composite)composite, (String)"Advanced", (int)1, (int)768, (int)0);
            this.databaseIsRemoteCheck = UIUtils.createCheckbox((Composite)group, (String)SQLiteUIMessages.page_connection_settings_is_remote_label, (String)SQLiteUIMessages.page_connection_settings_is_remote_tip, (boolean)false, (int)1);
            final Control remoteDatabaseTip = UIUtils.createInfoLabel((Composite)group, (String)SQLiteUIMessages.page_connection_settings_remote_ssh_hint, (int)768, (int)1);
            this.databaseIsRemoteCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UIUtils.setControlVisible((Control)remoteDatabaseTip, (boolean)SQLiteConnectionPage.this.databaseIsRemoteCheck.getSelection());
                    composite.layout(true, true);
                }
            });
        }
    }

    public void loadSettings() {
        DBPConnectionConfiguration configuration = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.databaseIsRemoteCheck != null) {
            this.databaseIsRemoteCheck.setSelection(CommonUtils.toBoolean((Object)configuration.getProperty("sqlite-remote-enabled")));
            this.databaseIsRemoteCheck.notifyListeners(13, new Event());
        }
        super.loadSettings();
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        if (this.databaseIsRemoteCheck != null) {
            dataSource.getConnectionConfiguration().setProperty("sqlite-remote-enabled", String.valueOf(this.databaseIsRemoteCheck.getSelection()));
        }
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new SQLiteExtensionsPage(), new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }

    protected boolean isAuthEnabled() {
        return !this.site.getDriver().isAnonymousAccess();
    }
}

