/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.teradata.model;

import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TeradataDateFormat
extends SimpleDateFormat {
    private static final Map<String, String> DATE_CASES = Map.of("M4", "MMMM", "M3", "MMM", "Y4", "yyyy", "YYYY", "yyyy", "YY", "yy", "E4", "EEEE", "E3", "EEE", "D3", "DD", "DDD", "DD", "DD", "dd");
    private static final Map<String, String> TIME_CASES = Map.of("MI", "mm", "SS", "ss", "S(6)", "SSS", "S(5)", "SSS", "S(4)", "SSS", "S(3)", "SSS", "S(2)", "SS", "S(F)", "SS", "S(1)", "S", "S(0)", "");
    private static final String DATE_CASES_PATTER = "(M[34])|(Y{4}|Y{2}|Y4)|(E[34])|(D{3}|D3|D{2})";
    private static final String TIME_CASES_PATTER = "MI|SS|\\.S\\(0\\)|S\\([0-6F]\\)";

    public TeradataDateFormat(String pattern) {
        this(pattern, Locale.getDefault());
    }

    public TeradataDateFormat(String pattern, Locale locale) {
        super(TeradataDateFormat.convertDateFormat(pattern.toUpperCase()), locale);
    }

    private static String convertDateFormat(String valueFormat) {
        Pattern datePattern = Pattern.compile(DATE_CASES_PATTER);
        Matcher matcher = datePattern.matcher(valueFormat);
        while (matcher.find()) {
            if (DATE_CASES.get(matcher.group()) == null) continue;
            valueFormat = valueFormat.replace(matcher.group(), DATE_CASES.get(matcher.group()));
        }
        Pattern timePattern = Pattern.compile(TIME_CASES_PATTER);
        matcher = timePattern.matcher(valueFormat);
        while (matcher.find()) {
            if (".S(0)".equals(matcher.group())) {
                valueFormat = valueFormat.replace(".S(0)", "");
            }
            if (TIME_CASES.get(matcher.group()) == null) continue;
            valueFormat = valueFormat.replace(matcher.group(), TIME_CASES.get(matcher.group()));
        }
        valueFormat = valueFormat.replaceAll("[Bb]", " ");
        return valueFormat;
    }
}

