/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.teradata.model;

import com.dbeaver.db.teradata.model.TeradataDatabase;
import com.dbeaver.db.teradata.model.TeradataDatasource;
import com.dbeaver.db.teradata.model.TeradataMap;
import com.dbeaver.db.teradata.model.TeradataUser;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.ByteNumberFormat;
import org.jkiss.utils.CommonUtils;

public class TeradataProfile
implements DBSObject,
DBPScriptObject,
DBPNamedObject2,
DBPSaveableObject {
    private static final Log log = Log.getLog(TeradataProfile.class);
    private static final String CAT_PASSWORD = "Password";
    private static final String CAT_QUERY_BAND = "Query Band";
    private final TeradataDatasource datasource;
    private String name;
    private String creatorName;
    private String defaultAccount;
    private TeradataDatabase defaultDB;
    private long spoolSpace;
    private long tempSpace;
    private TeradataMap defaultMap;
    private boolean overrideMapOnError;
    private Date createdTimestamp;
    private String description;
    private long passwordMinChar;
    private long passwordMaxChar;
    private long expirePassword;
    private long reusePassword;
    private long lockUser;
    private long maxLogonAttempts;
    private String passwordDigits;
    private String passwordSpecChar;
    private boolean passwordRestrictWords;
    private String queryBand;
    private String queryBandDefault;
    private String ignoreQueryBandValues;
    private boolean persisted;

    public TeradataProfile(@NotNull DBRProgressMonitor monitor, @NotNull TeradataDatasource datasource, @NotNull String name, @NotNull JDBCResultSet resultSet) {
        this.datasource = datasource;
        this.name = name;
        this.creatorName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"CreatorName");
        this.defaultAccount = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"DefaultAccount");
        String defaultDBName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"DefaultDB");
        if (CommonUtils.isNotEmpty((String)defaultDBName)) {
            List schemas = datasource.getSchemas();
            for (GenericSchema schema : schemas) {
                TeradataDatabase ted;
                if (!(schema instanceof TeradataDatabase) || (ted = (TeradataDatabase)schema).isUser() || !defaultDBName.equals(ted.getName())) continue;
                this.defaultDB = ted;
                break;
            }
        }
        this.spoolSpace = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"SpoolSpace");
        this.tempSpace = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"TempSpace");
        String defaultMapName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"DefaultMapName");
        if (CommonUtils.isNotEmpty((String)defaultMapName)) {
            try {
                this.defaultMap = datasource.getMap(monitor, defaultMapName);
            }
            catch (DBException dBException) {
                log.debug((Object)("Can't find map object with name " + defaultMapName));
            }
        }
        this.overrideMapOnError = "E".equals(JDBCUtils.safeGetString((ResultSet)resultSet, (String)"MapOverride"));
        this.createdTimestamp = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"CreateTimeStamp");
        this.description = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"CommentString");
        this.passwordMinChar = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"PasswordMinChar");
        this.passwordMaxChar = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"PasswordMaxChar");
        this.expirePassword = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"ExpirePassword");
        this.reusePassword = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"PasswordReuse");
        this.lockUser = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"LockedUserExpire");
        this.maxLogonAttempts = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"MaxLogonAttempts");
        this.passwordDigits = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"PasswordDigits");
        this.passwordSpecChar = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"PasswordSpecChar");
        this.passwordRestrictWords = "Y".equals(JDBCUtils.safeGetString((ResultSet)resultSet, (String)"PasswordRestrictWords"));
        this.queryBand = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"Queryband");
        this.queryBandDefault = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"QuerybandDefault");
        this.ignoreQueryBandValues = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"IgnoreQuerybandValues");
        this.persisted = true;
    }

    public TeradataProfile(@NotNull TeradataDatasource datasource, @NotNull String name) {
        this.datasource = datasource;
        this.name = name;
        this.persisted = false;
    }

    @NotNull
    public DBSObject getParentObject() {
        return this.datasource;
    }

    @NotNull
    public TeradataDatasource getDataSource() {
        return this.datasource;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String newName) {
        this.name = newName;
    }

    @Property(viewable=true, order=2)
    public String getCreatorName() {
        return this.creatorName;
    }

    @Property(viewable=true, editable=true, updatable=true, listProvider=DatabaseListProvider.class, order=3)
    @Nullable
    public TeradataDatabase getDefaultDB() {
        return this.defaultDB;
    }

    public void setDefaultDB(TeradataDatabase defaultDB) {
        this.defaultDB = defaultDB;
    }

    @Property(viewable=true, editable=true, updatable=true, order=4, formatter=ByteNumberFormat.class)
    public long getSpoolSpace() {
        return this.spoolSpace;
    }

    public void setSpoolSpace(long spoolSpace) {
        this.spoolSpace = spoolSpace;
    }

    @Property(viewable=true, editable=true, updatable=true, order=5, formatter=ByteNumberFormat.class)
    public long getTempSpace() {
        return this.tempSpace;
    }

    public void setTempSpace(long tempSpace) {
        this.tempSpace = tempSpace;
    }

    @Property(viewable=true, editable=true, updatable=true, listProvider=MapListProvider.class, order=6)
    @Nullable
    public TeradataMap getDefaultMap() {
        return this.defaultMap;
    }

    public void setDefaultMap(TeradataMap defaultMap) {
        this.defaultMap = defaultMap;
    }

    @Property(viewable=true, editable=true, updatable=true, order=7)
    public boolean isOverrideMapOnError() {
        return this.overrideMapOnError;
    }

    public void setOverrideMapOnError(boolean overrideMapOnError) {
        this.overrideMapOnError = overrideMapOnError;
    }

    @Property(viewable=true, order=8)
    public Date getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    @Property(viewable=true, order=9, category="Password")
    public long getPasswordMinChar() {
        return this.passwordMinChar;
    }

    @Property(viewable=true, order=10, category="Password")
    public long getPasswordMaxChar() {
        return this.passwordMaxChar;
    }

    @Property(viewable=true, order=11, category="Password")
    public long getExpirePassword() {
        return this.expirePassword;
    }

    @Property(viewable=true, order=12, category="Password")
    public long getReusePassword() {
        return this.reusePassword;
    }

    @Property(viewable=true, order=13, category="Password")
    public long getLockUser() {
        return this.lockUser;
    }

    @Property(viewable=true, order=14, category="Password")
    public long getMaxLogonAttempts() {
        return this.maxLogonAttempts;
    }

    @Property(viewable=true, order=15, category="Password")
    public String getPasswordDigits() {
        return this.passwordDigits;
    }

    @Property(viewable=true, order=16, category="Password")
    public String getPasswordSpecChar() {
        return this.passwordSpecChar;
    }

    @Property(viewable=true, order=17, category="Password")
    public boolean getPasswordRestrictWords() {
        return this.passwordRestrictWords;
    }

    @Property(viewable=true, order=18, category="Query Band")
    public String getQueryBand() {
        return this.queryBand;
    }

    @Property(viewable=true, order=19, category="Query Band")
    public String getQueryBandDefault() {
        return this.queryBandDefault;
    }

    @Property(viewable=true, order=20, category="Query Band")
    public String getIgnoreQueryBandValues() {
        return this.ignoreQueryBandValues;
    }

    @Property(viewable=true, updatable=true, length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    @Association
    @Nullable
    public Collection<TeradataUser> getUsers(@NotNull DBRProgressMonitor monitor) throws DBException {
        Collection<TeradataUser> users = this.datasource.getUsers(monitor);
        if (!CommonUtils.isEmpty(users)) {
            return users.stream().filter(e -> this.name.equals(e.getProfileName())).collect(Collectors.toList());
        }
        return null;
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) {
        StringBuilder sql = new StringBuilder(64);
        if (CommonUtils.getBoolean((Object)options.get("object.alter"), (boolean)false)) {
            sql.append("MODIFY ");
        } else {
            sql.append("CREATE ");
        }
        sql.append("PROFILE ").append(DBUtils.getQuotedIdentifier((DBSObject)this)).append(" AS ");
        if (CommonUtils.isNotEmpty((String)this.defaultAccount)) {
            sql.append("\n\tACCOUNT = '").append(this.defaultAccount).append("'");
        }
        if (this.defaultMap != null) {
            sql.append("\n\tDEFAULT MAP = ").append(DBUtils.getQuotedIdentifier((DBSObject)this.defaultMap));
            if (this.overrideMapOnError) {
                sql.append(" OVERRIDE ON ERROR");
            }
        }
        if (this.defaultDB != null) {
            sql.append("\n\tDEFAULT DATABASE = ").append(DBUtils.getQuotedIdentifier((DBSObject)this.defaultDB));
        }
        if (this.spoolSpace > 0L) {
            sql.append("\n\tSPOOL = ").append(this.spoolSpace);
        }
        if (this.tempSpace > 0L) {
            sql.append("\n\tTEMPORARY = ").append(this.tempSpace);
        }
        sql.append("\n\tPASSWORD = (");
        StringJoiner joiner = new StringJoiner(",\n\t\t");
        joiner.add("EXPIRE = " + this.expirePassword);
        if (this.passwordMinChar > 0L) {
            joiner.add("MINCHAR = " + this.passwordMinChar);
        }
        if (this.passwordMaxChar > 0L) {
            joiner.add("MAXCHAR = " + this.passwordMaxChar);
        }
        if (CommonUtils.isNotEmpty((String)this.passwordDigits)) {
            joiner.add("DIGITS = '" + this.passwordDigits + "'");
        }
        if (CommonUtils.isNotEmpty((String)this.passwordSpecChar)) {
            joiner.add("SPECCHAR = '" + this.passwordSpecChar + "'");
        }
        if (this.maxLogonAttempts > 0L) {
            joiner.add("MAXLOGONATTEMPTS = " + this.maxLogonAttempts);
        }
        if (this.lockUser > 0L) {
            joiner.add("LOCKEDUSEREXPIRE = " + this.lockUser);
        }
        if (this.reusePassword > 0L) {
            joiner.add("REUSE = " + this.reusePassword);
        }
        sql.append(joiner).append(")");
        if (CommonUtils.isNotEmpty((String)this.queryBand)) {
            sql.append("\n\tQUERY_BAND = '").append(this.queryBand).append("'");
            if ("D".equalsIgnoreCase(this.queryBandDefault)) {
                sql.append(" (DEFAULT)");
            }
        }
        return sql.toString();
    }

    public static class DatabaseListProvider
    implements IPropertyValueListProvider<TeradataProfile> {
        public boolean allowCustomValue() {
            return false;
        }

        @Nullable
        public Object[] getPossibleValues(TeradataProfile object) {
            ArrayList<TeradataDatabase> databases = new ArrayList<TeradataDatabase>();
            List schemas = object.getDataSource().getSchemas();
            for (GenericSchema schema : schemas) {
                TeradataDatabase ter;
                if (!(schema instanceof TeradataDatabase) || (ter = (TeradataDatabase)schema).isUser()) continue;
                databases.add(ter);
            }
            return databases.toArray();
        }
    }

    public static class MapListProvider
    implements IPropertyValueListProvider<TeradataProfile> {
        public boolean allowCustomValue() {
            return false;
        }

        @Nullable
        public Object[] getPossibleValues(TeradataProfile object) {
            return object.getDataSource().getMaps().toArray();
        }
    }
}

