/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.teradata.model;

import com.dbeaver.db.teradata.model.TeradataDatasource;
import com.dbeaver.db.teradata.model.TeradataPrivilege;
import com.dbeaver.db.teradata.model.TeradataRoleMember;
import com.dbeaver.db.teradata.model.TeradataUser;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBAObject;
import org.jkiss.dbeaver.model.access.DBARole;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class TeradataRole
implements DBARole,
DBPScriptObject,
DBPNamedObject2,
DBPSaveableObject {
    private static final Log log = Log.getLog(TeradataRole.class);
    private final TeradataDatasource datasource;
    private String name;
    private String creatorName;
    private Date createdTimestamp;
    private String description;
    private boolean external;
    private boolean persisted;
    private RoleMemberCache roleMemberCache = new RoleMemberCache();
    private RolePrivilegeCache rolePrivilegesCache = new RolePrivilegeCache();

    TeradataRole(@NotNull TeradataDatasource datasource, @NotNull String name, @NotNull JDBCResultSet resultSet) {
        this.datasource = datasource;
        this.name = name;
        this.creatorName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"CreatorName");
        this.description = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"CommentString");
        this.createdTimestamp = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"CreateTimeStamp");
        this.external = "Y".equals(JDBCUtils.safeGetString((ResultSet)resultSet, (String)"ExtRole"));
        this.persisted = true;
    }

    public TeradataRole(@NotNull TeradataDatasource datasource, @NotNull String name) {
        this.datasource = datasource;
        this.name = name;
        this.persisted = false;
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.datasource;
    }

    @NotNull
    public TeradataDatasource getDataSource() {
        return this.datasource;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String newName) {
        this.name = newName;
    }

    @Property(viewable=true, order=2)
    public String getCreatorName() {
        return this.creatorName;
    }

    @Property(viewable=true, order=3)
    public Date getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    @Property(viewable=true, order=4)
    public boolean isExternal() {
        return this.external;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    @Property(viewable=true, updatable=true, length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Association
    public Collection<TeradataRoleMember> getRoleMembers(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.roleMemberCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public TeradataRoleMember getRoleMember(@NotNull DBRProgressMonitor monitor, @NotNull String name) throws DBException {
        return (TeradataRoleMember)this.roleMemberCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<TeradataPrivilege> getPrivileges(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.rolePrivilegesCache.getAllObjects(monitor, (DBSObject)this);
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    @Association
    @Nullable
    public Collection<TeradataUser> getUsers(@NotNull DBRProgressMonitor monitor) throws DBException {
        Collection<TeradataUser> users = this.datasource.getUsers(monitor);
        if (!CommonUtils.isEmpty(users)) {
            return users.stream().filter(e -> this.name.equals(e.getRoleName())).collect(Collectors.toList());
        }
        return null;
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) {
        return "CREATE " + (this.isExternal() ? "EXTERNAL " : "") + "ROLE " + DBUtils.getQuotedIdentifier((DBSObject)this);
    }

    class RoleMemberCache
    extends JDBCObjectCache<TeradataRole, TeradataRoleMember> {
        RoleMemberCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull TeradataRole teradataRole) throws SQLException {
            String sql = "SELECT * FROM DBC.RoleMembersV WHERE RoleName = ?";
            JDBCPreparedStatement statement = session.prepareStatement(sql);
            statement.setString(1, teradataRole.getName());
            return statement;
        }

        @Nullable
        protected TeradataRoleMember fetchObject(@NotNull JDBCSession session, @NotNull TeradataRole teradataRole, @NotNull JDBCResultSet resultSet) {
            return new TeradataRoleMember(session.getProgressMonitor(), teradataRole.getDataSource(), teradataRole, resultSet);
        }
    }

    class RolePrivilegeCache
    extends JDBCObjectCache<TeradataRole, TeradataPrivilege> {
        RolePrivilegeCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull TeradataRole teradataRole) throws SQLException {
            String sql = "SELECT rr.* FROM DBC.AllRoleRightsV rr\nINNER JOIN DBC.RoleMembersV rm\nON rr.RoleName = rm.RoleName\nWHERE rm.grantee = ?\nUNION\nSELECT rr.* FROM DBC.AllRoleRightsV rr\nWHERE rr.RoleName = ?";
            JDBCPreparedStatement statement = session.prepareStatement(sql);
            statement.setString(1, teradataRole.getName());
            statement.setString(2, teradataRole.getName());
            return statement;
        }

        @Nullable
        protected TeradataPrivilege fetchObject(@NotNull JDBCSession session, @NotNull TeradataRole teradataRole, @NotNull JDBCResultSet resultSet) {
            String accessRightCode = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"AccessRight");
            if (CommonUtils.isEmpty((String)accessRightCode)) {
                log.debug((Object)("Can't read access right for role " + teradataRole.getName()));
                return null;
            }
            return new TeradataPrivilege(teradataRole.getDataSource(), (DBAObject)teradataRole, accessRightCode, resultSet);
        }
    }
}

