/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.vertica.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericFunctionResultType;
import org.jkiss.dbeaver.ext.generic.model.GenericPackage;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.vertica.model.VerticaSchema;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPOverloadedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectWithScript;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.utils.CommonUtils;

public abstract class VerticaStoredCode
extends GenericProcedure
implements DBPOverloadedObject,
DBSObjectWithScript {
    private static final Log log = Log.getLog(VerticaStoredCode.class);
    private String functionType;
    private String functionDefinition;
    private String volatility;
    private boolean isStrict;
    private boolean isFenced;
    private String description;
    private String funcReturnType;
    protected String funcArgumentType;
    private String fullDefinition;

    public VerticaStoredCode(GenericStructContainer container, String functionName, DBSProcedureType procedureType, String description, ResultSet dbResult) {
        super(container, functionName, null, description, procedureType, null);
        this.functionType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"procedure_type");
        this.functionDefinition = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"function_definition");
        this.volatility = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"volatility");
        this.isStrict = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_strict");
        this.isFenced = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_fenced");
        this.funcReturnType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"function_return_type");
        this.funcArgumentType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"function_argument_type");
        this.description = description;
    }

    protected VerticaStoredCode(VerticaSchema container, String name, DBSProcedureType procedureType) {
        super((GenericStructContainer)container, name, null, procedureType, null, false);
        this.functionDefinition = "";
        this.funcArgumentType = "";
    }

    public GenericCatalog getCatalog() {
        return super.getCatalog();
    }

    public GenericFunctionResultType getFunctionResultType() {
        return null;
    }

    public GenericPackage getPackage() {
        return super.getPackage();
    }

    @Property(viewable=true, order=8, editable=true)
    public String getFunctionType() {
        return this.functionType;
    }

    @Property(viewable=true, order=9)
    public String getVolatility() {
        return this.volatility;
    }

    @Property(viewable=true, order=10)
    public boolean isStrict() {
        return this.isStrict;
    }

    @Property(viewable=true, order=11)
    public boolean isFenced() {
        return this.isFenced;
    }

    @Property(viewable=true, length=PropertyLength.MULTILINE, editable=true, updatable=true, order=12)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @NotNull
    public String getOverloadedName() {
        return this.getName() + this.getFunctionSignature();
    }

    public String getFunctionSignature() {
        return "(" + this.funcArgumentType + ")";
    }

    public String getSourceCode(DBRProgressMonitor monitor) throws DBCException {
        block28: {
            if (this.fullDefinition != null) {
                return this.fullDefinition;
            }
            if (!this.isPersisted()) {
                this.functionDefinition = "";
            } else if (CommonUtils.isEmpty((String)this.functionDefinition)) {
                try {
                    Throwable throwable = null;
                    Object var3_7 = null;
                    try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this.container, (String)"Read Vertica functions");){
                        try {
                            String funcName = ((GenericDataSource)this.getDataSource()).isServerVersionAtLeast(12, 0) ? this.getOverloadedName() : this.getFullyQualifiedName(DBPEvaluationContext.DDL);
                            String query = "SELECT EXPORT_OBJECTS('','" + funcName + "');";
                            this.functionDefinition = JDBCUtils.queryString((Connection)session, (String)query, (Object[])new Object[0]);
                        }
                        catch (SQLException e) {
                            if (this.getProcedureType() == DBSProcedureType.FUNCTION) {
                                this.functionDefinition = JDBCUtils.queryString((Connection)session, (String)"SELECT function_definition FROM v_catalog.user_functions WHERE schema_name=? AND function_name=?", (Object[])new Object[]{this.getSchema().getName(), this.getName()});
                                break block28;
                            }
                            throw e;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    throw new DBCException("Error reading procedure definition", (Throwable)e);
                }
            }
        }
        if (this.functionDefinition == null) {
            this.functionDefinition = "-- Cannot find function definition";
        } else {
            this.functionDefinition = this.functionDefinition.trim();
            int divPos = this.functionDefinition.indexOf("SELECT MARK_DESIGN_KSAFE");
            if (divPos != -1) {
                this.functionDefinition = this.functionDefinition.substring(0, divPos).trim();
            }
        }
        if (this.fullDefinition == null) {
            if (!this.functionDefinition.startsWith("Class ") && !this.functionDefinition.startsWith("CREATE")) {
                StringBuilder definition = new StringBuilder();
                if (this.getProcedureType() == DBSProcedureType.PROCEDURE) {
                    definition.append("CREATE PROCEDURE ").append(this.getFullyQualifiedName(DBPEvaluationContext.DDL)).append("(");
                    if (CommonUtils.isNotEmpty((String)this.funcArgumentType)) {
                        definition.append(this.funcArgumentType);
                    }
                    definition.append(")");
                    definition.append("\nLANGUAGE 'PL/vSQL'");
                    definition.append("\nSECURITY INVOKER");
                    definition.append("\nAS 'BEGIN\n\t").append(this.functionDefinition).append(";\nEND'");
                } else {
                    definition.append("CREATE OR REPLACE FUNCTION ").append(this.getFullyQualifiedName(DBPEvaluationContext.DDL)).append("(");
                    if (CommonUtils.isNotEmpty((String)this.funcArgumentType)) {
                        definition.append(this.funcArgumentType);
                    }
                    definition.append(") RETURN ").append(this.funcReturnType).append("\nAS BEGIN\n\t").append(this.functionDefinition).append(";\nEND");
                }
                this.fullDefinition = definition.toString();
            } else {
                this.fullDefinition = this.functionDefinition;
            }
        }
        return this.fullDefinition;
    }

    @Property(hidden=true, editable=true, updatable=true)
    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        return super.getObjectDefinitionText(monitor, options);
    }

    public void setObjectDefinitionText(String source) {
        this.fullDefinition = source;
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.functionDefinition = null;
        this.fullDefinition = null;
        return super.refreshObject(monitor);
    }
}

