/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.vertica.model.plan;

import com.dbeaver.db.vertica.model.plan.VerticaPlanNode;
import com.google.gson.Gson;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlan;

public class VerticaExecutionPlan
extends AbstractExecutionPlan {
    private static final Gson gson = new Gson();
    private final String query;
    private final List<VerticaPlanNode> nodes;

    VerticaExecutionPlan(String query) {
        this.query = query;
        this.nodes = new ArrayList<VerticaPlanNode>();
    }

    VerticaExecutionPlan(String query, List<VerticaPlanNode> nodes) {
        this.query = query;
        this.nodes = nodes;
    }

    public String getQueryString() {
        return this.query;
    }

    public String getPlanQueryString() {
        return "EXPLAIN VERBOSE JSON " + this.query;
    }

    public List<VerticaPlanNode> getPlanNodes(Map<String, Object> options) {
        return this.nodes;
    }

    public Object getPlanFeature(String feature) {
        if ("plan.cost".equals(feature) || "plan.rows".equals(feature)) {
            return true;
        }
        return super.getPlanFeature(feature);
    }

    void explain(@NotNull DBCSession session) throws DBCException {
        block22: {
            JDBCSession connection = (JDBCSession)session;
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (JDBCStatement stmt = connection.createStatement();){
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (JDBCResultSet result = stmt.executeQuery(this.getPlanQueryString());){
                        if (result != null) {
                            StringBuilder builder = new StringBuilder();
                            while (result.next()) {
                                String line = result.getString(1);
                                if (line == null) continue;
                                builder.append(line).append("\n");
                            }
                            String plan = builder.toString();
                            this.nodes.clear();
                            this.nodes.addAll(this.parse(plan));
                            break block22;
                        }
                        throw new DBCException("Query plan is not available");
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, session.getExecutionContext());
            }
        }
    }

    @NotNull
    private List<VerticaPlanNode> parse(@NotNull String jsonPlan) {
        Map objectMap = JSONUtils.parseMap((Gson)gson, (Reader)new StringReader(jsonPlan));
        return Collections.singletonList(new VerticaPlanNode(null, JSONUtils.getObject((Map)objectMap, (String)"PLAN")));
    }
}

