/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.vertica.model.plan;

import com.dbeaver.db.vertica.model.plan.VerticaExecutionPlan;
import com.dbeaver.db.vertica.model.plan.VerticaPlanNode;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.vertica.model.VerticaDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanStyle;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerConfiguration;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerSerialInfo;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlanSerializer;
import org.jkiss.dbeaver.model.impl.plan.ExecutionPlanDeserializer;

public class VerticaQueryPlanner
extends AbstractExecutionPlanSerializer
implements DBCQueryPlanner {
    private final VerticaDataSource dataSource;

    public VerticaQueryPlanner(VerticaDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public DBCPlan planQueryExecution(@NotNull DBCSession session, @NotNull String query, @NotNull DBCQueryPlannerConfiguration configuration) throws DBException {
        VerticaExecutionPlan plan = new VerticaExecutionPlan(query);
        plan.explain(session);
        return plan;
    }

    @NotNull
    public DBCPlanStyle getPlanStyle() {
        return DBCPlanStyle.PLAN;
    }

    public void serialize(@NotNull Writer planData, @NotNull DBCPlan plan) throws IOException {
        this.serializeJson(planData, plan, this.dataSource.getInfo().getDriverName(), new DBCQueryPlannerSerialInfo(){

            public String version() {
                return "json";
            }

            public void addNodeProperties(DBCPlanNode node, JsonObject nodeJson) {
                JsonArray attributes = new JsonArray();
                if (node instanceof VerticaPlanNode) {
                    VerticaPlanNode planNode = (VerticaPlanNode)node;
                    for (Map.Entry<String, Object> element : planNode.getAttributes().entrySet()) {
                        JsonObject attr = new JsonObject();
                        Object value = element.getValue();
                        if (value instanceof Double) {
                            attr.add(element.getKey(), (JsonElement)new JsonPrimitive((Number)((Double)value)));
                        } else {
                            attr.add(element.getKey(), (JsonElement)new JsonPrimitive(value.toString()));
                        }
                        attributes.add((JsonElement)attr);
                    }
                }
                nodeJson.add("attributes", (JsonElement)attributes);
            }
        });
    }

    public DBCPlan deserialize(@NotNull Reader planData) throws InvocationTargetException {
        try {
            JsonObject jsonObject = new JsonParser().parse(planData).getAsJsonObject();
            String query = this.getQuery(jsonObject);
            ExecutionPlanDeserializer loader = new ExecutionPlanDeserializer();
            List rootNodes = loader.loadRoot((DBPDataSource)this.dataSource, jsonObject, (datasource, node, parent) -> new VerticaPlanNode(this.getNodeAttributes(node), (VerticaPlanNode)parent));
            return new VerticaExecutionPlan(query, rootNodes);
        }
        catch (Throwable e) {
            throw new InvocationTargetException(e);
        }
    }
}

