/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.ycql.data;

import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.dbeaver.db.ycql.CasUtils;
import com.dbeaver.db.ycql.data.CasAbstractValue;
import com.dbeaver.db.ycql.data.CasListValue;
import com.dbeaver.db.ycql.data.CasMapValue;
import com.dbeaver.db.ycql.data.CasSetValue;
import com.dbeaver.db.ycql.data.CasUDTValue;
import com.dbeaver.db.ycql.data.YcqlContentJSON;
import com.dbeaver.db.ycql.model.CasDataSource;
import com.dbeaver.db.ycql.model.CasExecutionContext;
import com.dbeaver.db.ycql.model.CasTupleType;
import com.dbeaver.db.ycql.model.CasTupleTypeAttribute;
import com.dbeaver.model.data.DBContentByteBuffer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;

public class CasTupleValue
extends CasAbstractValue
implements DBDComposite,
DBDValueCloneable {
    private static final Log log = Log.getLog(CasTupleValue.class);
    @Nullable
    private TupleValue rawValue;
    @Nullable
    private CasTupleType tupleType;

    public CasTupleValue(@NotNull CasExecutionContext executionContext, @NotNull String keyspace, @Nullable TupleValue value) throws DBCException {
        super(executionContext, keyspace);
        this.rawValue = value;
        this.tupleType = value == null ? null : ((CasDataSource)executionContext.getDataSource()).getCachedTupleType(value.getType());
    }

    public CasTupleValue(CasTupleValue value) {
        super(value);
        this.rawValue = value.rawValue;
        this.tupleType = value.tupleType;
    }

    public DBDValueCloneable cloneValue(DBRProgressMonitor monitor) {
        return new CasTupleValue(this);
    }

    public TupleValue getRawValue() {
        return this.rawValue;
    }

    public boolean isNull() {
        return this.rawValue == null;
    }

    public boolean isModified() {
        return false;
    }

    public void release() {
        this.rawValue = null;
    }

    public String toString() {
        if (this.isNull()) {
            return "[NULL]";
        }
        return this.rawValue.toString();
    }

    public CasTupleType getDataType() {
        return this.tupleType;
    }

    @NotNull
    public DBSAttributeBase[] getAttributes() {
        if (this.tupleType == null) {
            return new DBSAttributeBase[0];
        }
        try {
            List<CasTupleTypeAttribute> attrs = this.tupleType.getAttributes((DBRProgressMonitor)new VoidProgressMonitor());
            if (attrs == null) {
                return new DBSAttributeBase[0];
            }
            DBSAttributeBase[] result = new DBSAttributeBase[attrs.size()];
            attrs.toArray(result);
            return result;
        }
        catch (DBException e) {
            log.error((Object)e);
            return new DBSAttributeBase[0];
        }
    }

    @Nullable
    public Object getAttributeValue(@NotNull DBSAttributeBase attribute) throws DBCException {
        if (this.rawValue == null) {
            return null;
        }
        int index = attribute.getOrdinalPosition() - 1;
        DataType type = ((CasTupleTypeAttribute)attribute).getCasDataType();
        switch (type.getProtocolCode()) {
            case 1: 
            case 13: {
                return this.rawValue.getString(index);
            }
            case 20: {
                return this.rawValue.getByte(index);
            }
            case 19: {
                return this.rawValue.getShort(index);
            }
            case 9: {
                return this.rawValue.getInt(index);
            }
            case 2: {
                return this.rawValue.getLong(index);
            }
            case 5: {
                return this.rawValue.getLong(index);
            }
            case 14: {
                return this.rawValue.getBigInteger(index);
            }
            case 6: {
                return this.rawValue.getBigDecimal(index);
            }
            case 8: {
                return Float.valueOf(this.rawValue.getFloat(index));
            }
            case 7: {
                return this.rawValue.getDouble(index);
            }
            case 4: {
                return this.rawValue.getBool(index);
            }
            case 17: {
                return this.rawValue.getLocalDate(index);
            }
            case 18: {
                return this.rawValue.getLocalTime(index);
            }
            case 11: {
                return this.rawValue.getInstant(index);
            }
            case 12: 
            case 15: {
                return this.rawValue.getUuid(index);
            }
            case 16: {
                return this.rawValue.getInetAddress(index);
            }
            case 33: {
                return new CasMapValue(this.executionContext, this.keyspace, this.rawValue.getMap(index, CasUtils.getClassFromType(((MapType)type).getKeyType()).getRawType(), CasUtils.getClassFromType(((MapType)type).getValueType()).getRawType()), (MapType)type);
            }
            case 32: {
                return new CasListValue((DBRProgressMonitor)new VoidProgressMonitor(), this.executionContext, this.keyspace, this.rawValue.getList(index, CasUtils.getClassFromType(((ListType)type).getElementType()).getRawType()), (ListType)type);
            }
            case 34: {
                return new CasSetValue(this.executionContext, this.keyspace, this.rawValue.getSet(index, CasUtils.getClassFromType(((SetType)type).getElementType()).getRawType()), (SetType)type);
            }
            case 49: {
                return new CasTupleValue(this.executionContext, this.keyspace, this.rawValue.getTupleValue(index));
            }
            case 48: {
                return new CasUDTValue(this.executionContext, this.keyspace, this.rawValue.getUdtValue(index));
            }
            case 128: {
                return new YcqlContentJSON((DBCExecutionContext)this.executionContext, (String)this.rawValue.get(index, TypeCodecs.JSONB));
            }
        }
        return new DBContentByteBuffer((DBCExecutionContext)this.executionContext, this.rawValue.getByteBuffer(index));
    }

    public void setAttributeValue(@NotNull DBSAttributeBase attribute, @Nullable Object value) throws DBCException {
        if (this.rawValue == null) {
            this.rawValue = this.tupleType.getMetadata().newValue();
        }
        int index = attribute.getOrdinalPosition() - 1;
        if (value == null) {
            this.rawValue.setToNull(index);
            return;
        }
        DataType type = ((CasTupleTypeAttribute)attribute).getCasDataType();
        switch (type.getProtocolCode()) {
            case 1: 
            case 13: {
                this.rawValue = (TupleValue)this.rawValue.setString(index, (String)value);
                break;
            }
            case 20: {
                this.rawValue = (TupleValue)this.rawValue.setByte(index, ((Byte)value).byteValue());
                break;
            }
            case 19: {
                this.rawValue = (TupleValue)this.rawValue.setShort(index, ((Short)value).shortValue());
                break;
            }
            case 9: {
                this.rawValue = (TupleValue)this.rawValue.setInt(index, ((Integer)value).intValue());
                break;
            }
            case 2: {
                this.rawValue = (TupleValue)this.rawValue.setLong(index, ((Long)value).longValue());
                break;
            }
            case 5: {
                this.rawValue.setLong(index, ((Long)value).longValue());
                break;
            }
            case 14: {
                this.rawValue = (TupleValue)this.rawValue.setBigInteger(index, (BigInteger)value);
                break;
            }
            case 6: {
                this.rawValue = (TupleValue)this.rawValue.setBigDecimal(index, (BigDecimal)value);
                break;
            }
            case 8: {
                this.rawValue = (TupleValue)this.rawValue.setFloat(index, ((Float)value).floatValue());
                break;
            }
            case 7: {
                this.rawValue = (TupleValue)this.rawValue.setDouble(index, ((Double)value).doubleValue());
                break;
            }
            case 4: {
                this.rawValue = (TupleValue)this.rawValue.setBoolean(index, ((Boolean)value).booleanValue());
                break;
            }
            case 17: {
                this.rawValue = (TupleValue)this.rawValue.setLocalDate(index, (LocalDate)value);
                break;
            }
            case 18: {
                this.rawValue = (TupleValue)this.rawValue.setLocalTime(index, LocalTime.ofSecondOfDay((Long)value));
                break;
            }
            case 11: {
                this.rawValue = (TupleValue)this.rawValue.setInstant(index, ((Date)value).toInstant());
                break;
            }
            case 12: 
            case 15: {
                this.rawValue = (TupleValue)this.rawValue.setUuid(index, (UUID)value);
                break;
            }
            case 16: {
                this.rawValue = (TupleValue)this.rawValue.setInetAddress(index, (InetAddress)value);
                break;
            }
            case 33: {
                this.rawValue = (TupleValue)this.rawValue.setMap(index, (Map)value, Object.class, Object.class);
                break;
            }
            case 32: {
                this.rawValue = (TupleValue)this.rawValue.setList(index, (List)value, Object.class);
                break;
            }
            case 34: {
                this.rawValue = (TupleValue)this.rawValue.setSet(index, (Set)value, Object.class);
            }
            case 49: {
                this.rawValue = (TupleValue)this.rawValue.setTupleValue(index, (TupleValue)value);
                break;
            }
            case 48: {
                this.rawValue = (TupleValue)this.rawValue.setUdtValue(index, (UdtValue)value);
                break;
            }
            default: {
                this.rawValue = (TupleValue)this.rawValue.setByteBuffer(index, (ByteBuffer)value);
            }
        }
    }
}

