/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.ycql.data.handlers;

import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.dbeaver.db.ycql.data.CasUDTValue;
import com.dbeaver.db.ycql.data.handlers.CasComplexValueHandler;
import com.dbeaver.db.ycql.exec.CasPreparedStatement;
import com.dbeaver.db.ycql.exec.CasSession;
import com.dbeaver.db.ycql.model.CasDataSource;
import com.dbeaver.db.ycql.model.CasExecutionContext;
import com.dbeaver.db.ycql.model.CasTableColumn;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class CasUDTValueHandler
extends CasComplexValueHandler {
    private static final Log log = Log.getLog(CasUDTValueHandler.class);
    public static final CasUDTValueHandler INSTANCE = new CasUDTValueHandler();

    @NotNull
    public Class<CasUDTValue> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return CasUDTValue.class;
    }

    public CasUDTValue getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object == null) {
            if (type instanceof CasTableColumn) {
                ((CasTableColumn)type).getMetadata().getType();
            }
            CasDataSource dataSource = (CasDataSource)session.getDataSource();
            return new CasUDTValue((CasExecutionContext)session.getExecutionContext(), dataSource.getDefaultKeyspaceName(), null);
        }
        if (object instanceof CasUDTValue) {
            return copy ? new CasUDTValue((CasUDTValue)object) : (CasUDTValue)object;
        }
        throw new DBCException("Unsupported UDT type: " + object.getClass().getName());
    }

    @Override
    protected void bindParameter(CasSession session, CasPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException {
        if (((CasUDTValue)value).getRawValue() == null) {
            statement.updateBoundStatement((BoundStatement)statement.getBoundStatement().setToNull(paramIndex));
            return;
        }
        statement.updateBoundStatement((BoundStatement)statement.getBoundStatement().setUdtValue(paramIndex, ((CasUDTValue)value).getRawValue()));
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (value instanceof UdtValue) {
            return ((UdtValue)value).getFormattedContents();
        }
        if (value instanceof CasUDTValue) {
            return value.toString();
        }
        return super.getValueDisplayString(column, value, format);
    }
}

