/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mockdata.engine.generator.advanced.finnegan;

import com.dbeaver.ee.mockdata.engine.util.FNV1a;
import java.io.Serializable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Finnegan
implements Serializable {
    private static final long serialVersionUID = -2578460257281186353L;
    public final String[] openingVowels;
    public final String[] midVowels;
    public final String[] openingConsonants;
    public final String[] midConsonants;
    public final String[] closingConsonants;
    public final String[] vowelSplitters;
    public final String[] closingSyllables;
    public boolean clean;
    public final LinkedHashMap<Integer, Double> syllableFrequencies;
    protected double totalSyllableFrequency = 0.0;
    public final double vowelStartFrequency;
    public final double vowelEndFrequency;
    public final double vowelSplitFrequency;
    public final double syllableEndFrequency;
    protected final Pattern[] sanityChecks;
    public ArrayList<Modifier> modifiers;
    protected static final Pattern repeats = Pattern.compile("(.)\\1+");
    protected static final Pattern diacritics = Pattern.compile("[\\u0300-\\u036F\\u1DC0-\\u1DFF]+");
    public static final Pattern[] vulgarChecks = new Pattern[]{Pattern.compile("[Ss\u03beCc\u0441\u03c2\u0421][h\u043d\u041d].*[dt\u0442\u03c4\u0422\u03a4f]"), Pattern.compile("([Pp\u0440\u03c1\u0420\u03a1][h\u043d\u041d])|[Kk\u043a\u03ba\u041a\u039aFfDdCc\u0441\u03c2\u0421].{1,4}[Kk\u043a\u03ba\u041a\u039aCc\u0441\u03c2\u0421x\u0445\u0436\u03c7\u0425\u0416\u03a7]"), Pattern.compile("[Bb\u044a\u044b\u0431\u0432\u03b2\u042a\u042b\u0411\u0412\u0392]..?.?[c\u0441\u03c2\u0421][h\u043d\u041d]"), Pattern.compile("[Ww\u0448\u0449\u03c8\u0428\u0429Hh\u043d\u041d]..?[r\u044f\u042f]"), Pattern.compile("[Tt\u0442\u03c4\u0422\u03a4]..?[t\u0442\u03c4\u0422\u03a4]"), Pattern.compile("([Pp\u0440\u03c1\u0420\u03a1][h\u043d\u041d])|[Ff]..?[r\u044f\u042f][t\u0442\u03c4\u0422\u03a4]"), Pattern.compile("([Ss\u03be][h\u043d\u041d])|[j][i\u03c4\u03b9\u0399].?[s\u03bez\u0396]"), Pattern.compile("[Aa\u0430\u03b1\u0410\u0391\u039b][Nn\u0438\u0439\u0418\u0419\u039d]..?[Ss\u03bel\u03b9\u03b6z\u0396]"), Pattern.compile("[Aa\u0430\u03b1\u0410\u0391\u039b][s\u03be][s\u03be]"), Pattern.compile(".[u\u03bc\u03c5\u03bd][h\u043d\u041d]?[n\u0438\u0439\u0418\u0419\u039d]+[t\u0442\u03c4\u0422\u03a4]"), Pattern.compile("[NnFf]..?g"), Pattern.compile("[Pp\u0440\u03c1\u0420\u03a1][e\u0435\u0451\u0437\u03be\u03b5\u0415\u0401\u0417\u039e\u0395\u03a3io\u043e\u044e\u03c3\u03bf\u041e\u042e\u039fu\u03bc\u03c5\u03bd][e\u0435\u0451\u0437\u03be\u03b5\u0415\u0401\u0417\u039e\u0395\u03a3o\u043e\u044e\u03c3\u03bf\u041e\u042e\u039fs]"), Pattern.compile("[Mm\u043c\u041c\u039c]..?[r\u044f\u042f].?d"), Pattern.compile("[Gg][h\u043d\u041d]?[a\u0430\u03b1\u0410\u0391\u039be\u0435\u0451\u0437\u03be\u03b5\u0415\u0401\u0417\u039e\u0395\u03a3][y\u0443\u03bb\u03b3\u0423\u03a5e\u0435\u0451\u0437\u03be\u03b5\u0415\u0401\u0417\u039e\u0395\u03a3]")};
    public static final Pattern[] englishSanityChecks = new Pattern[]{Pattern.compile("[AEIOUaeiou]{3}"), Pattern.compile("(\\w)\\1\\1"), Pattern.compile("(.)\\1(.)\\2"), Pattern.compile("[Aa][ae]"), Pattern.compile("[Uu][umlkj]"), Pattern.compile("[Ii][iyqkhrl]"), Pattern.compile("[Oo][c]"), Pattern.compile("[Yy][aeiou]{2}"), Pattern.compile("[Rr][aeiouy]+[xrhp]"), Pattern.compile("[Qq]u[yu]"), Pattern.compile("[^oai]uch"), Pattern.compile("[^tcsz]hh"), Pattern.compile("[Hh][tcszi]h"), Pattern.compile("[Tt]t[^aeiouy]{2}"), Pattern.compile("[IYiy]h[^aeiouy ]"), Pattern.compile("[szSZrlRL][^aeiou][rlsz]"), Pattern.compile("[UIuiYy][wy]"), Pattern.compile("^[UIui][ae]"), Pattern.compile("q$")};
    public static final Pattern[] japaneseSanityChecks = new Pattern[]{Pattern.compile("[AEIOUaeiou]{3}"), Pattern.compile("(\\w)\\1\\1"), Pattern.compile("[Tt]s[^u]"), Pattern.compile("[Ff][^u]"), Pattern.compile("[Yy][^auo]"), Pattern.compile("[Tt][ui]"), Pattern.compile("[SsZzDd]i"), Pattern.compile("[Hh]u")};
    public RNG rng;
    public static final char[][] accentedVowels = new char[][]{{'\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u0101', '\u0103', '\u0105', '\u01fb', '\u01fd'}, {'\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u0113', '\u0115', '\u0117', '\u0119', '\u011b'}, {'\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u0129', '\u012b', '\u012d', '\u012f', '\u0131'}, {'\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f8', '\u014d', '\u014f', '\u0151', '\u0153', '\u01ff'}, {'\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u0169', '\u016b', '\u016d', '\u016f', '\u0171', '\u0173'}};
    public static final char[][] accentedConsonants = new char[][]{{'b'}, {'c', '\u00e7', '\u0107', '\u0109', '\u010b', '\u010d'}, {'d', '\u00fe', '\u00f0', '\u010f', '\u0111'}, {'f'}, {'g', '\u011d', '\u011f', '\u0121', '\u0123'}, {'h', '\u0125', '\u0127'}, {'j', '\u0135', '\u0237'}, {'k', '\u0137'}, {'l', '\u013a', '\u013c', '\u013e', '\u0140', '\u0142'}, {'m'}, {'n', '\u00f1', '\u0144', '\u0146', '\u0148', '\u014b'}, {'p'}, {'q'}, {'r', '\u0155', '\u0157', '\u0159'}, {'s', '\u015b', '\u015d', '\u015f', '\u0161', '\u0219'}, {'t', '\u0163', '\u0165', '\u021b'}, {'v'}, {'w', '\u0175', '\u1e81', '\u1e83', '\u1e85'}, {'x'}, {'y', '\u00fd', '\u00ff', '\u0177', '\u1ef3'}, {'z', '\u017a', '\u017c', '\u017e'}};
    public static final Finnegan LOVECRAFT = new Finnegan(new String[]{"a", "i", "o", "e", "u", "a", "i", "o", "e", "u", "ia", "ai", "aa", "ei"}, new String[0], new String[]{"s", "t", "k", "n", "y", "p", "k", "l", "g", "gl", "th", "sh", "ny", "ft", "hm", "zvr", "cth"}, new String[]{"h", "gl", "gr", "nd", "mr", "vr", "kr"}, new String[]{"l", "p", "s", "t", "n", "k", "g", "x", "rl", "th", "gg", "gh", "ts", "lt", "rk", "kh", "sh", "ng", "shk"}, new String[]{"aghn", "ulhu", "urath", "oigor", "alos", "'yeh", "achtal", "urath", "ikhet", "adzek"}, new String[]{"'", "-"}, new int[]{1, 2, 3}, new double[]{6.0, 7.0, 2.0}, 0.4, 0.31, 0.07, 0.04, null, true);
    public static final Finnegan ENGLISH = new Finnegan(new String[]{"a", "a", "a", "a", "o", "o", "o", "e", "e", "e", "e", "e", "i", "i", "i", "i", "u", "a", "a", "a", "a", "o", "o", "o", "e", "e", "e", "e", "e", "i", "i", "i", "i", "u", "a", "a", "a", "o", "o", "e", "e", "e", "i", "i", "i", "u", "a", "a", "a", "o", "o", "e", "e", "e", "i", "i", "i", "u", "au", "ai", "ai", "ou", "ea", "ie", "io", "ei"}, new String[]{"u", "u", "oa", "oo", "oo", "oo", "ee", "ee", "ee", "ee"}, new String[]{"b", "bl", "br", "c", "cl", "cr", "ch", "d", "dr", "f", "fl", "fr", "g", "gl", "gr", "h", "j", "k", "l", "m", "n", "p", "pl", "pr", "qu", "r", "s", "sh", "sk", "st", "sp", "sl", "sm", "sn", "t", "tr", "th", "thr", "v", "w", "y", "z", "b", "bl", "br", "c", "cl", "cr", "ch", "d", "dr", "f", "fl", "fr", "g", "gr", "h", "j", "k", "l", "m", "n", "p", "pl", "pr", "r", "s", "sh", "st", "sp", "sl", "t", "tr", "th", "w", "y", "b", "br", "c", "ch", "d", "dr", "f", "g", "h", "j", "l", "m", "n", "p", "r", "s", "sh", "st", "sl", "t", "tr", "th", "b", "d", "f", "g", "h", "l", "m", "n", "p", "r", "s", "sh", "t", "th", "b", "d", "f", "g", "h", "l", "m", "n", "p", "r", "s", "sh", "t", "th", "r", "s", "t", "l", "n", "str", "spr", "spl", "wr", "kn", "kn", "gn"}, new String[]{"x", "cst", "bs", "ff", "lg", "g", "gs", "ll", "ltr", "mb", "mn", "mm", "ng", "ng", "ngl", "nt", "ns", "nn", "ps", "mbl", "mpr", "pp", "ppl", "ppr", "rr", "rr", "rr", "rl", "rtn", "ngr", "ss", "sc", "rst", "tt", "tt", "ts", "ltr", "zz"}, new String[]{"b", "rb", "bb", "c", "rc", "ld", "d", "ds", "dd", "f", "ff", "lf", "rf", "rg", "gs", "ch", "lch", "rch", "tch", "ck", "ck", "lk", "rk", "l", "ll", "lm", "m", "rm", "mp", "n", "nk", "nch", "nd", "ng", "ng", "nt", "ns", "lp", "rp", "p", "r", "rn", "rts", "s", "s", "s", "s", "ss", "ss", "st", "ls", "t", "t", "ts", "w", "wn", "x", "ly", "lly", "z", "b", "c", "d", "f", "g", "k", "l", "m", "n", "p", "r", "s", "t", "w"}, new String[]{"ate", "ite", "ism", "ist", "er", "er", "er", "ed", "ed", "ed", "es", "es", "ied", "y", "y", "y", "y", "ate", "ite", "ism", "ist", "er", "er", "er", "ed", "ed", "ed", "es", "es", "ied", "y", "y", "y", "y", "ate", "ite", "ism", "ist", "er", "er", "er", "ed", "ed", "ed", "es", "es", "ied", "y", "y", "y", "y", "ay", "ay", "ey", "oy", "ay", "ay", "ey", "oy", "ough", "aught", "ant", "ont", "oe", "ance", "ell", "eal", "oa", "urt", "ut", "iom", "ion", "ion", "ision", "ation", "ation", "ition", "ough", "aught", "ant", "ont", "oe", "ance", "ell", "eal", "oa", "urt", "ut", "iom", "ion", "ion", "ision", "ation", "ation", "ition", "ily", "ily", "ily", "adly", "owly", "oorly", "ardly", "iedly"}, new String[0], new int[]{1, 2, 3, 4}, new double[]{7.0, 8.0, 4.0, 1.0}, 0.22, 0.1, 0.0, 0.25, englishSanityChecks, true);
    public static final Finnegan GREEK_ROMANIZED = new Finnegan(new String[]{"a", "a", "a", "o", "o", "o", "e", "e", "i", "i", "i", "au", "ai", "ai", "oi", "oi", "ia", "io", "ou", "ou", "eo", "ei"}, new String[]{"ui", "ei"}, new String[]{"rh", "s", "z", "t", "t", "k", "ch", "n", "th", "kth", "m", "p", "ps", "b", "l", "kr", "g", "phth"}, new String[]{"lph", "pl", "l", "l", "kr", "nch", "nx", "ps"}, new String[]{"s", "p", "t", "ch", "n", "m", "s", "p", "t", "ch", "n", "m", "b", "g", "st", "rst", "rt", "sp", "rk", "ph", "x", "z", "nk", "ng", "th"}, new String[]{"os", "os", "is", "us", "um", "eum", "ium", "iam", "us", "um", "es", "anes", "eros", "or", "ophon", "on", "otron"}, new String[0], new int[]{1, 2, 3}, new double[]{5.0, 7.0, 4.0}, 0.45, 0.45, 0.0, 0.3, null, true);
    public static final Finnegan GREEK_AUTHENTIC = new Finnegan(new String[]{"\u03b1", "\u03b1", "\u03b1", "\u03bf", "\u03bf", "\u03bf", "\u03b5", "\u03b5", "\u03b9", "\u03b9", "\u03b9", "\u03b1\u03c5", "\u03b1\u03b9", "\u03b1\u03b9", "\u03bf\u03b9", "\u03bf\u03b9", "\u03b9\u03b1", "\u03b9\u03bf", "\u03bf\u03c5", "\u03bf\u03c5", "\u03b5\u03bf", "\u03b5\u03b9"}, new String[]{"\u03c5\u03b9", "\u03b5\u03b9"}, new String[]{"\u03c1", "\u03c3", "\u03b6", "\u03c4", "\u03c4", "\u03ba", "\u03c7", "\u03bd", "\u03b8", "\u03ba\u03b8", "\u03bc", "\u03c0", "\u03c8", "\u03b2", "\u03bb", "\u03ba\u03c1", "\u03b3", "\u03c6\u03b8"}, new String[]{"\u03bb\u03c6", "\u03c0\u03bb", "\u03bb", "\u03bb", "\u03ba\u03c1", "\u03b3\u03c7", "\u03b3\u03be", "\u03c8"}, new String[]{"\u03c3", "\u03c0", "\u03c4", "\u03c7", "\u03bd", "\u03bc", "\u03c3", "\u03c0", "\u03c4", "\u03c7", "\u03bd", "\u03bc", "\u03b2", "\u03b3", "\u03c3\u03c4", "\u03c1\u03c3\u03c4", "\u03c1\u03c4", "\u03c3\u03c0", "\u03c1\u03ba", "\u03c6", "\u03be", "\u03b6", "\u03b3\u03ba", "\u03b3\u03b3", "\u03b8"}, new String[]{"\u03bf\u03c2", "\u03bf\u03c2", "\u03b9\u03c2", "\u03c5\u03c2", "\u03c5\u03bc", "\u03b5\u03c5\u03bc", "\u03b9\u03c5\u03bc", "\u03b9\u03b1\u03bc", "\u03c5\u03c2", "\u03c5\u03bc", "\u03b5\u03c2", "\u03b1\u03bd\u03b5\u03c2", "\u03b5\u03c1\u03bf\u03c2", "\u03bf\u03c1", "\u03bf\u03c6\u03bf\u03bd", "\u03bf\u03bd", "\u03bf\u03c4\u03c1\u03bf\u03bd"}, new String[0], new int[]{1, 2, 3}, new double[]{5.0, 7.0, 4.0}, 0.45, 0.45, 0.0, 0.3, null, true);
    public static final Finnegan FRENCH = new Finnegan(new String[]{"a", "a", "a", "e", "e", "e", "i", "i", "o", "u", "a", "a", "a", "e", "e", "e", "i", "i", "o", "a", "a", "a", "e", "e", "e", "i", "i", "o", "u", "a", "a", "a", "e", "e", "e", "i", "i", "o", "a", "a", "e", "e", "i", "o", "a", "a", "a", "e", "e", "e", "i", "i", "o", "ai", "oi", "oui", "au", "\u0153u", "ou"}, new String[]{"ai", "aie", "aou", "eau", "oi", "oui", "oie", "eu", "eu", "\u00e0", "\u00e2", "ai", "a\u00ee", "a\u00ef", "aie", "aou", "ao\u00fb", "au", "ay", "e", "\u00e9", "\u00e9e", "\u00e8", "\u00ea", "eau", "ei", "e\u00ee", "eu", "e\u00fb", "i", "\u00ee", "\u00ef", "o", "\u00f4", "oe", "o\u00ea", "o\u00eb", "\u0153u", "oi", "oie", "o\u00ef", "ou", "o\u00fb", "oy", "u", "\u00fb", "ue", "a", "a", "a", "e", "e", "e", "i", "i", "o", "u", "a", "a", "a", "e", "e", "e", "i", "i", "o", "a", "a", "e", "e", "i", "o", "a", "a", "a", "e", "e", "e", "i", "i", "o"}, new String[]{"tr", "ch", "m", "b", "b", "br", "j", "j", "j", "j", "g", "t", "t", "t", "c", "d", "f", "f", "h", "n", "l", "l", "s", "s", "s", "r", "r", "r", "v", "v", "p", "pl", "pr", "bl", "br", "dr", "gl", "gr"}, new String[]{"cqu", "gu", "qu", "rqu", "nt", "ng", "ngu", "mb", "ll", "nd", "ndr", "nct", "st", "xt", "mbr", "pl", "g", "gg", "ggr", "gl", "m", "m", "mm", "v", "v", "f", "f", "f", "ff", "b", "b", "bb", "d", "d", "dd", "s", "s", "s", "ss", "ss", "ss", "cl", "cr", "ng", "\u00e7", "\u00e7", "r\u00e7"}, new String[0], new String[]{"e", "e", "e", "e", "e", "\u00e9", "\u00e9", "er", "er", "er", "er", "er", "es", "es", "es", "es", "es", "es", "e", "e", "e", "e", "e", "\u00e9", "\u00e9", "er", "er", "er", "er", "er", "er", "es", "es", "es", "es", "es", "e", "e", "e", "e", "e", "\u00e9", "\u00e9", "\u00e9", "er", "er", "er", "er", "er", "es", "es", "es", "es", "es", "ent", "em", "en", "en", "aim", "ain", "an", "oin", "ien", "iere", "ors", "anse", "ombs", "ommes", "ancs", "ends", "\u0153ufs", "erfs", "ongs", "aps", "ats", "ives", "ui", "illes", "aen", "aon", "am", "an", "eun", "ein", "age", "age", "uile", "uin", "um", "un", "un", "un", "aille", "ouille", "eille", "ille", "eur", "it", "ot", "oi", "oi", "oi", "aire", "om", "on", "on", "im", "in", "in", "ien", "ien", "ion", "il", "eil", "oin", "oint", "igu\u00eft\u00e9", "ience", "incte", "ang", "ong", "acr\u00e9", "eau", "ouche", "oux", "oux", "ect", "ecri", "agne", "uer", "aix", "eth", "ut", "ant", "anc", "anc", "anche", "ioche", "eaux", "ive", "eur", "ancois", "ecois"}, new String[0], new int[]{1, 2, 3}, new double[]{18.0, 7.0, 2.0}, 0.35, 1.0, 0.0, 0.55, null, true);
    public static final Finnegan RUSSIAN_ROMANIZED = new Finnegan(new String[]{"a", "e", "e", "i", "i", "o", "u", "ie", "y", "e", "iu", "ia", "y", "a", "a", "o", "u"}, new String[0], new String[]{"b", "v", "g", "d", "k", "l", "p", "r", "s", "t", "f", "kh", "ts", "b", "v", "g", "d", "k", "l", "p", "r", "s", "t", "f", "kh", "ts", "b", "v", "g", "d", "k", "l", "p", "r", "s", "t", "f", "zh", "m", "n", "z", "ch", "sh", "shch", "br", "sk", "tr", "bl", "gl", "kr", "gr"}, new String[]{"bl", "br", "pl", "dzh", "tr", "gl", "gr", "kr"}, new String[]{"b", "v", "g", "d", "zh", "z", "k", "l", "m", "n", "p", "r", "s", "t", "f", "kh", "ts", "ch", "sh", "v", "f", "sk", "sk", "sk", "s", "b", "d", "d", "n", "r", "r"}, new String[]{"odka", "odna", "usk", "ask", "usky", "ad", "ar", "ovich", "ev", "ov", "of", "agda", "etsky", "ich", "on", "akh", "iev", "ian"}, new String[0], new int[]{1, 2, 3, 4, 5, 6}, new double[]{4.0, 5.0, 6.0, 5.0, 3.0, 1.0}, 0.1, 0.2, 0.0, 0.12, englishSanityChecks, true);
    public static final Finnegan RUSSIAN_AUTHENTIC = new Finnegan(new String[]{"\u0430", "\u0435", "\u0451", "\u0438", "\u0439", "\u043e", "\u0443", "\u044a", "\u044b", "\u044d", "\u044e", "\u044f", "\u044b", "\u0430", "\u0430", "\u043e", "\u0443"}, new String[0], new String[]{"\u0431", "\u0432", "\u0433", "\u0434", "\u043a", "\u043b", "\u043f", "\u0440", "\u0441", "\u0442", "\u0444", "\u0445", "\u0446", "\u0431", "\u0432", "\u0433", "\u0434", "\u043a", "\u043b", "\u043f", "\u0440", "\u0441", "\u0442", "\u0444", "\u0445", "\u0446", "\u0431", "\u0432", "\u0433", "\u0434", "\u043a", "\u043b", "\u043f", "\u0440", "\u0441", "\u0442", "\u0444", "\u0436", "\u043c", "\u043d", "\u0437", "\u0447", "\u0448", "\u0449", "\u0431\u0440", "\u0441\u043a", "\u0442\u0440", "\u0431\u043b", "\u0433\u043b", "\u043a\u0440", "\u0433\u0440"}, new String[]{"\u0431\u043b", "\u0431\u0440", "\u043f\u043b", "\u0434\u0436", "\u0442\u0440", "\u0433\u043b", "\u0433\u0440", "\u043a\u0440"}, new String[]{"\u0431", "\u0432", "\u0433", "\u0434", "\u0436", "\u0437", "\u043a", "\u043b", "\u043c", "\u043d", "\u043f", "\u0440", "\u0441", "\u0442", "\u0444", "\u0445", "\u0446", "\u0447", "\u0448", "\u0432", "\u0444", "\u0441\u043a", "\u0441\u043a", "\u0441\u043a", "\u0441", "\u0431", "\u0434", "\u0434", "\u043d", "\u0440", "\u0440"}, new String[]{"\u043e\u0434\u043a\u0430", "\u043e\u0434\u043d\u0430", "\u0443\u0441\u043a", "\u0430\u0441\u043a", "\u0443\u0441\u043a\u044b", "\u0430\u0434", "\u0430\u0440", "\u043e\u0432\u0439\u0447", "\u0435\u0432", "\u043e\u0432", "\u043e\u0444", "\u0430\u0433\u0434\u0430", "\u0451\u0446\u043a\u044b", "\u0439\u0447", "\u043e\u043d", "\u0430\u0445", "\u044a\u0432", "\u044f\u043d"}, new String[0], new int[]{1, 2, 3, 4, 5, 6}, new double[]{4.0, 5.0, 6.0, 5.0, 3.0, 1.0}, 0.1, 0.2, 0.0, 0.12, null, true);
    public static final Finnegan JAPANESE_ROMANIZED = new Finnegan(new String[]{"a", "a", "a", "a", "e", "e", "i", "i", "i", "i", "o", "o", "o", "u", "ou", "u", "ai", "ai"}, new String[0], new String[]{"k", "ky", "s", "sh", "t", "ts", "ch", "n", "ny", "h", "f", "hy", "m", "my", "y", "r", "ry", "g", "gy", "z", "j", "d", "b", "by", "p", "py", "k", "t", "n", "s", "k", "t", "d", "s", "sh", "sh", "g", "r", "b", "k", "t", "n", "s", "k", "t", "b", "s", "sh", "sh", "g", "r", "b", "k", "t", "n", "s", "k", "t", "z", "s", "sh", "sh", "ch", "ry", "ts"}, new String[]{"k", "ky", "s", "sh", "t", "ts", "ch", "n", "ny", "h", "f", "hy", "m", "my", "y", "r", "ry", "g", "gy", "z", "j", "d", "b", "by", "p", "py", "k", "t", "d", "s", "k", "t", "d", "s", "sh", "sh", "y", "j", "p", "r", "d", "k", "t", "b", "s", "k", "t", "b", "s", "sh", "sh", "y", "j", "p", "r", "d", "k", "t", "z", "s", "f", "g", "z", "b", "d", "ts", "nn", "nn", "nn", "nd", "nz", "mm", "kk", "kk", "tt", "ss", "ssh", "tch"}, new String[]{"n"}, new String[0], new String[0], new int[]{1, 2, 3, 4, 5}, new double[]{5.0, 4.0, 5.0, 4.0, 3.0}, 0.3, 0.9, 0.0, 0.0, japaneseSanityChecks, true);
    public static final Finnegan SWAHILI = new Finnegan(new String[]{"a", "i", "o", "e", "u", "a", "a", "i", "o", "o", "e", "u", "a", "a", "i", "o", "o", "u", "a", "a", "i", "i", "o", "a", "a", "a", "a", "a", "a", "i", "o", "e", "u", "a", "a", "i", "o", "o", "e", "u", "a", "a", "i", "o", "o", "u", "a", "a", "i", "i", "o", "a", "a", "a", "a", "a", "aa", "aa", "ue", "uo", "ii", "ea"}, new String[0], new String[]{"b", "h", "j", "l", "s", "y", "m", "n", "b", "ch", "h", "j", "l", "s", "y", "z", "m", "n", "b", "ch", "f", "g", "h", "j", "k", "l", "p", "s", "y", "z", "m", "n", "b", "ch", "d", "f", "g", "h", "j", "k", "l", "p", "s", "t", "y", "z", "m", "n", "kw", "b", "ch", "d", "f", "g", "h", "j", "k", "l", "p", "s", "t", "v", "w", "y", "z", "m", "n", "kw", "b", "h", "j", "l", "s", "y", "m", "n", "b", "ch", "h", "j", "l", "s", "y", "z", "m", "n", "b", "ch", "f", "g", "h", "j", "k", "l", "p", "s", "y", "z", "m", "n", "b", "ch", "d", "f", "g", "h", "j", "k", "l", "p", "s", "t", "y", "z", "m", "n", "kw", "b", "ch", "d", "f", "g", "h", "j", "k", "l", "p", "s", "t", "v", "w", "y", "z", "m", "n", "kw", "b", "h", "j", "l", "s", "y", "m", "n", "b", "ch", "h", "j", "l", "s", "y", "z", "m", "n", "b", "ch", "f", "g", "h", "j", "k", "l", "p", "s", "y", "z", "m", "n", "b", "ch", "d", "f", "g", "h", "j", "k", "l", "p", "s", "t", "y", "z", "m", "n", "kw", "b", "ch", "d", "f", "g", "h", "j", "k", "l", "p", "s", "t", "v", "w", "y", "z", "m", "n", "kw", "b", "h", "j", "l", "s", "y", "m", "n", "b", "ch", "h", "j", "l", "s", "y", "z", "m", "n", "b", "ch", "f", "g", "h", "j", "k", "l", "p", "s", "y", "z", "m", "n", "b", "ch", "d", "f", "g", "h", "j", "k", "l", "p", "s", "t", "y", "z", "m", "n", "kw", "b", "ch", "d", "f", "g", "h", "j", "k", "l", "p", "s", "t", "v", "w", "y", "z", "m", "n", "kw", "nb", "nj", "ns", "nz", "nb", "nch", "nj", "ns", "ny", "nz", "nb", "nch", "nf", "ng", "nj", "nk", "np", "ns", "nz", "nb", "nch", "nd", "nf", "ng", "nj", "nk", "np", "ns", "nt", "nz", "nb", "nch", "nd", "nf", "ng", "nj", "nk", "np", "ns", "nt", "nv", "nw", "nz", "mb", "ms", "my", "mz", "mb", "mch", "ms", "my", "mz", "mb", "mch", "mk", "mp", "ms", "my", "mz", "mb", "mch", "md", "mk", "mp", "ms", "mt", "my", "mz", "mb", "mch", "md", "mf", "mg", "mj", "mk", "mp", "ms", "mt", "mv", "mw", "my", "mz", "sh", "sh", "sh", "ny", "kw", "dh", "th", "sh", "ny", "dh", "th", "sh", "gh", "r", "ny", "dh", "th", "sh", "gh", "r", "ny"}, new String[]{"b", "h", "j", "l", "s", "y", "m", "n", "b", "ch", "h", "j", "l", "s", "y", "z", "m", "n", "b", "ch", "f", "g", "h", "j", "k", "l", "p", "s", "y", "z", "m", "n", "b", "ch", "d", "f", "g", "h", "j", "k", "l", "p", "s", "t", "y", "z", "m", "n", "kw", "b", "ch", "d", "f", "g", "h", "j", "k", "l", "p", "s", "t", "v", "w", "y", "z", "m", "n", "kw", "b", "h", "j", "l", "s", "y", "m", "n", "b", "ch", "h", "j", "l", "s", "y", "z", "m", "n", "b", "ch", "f", "g", "h", "j", "k", "l", "p", "s", "y", "z", "m", "n", "b", "ch", "d", "f", "g", "h", "j", "k", "l", "p", "s", "t", "y", "z", "m", "n", "kw", "b", "ch", "d", "f", "g", "h", "j", "k", "l", "p", "s", "t", "v", "w", "y", "z", "m", "n", "kw", "b", "h", "j", "l", "s", "y", "m", "n", "b", "ch", "h", "j", "l", "s", "y", "z", "m", "n", "b", "ch", "f", "g", "h", "j", "k", "l", "p", "s", "y", "z", "m", "n", "b", "ch", "d", "f", "g", "h", "j", "k", "l", "p", "s", "t", "y", "z", "m", "n", "kw", "b", "ch", "d", "f", "g", "h", "j", "k", "l", "p", "s", "t", "v", "w", "y", "z", "m", "n", "kw", "b", "h", "j", "l", "s", "y", "m", "n", "b", "ch", "h", "j", "l", "s", "y", "z", "m", "n", "b", "ch", "f", "g", "h", "j", "k", "l", "p", "s", "y", "z", "m", "n", "b", "ch", "d", "f", "g", "h", "j", "k", "l", "p", "s", "t", "y", "z", "m", "n", "kw", "b", "ch", "d", "f", "g", "h", "j", "k", "l", "p", "s", "t", "v", "w", "y", "z", "m", "n", "kw", "nb", "nj", "ns", "nz", "nb", "nch", "nj", "ns", "ny", "nz", "nb", "nch", "nf", "ng", "nj", "nk", "np", "ns", "nz", "nb", "nch", "nd", "nf", "ng", "nj", "nk", "np", "ns", "nt", "nz", "nb", "nch", "nd", "nf", "ng", "nj", "nk", "np", "ns", "nt", "nw", "nz", "mb", "ms", "my", "mz", "mb", "mch", "ms", "my", "mz", "mb", "mch", "mk", "mp", "ms", "my", "mz", "mb", "mch", "md", "mk", "mp", "ms", "mt", "my", "mz", "mb", "mch", "md", "mf", "mg", "mj", "mk", "mp", "ms", "mt", "mw", "my", "mz", "sh", "sh", "sh", "ny", "kw", "dh", "th", "sh", "ny", "dh", "th", "sh", "gh", "r", "ny", "dh", "th", "sh", "gh", "r", "ny", "ng", "ng", "ng", "ng", "ng"}, new String[]{""}, new String[]{"a-@2a", "a-@2a", "a-@3a", "a-@2a", "a-@2a", "a-@3a", "i-@2i", "i-@2i", "i-@3i", "e-@2e", "e-@2e", "e-@3e", "u-@2u", "u-@2u", "u-@3u"}, new String[0], new int[]{1, 2, 3, 4, 5}, new double[]{1.0, 7.0, 6.0, 4.0, 2.0}, 0.2, 1.0, 0.0, 0.25, null, true);
    public static final Finnegan SOMALI = new Finnegan(new String[]{"a", "a", "a", "a", "a", "a", "a", "aa", "aa", "aa", "e", "e", "ee", "i", "i", "i", "i", "ii", "o", "o", "o", "oo", "u", "u", "u", "uu", "uu"}, new String[0], new String[]{"b", "t", "j", "x", "kh", "d", "r", "s", "sh", "dh", "c", "g", "f", "q", "k", "l", "m", "n", "w", "h", "y", "x", "g", "b", "d", "s", "m", "dh", "n", "r", "g", "b", "s", "dh"}, new String[]{"bb", "gg", "dd", "bb", "dd", "rr", "ddh", "cc", "gg", "ff", "ll", "mm", "nn", "bb", "gg", "dd", "bb", "dd", "gg", "bb", "gg", "dd", "bb", "dd", "gg", "cy", "fk", "ft", "nt", "rt", "lt", "qm", "rdh", "rsh", "lq", "my", "gy", "by", "lkh", "rx", "md", "bd", "dg", "fd", "mf", "dh", "dh", "dh", "dh"}, new String[]{"b", "t", "j", "x", "kh", "d", "r", "s", "sh", "c", "g", "f", "q", "k", "l", "m", "n", "h", "x", "g", "b", "d", "s", "m", "q", "n", "r", "b", "t", "j", "x", "kh", "d", "r", "s", "sh", "c", "g", "f", "q", "k", "l", "m", "n", "h", "x", "g", "b", "d", "s", "m", "q", "n", "r", "b", "t", "j", "x", "kh", "d", "r", "s", "sh", "c", "g", "f", "q", "k", "l", "m", "n", "g", "b", "d", "s", "q", "n", "r", "b", "t", "x", "kh", "d", "r", "s", "sh", "g", "f", "q", "k", "l", "m", "n", "g", "b", "d", "s", "r", "n", "b", "t", "kh", "d", "r", "s", "sh", "g", "f", "q", "k", "l", "m", "n", "g", "b", "d", "s", "r", "n", "b", "t", "d", "r", "s", "sh", "g", "f", "q", "k", "l", "m", "n", "g", "b", "d", "s", "r", "n"}, new String[]{"aw", "ow", "ay", "ey", "oy", "ay", "ay"}, new String[0], new int[]{1, 2, 3, 4, 5}, new double[]{5.0, 4.0, 5.0, 4.0, 1.0}, 0.25, 0.3, 0.0, 0.08, null, true);
    public static final Finnegan HINDI_ROMANIZED = new Finnegan(new String[]{"a", "a", "a", "a", "a", "a", "\u0101", "\u0101", "i", "i", "i", "i", "\u012b", "\u012b", "u", "u", "u", "\u016b", "e", "ai", "ai", "o", "o", "o", "au", "a", "a", "a", "a", "a", "a", "\u0101", "\u0101", "i", "i", "i", "i", "\u012b", "\u012b", "u", "u", "u", "\u016b", "e", "ai", "ai", "o", "o", "o", "au", "a", "a", "a", "a", "a", "a", "\u0101", "\u0101", "i", "i", "i", "i", "\u012b", "\u012b", "u", "u", "u", "\u016b", "e", "ai", "ai", "o", "o", "o", "au", "a", "a", "a", "a", "a", "a", "\u0101", "\u0101", "i", "i", "i", "i", "\u012b", "\u012b", "u", "u", "u", "\u016b", "e", "ai", "ai", "o", "o", "o", "au", "a", "a", "a", "a", "a", "a", "\u0101", "\u0101", "i", "i", "i", "i", "\u012b", "i", "i", "\u012b", "\u012b", "u", "u", "u", "\u016b", "u", "\u016b", "u", "\u016b", "e", "ai", "ai", "o", "o", "o", "au", "a", "a", "a", "a", "a", "a", "\u0101", "\u0101", "i", "i", "i", "i", "\u012b", "i", "i", "\u012b", "\u012b", "u", "u", "u", "\u016b", "u", "\u016b", "u", "\u016b", "e", "ai", "ai", "o", "o", "o", "au", "a", "a", "a", "a", "a", "a", "\u0101", "\u0101", "i", "i", "i", "i", "\u012b", "i", "i", "\u012b", "\u012b", "u", "u", "u", "\u016b", "u", "\u016b", "u", "\u016b", "e", "ai", "ai", "o", "o", "o", "au", "a", "a", "a", "a", "a", "a", "\u0101", "\u0101", "i", "i", "i", "i", "\u012b", "i", "i", "\u012b", "\u012b", "u", "u", "u", "\u016b", "u", "\u016b", "u", "\u016b", "e", "ai", "ai", "o", "o", "o", "au", "a\u1e43", "a\u1e43", "a\u1e43", "a\u1e43", "a\u1e43", "\u0101\u1e43", "\u0101\u1e43", "i\u1e43", "i\u1e43", "i\u1e43", "\u012b\u1e43", "\u012b\u1e43", "u\u1e43", "u\u1e43", "\u016b\u1e43", "ai\u1e43", "ai\u1e43", "o\u1e43", "o\u1e43", "o\u1e43", "au\u1e43"}, new String[]{"a'", "i'", "u'", "o'", "a'", "i'", "u'", "o'"}, new String[]{"k", "k", "k", "k", "k", "k", "k", "k", "k\u1e5b", "k\u1e5d", "k\u1e37", "c", "c", "c", "c", "c", "c", "c\u1e5b", "c\u1e5d", "c\u1e37", "\u1e6d", "t", "t", "t", "t", "t", "t", "t", "t", "t", "t\u1e5b", "t\u1e5d", "t\u1e5b", "t\u1e5d", "p", "p", "p", "p", "p", "p", "p", "p", "p", "p", "p\u1e5b", "p\u1e5d", "p\u1e37", "p\u1e39", "p\u1e5b", "p\u1e5d", "p", "p", "kh", "kh", "kh", "kh", "kh", "kh", "kh", "kh", "kh", "kh", "kh\u1e5b", "kh\u1e5d", "kh\u1e37", "kh\u1e39", "ch", "ch", "ch", "ch", "ch", "ch", "ch", "ch", "ch", "ch\u1e5b", "ch\u1e5d", "ch\u1e37", "ch\u1e39", "\u1e6dh", "th", "th", "th", "th", "th", "th", "th", "th", "th", "th\u1e5b", "th\u1e5d", "th\u1e37", "th\u1e39", "ph", "ph", "ph", "ph", "ph", "ph", "ph", "ph\u1e5b", "ph\u1e5d", "ph\u1e37", "ph\u1e39", "g", "j", "\u1e0d", "d", "b", "gh", "jh", "\u1e0dh", "dh", "bh", "\u1e45", "\u00f1", "\u1e47", "n", "m", "h", "y", "r", "l", "v", "\u015b", "\u1e63", "s", "g", "j", "\u1e0d", "d", "b", "gh", "jh", "\u1e0dh", "dh", "bh", "\u1e45", "\u00f1", "\u1e47", "n", "m", "h", "y", "r", "l", "v", "\u015b", "\u1e63", "s", "g", "j", "\u1e0d", "d", "b", "gh", "jh", "\u1e0dh", "dh", "bh", "\u1e45", "\u00f1", "\u1e47", "n", "m", "h", "y", "r", "l", "v", "\u015b", "\u1e63", "s", "g", "j", "\u1e0d", "d", "b", "gh", "jh", "\u1e0dh", "dh", "bh", "\u1e45", "\u00f1", "\u1e47", "n", "m", "h", "y", "r", "l", "v", "\u015b", "\u1e63", "s", "g", "j", "\u1e0d", "d", "b", "gh", "jh", "\u1e0dh", "dh", "bh", "\u1e45", "\u00f1", "\u1e47", "n", "m", "h", "y", "r", "l", "v", "\u015b", "\u1e63", "s", "g", "j", "\u1e0d", "d", "b", "gh", "jh", "\u1e0dh", "dh", "bh", "\u1e45", "\u00f1", "\u1e47", "n", "m", "h", "y", "r", "l", "v", "\u015b", "\u1e63", "s", "g", "j", "\u1e0d", "d", "b", "gh", "jh", "\u1e0dh", "dh", "bh", "\u1e45", "\u00f1", "\u1e47", "n", "m", "h", "y", "r", "l", "v", "\u015b", "\u1e63", "s", "g", "j", "\u1e0d", "d", "b", "gh", "\u1e0dh", "dh", "bh", "\u1e45", "\u00f1", "\u1e47", "n", "m", "h", "y", "r", "l", "v", "\u015b", "\u1e63", "s", "g", "j", "\u1e0d", "d", "b", "gh", "\u1e0dh", "dh", "bh", "\u1e45", "\u1e47", "n", "m", "h", "y", "r", "l", "v", "\u1e63", "s", "g", "j", "\u1e0d", "d", "b", "gh", "\u1e0dh", "dh", "bh", "\u1e45", "\u1e47", "n", "m", "h", "y", "r", "l", "v", "\u1e63", "s", "g", "\u1e0d", "d", "b", "gh", "\u1e0dh", "dh", "bh", "n", "m", "v", "s", "g", "\u1e0d", "d", "b", "g", "d", "b", "dh", "bh", "n", "m", "v", "g", "\u1e0d", "d", "b", "g", "d", "b", "dh", "bh", "n", "m", "v"}, new String[]{"k", "k", "k", "k", "k", "nk", "rk", "k", "k", "k", "k", "k", "nk", "rk", "k", "k", "k", "k", "k", "nk", "rk", "k", "k", "k", "k", "k", "nk", "rk", "k", "k", "k", "k", "k", "nk", "rk", "k", "k", "k", "k", "k", "nk", "rk", "k", "k", "k", "k", "k", "nk", "rk", "k", "k", "k", "k", "k", "nk", "rk", "k\u1e5b", "k\u1e5b", "k\u1e5b", "k\u1e5b", "k\u1e5b", "nk\u1e5b", "rk\u1e5b", "k\u1e5d", "k\u1e5d", "k\u1e5d", "k\u1e5d", "k\u1e5d", "nk\u1e5d", "rk\u1e5d", "k\u1e37", "k\u1e37", "k\u1e37", "k\u1e37", "k\u1e37", "nk\u1e37", "rk\u1e37", "c", "c", "c", "c", "c", "c", "c\u1e5b", "c\u1e5d", "c\u1e37", "\u1e6d", "t", "t", "t", "t", "t", "nt", "rt", "\u1e6d", "t", "t", "t", "t", "nt", "rt", "\u1e6d", "t", "t", "t", "t", "nt", "rt", "\u1e6d", "t", "t", "t", "t", "nt", "rt", "\u1e6d", "t", "t", "t", "t", "nt", "rt", "\u1e6d", "t", "t", "t", "t", "nt", "rt", "\u1e6d", "t", "t", "t", "t", "nt", "rt", "\u1e6d", "t", "t", "t", "t", "nt", "rt", "\u1e6d", "t", "t", "t", "t", "nt", "rt", "t\u1e5b", "t\u1e5b", "t\u1e5b", "t\u1e5b", "t\u1e5b", "nt\u1e5b", "rt\u1e5b", "t\u1e5d", "t\u1e5d", "t\u1e5d", "t\u1e5d", "t\u1e5d", "nt\u1e5d", "rt\u1e5d", "t\u1e5b", "t\u1e5b", "t\u1e5b", "t\u1e5b", "t\u1e5b", "nt\u1e5b", "rt\u1e5b", "t\u1e5d", "t\u1e5d", "t\u1e5d", "t\u1e5d", "t\u1e5d", "nt\u1e5d", "rt\u1e5d", "p", "p", "p", "p", "p", "np", "rp", "p", "p", "p", "p", "p", "np", "rp", "p", "p", "p", "p", "p", "np", "rp", "p", "p", "p", "p", "p", "np", "rp", "p", "p", "p", "p", "p", "np", "rp", "p", "p", "p", "p", "p", "np", "rp", "p", "p", "p", "p", "p", "np", "rp", "p", "p", "p", "p", "p", "np", "rp", "p", "p", "p", "p", "p", "np", "rp", "p", "p", "p", "p", "p", "np", "rp", "p\u1e5b", "p\u1e5b", "p\u1e5b", "p\u1e5b", "p\u1e5b", "np\u1e5b", "rp\u1e5b", "p\u1e5d", "p\u1e5d", "p\u1e5d", "p\u1e5d", "p\u1e5d", "np\u1e5d", "rp\u1e5d", "p\u1e37", "p\u1e37", "p\u1e37", "p\u1e37", "p\u1e37", "np\u1e37", "rp\u1e37", "p\u1e39", "p\u1e39", "p\u1e39", "p\u1e39", "p\u1e39", "np\u1e39", "rp\u1e39", "p\u1e5b", "p\u1e5b", "p\u1e5b", "p\u1e5b", "p\u1e5b", "np\u1e5b", "rp\u1e5b", "p\u1e5d", "p\u1e5d", "p\u1e5d", "p\u1e5d", "p\u1e5d", "np\u1e5d", "rp\u1e5d", "p", "p", "p", "p", "p", "np", "rp", "p", "p", "p", "p", "p", "np", "rp", "kh", "kh", "kh", "kh", "kh", "nkh", "rkh", "kh", "kh", "kh", "kh", "kh", "nkh", "rkh", "kh", "kh", "kh", "kh", "kh", "nkh", "rkh", "kh", "kh", "kh", "kh", "kh", "nkh", "rkh", "kh", "kh", "kh", "kh", "kh", "nkh", "rkh", "kh", "kh", "kh", "kh", "kh", "nkh", "rkh", "kh", "kh", "kh", "kh", "kh", "nkh", "rkh", "kh", "kh", "kh", "kh", "kh", "nkh", "rkh", "kh", "kh", "kh", "kh", "kh", "nkh", "rkh", "kh", "kh", "kh", "kh", "kh", "nkh", "rkh", "kh\u1e5b", "kh\u1e5b", "kh\u1e5b", "kh\u1e5b", "kh\u1e5b", "nkh\u1e5b", "rkh\u1e5b", "kh\u1e5d", "kh\u1e5d", "kh\u1e5d", "kh\u1e5d", "kh\u1e5d", "nkh\u1e5d", "rkh\u1e5d", "kh\u1e37", "kh\u1e37", "kh\u1e37", "kh\u1e37", "kh\u1e37", "nkh\u1e37", "rkh\u1e37", "kh\u1e39", "kh\u1e39", "kh\u1e39", "kh\u1e39", "kh\u1e39", "nkh\u1e39", "rkh\u1e39", "ch", "ch", "ch", "ch", "ch", "ch", "ch", "ch", "ch", "ch\u1e5b", "ch\u1e5d", "ch\u1e37", "ch\u1e39", "\u1e6dh", "th", "th", "th", "th", "th", "nth", "rth", "th", "th", "th", "th", "th", "nth", "rth", "th", "th", "th", "th", "th", "nth", "rth", "th", "th", "th", "th", "th", "nth", "rth", "th", "th", "th", "th", "th", "nth", "rth", "th", "th", "th", "th", "th", "nth", "rth", "th", "th", "th", "th", "th", "nth", "rth", "th", "th", "th", "th", "th", "nth", "rth", "th", "th", "th", "th", "th", "nth", "rth", "th\u1e5b", "th\u1e5b", "th\u1e5b", "th\u1e5b", "th\u1e5b", "nth\u1e5b", "rth\u1e5b", "th\u1e5d", "th\u1e5d", "th\u1e5d", "th\u1e5d", "th\u1e5d", "nth\u1e5d", "rth\u1e5d", "th\u1e37", "th\u1e37", "th\u1e37", "th\u1e37", "th\u1e37", "nth\u1e37", "rth\u1e37", "th\u1e39", "th\u1e39", "th\u1e39", "th\u1e39", "th\u1e39", "nth\u1e39", "rth\u1e39", "ph", "ph", "ph", "ph", "ph", "nph", "rph", "ph", "ph", "ph", "ph", "ph", "nph", "rph", "ph", "ph", "ph", "ph", "ph", "nph", "rph", "ph", "ph", "ph", "ph", "ph", "nph", "rph", "ph", "ph", "ph", "ph", "ph", "nph", "rph", "ph", "ph", "ph", "ph", "ph", "nph", "rph", "ph", "ph", "ph", "ph", "ph", "nph", "rph", "ph\u1e5b", "ph\u1e5b", "ph\u1e5b", "ph\u1e5b", "ph\u1e5b", "nph\u1e5b", "rph\u1e5b", "ph\u1e5d", "ph\u1e5d", "ph\u1e5d", "ph\u1e5d", "ph\u1e5d", "nph\u1e5d", "rph\u1e5d", "ph\u1e37", "ph\u1e37", "ph\u1e37", "ph\u1e37", "ph\u1e37", "nph\u1e37", "rph\u1e37", "ph\u1e39", "ph\u1e39", "ph\u1e39", "ph\u1e39", "ph\u1e39", "nph\u1e39", "rph\u1e39", "g", "g", "g", "g", "g", "ng", "rg", "j", "j", "j", "j", "j", "nj", "rj", "\u1e0d", "\u1e0d", "\u1e0d", "\u1e0d", "\u1e0d", "n\u1e0d", "r\u1e0d", "d", "d", "d", "d", "d", "nd", "rd", "b", "b", "b", "b", "b", "nb", "rb", "gh", "gh", "gh", "gh", "gh", "ngh", "rgh", "jh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "n\u1e0dh", "r\u1e0dh", "dh", "dh", "dh", "dh", "dh", "ndh", "rdh", "bh", "bh", "bh", "bh", "bh", "nbh", "rbh", "\u1e45", "\u00f1", "\u1e47", "n", "m", "m", "m", "m", "m", "nm", "rm", "h", "y", "y", "y", "y", "y", "ny", "ry", "r", "l", "v", "v", "v", "v", "v", "nv", "rv", "\u015b", "\u015b", "\u015b", "\u015b", "\u015b", "n\u015b", "r\u015b", "\u1e63", "\u1e63", "\u1e63", "\u1e63", "\u1e63", "n\u1e63", "r\u1e63", "s", "s", "s", "s", "s", "ns", "rs", "g", "g", "g", "g", "g", "ng", "rg", "j", "j", "j", "j", "j", "nj", "rj", "\u1e0d", "\u1e0d", "\u1e0d", "\u1e0d", "\u1e0d", "n\u1e0d", "r\u1e0d", "d", "d", "d", "d", "d", "nd", "rd", "b", "b", "b", "b", "b", "nb", "rb", "gh", "gh", "gh", "gh", "gh", "ngh", "rgh", "jh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "n\u1e0dh", "r\u1e0dh", "dh", "dh", "dh", "dh", "dh", "ndh", "rdh", "bh", "bh", "bh", "bh", "bh", "nbh", "rbh", "\u1e45", "\u00f1", "\u1e47", "n", "m", "m", "m", "m", "m", "nm", "rm", "h", "y", "y", "y", "y", "y", "ny", "ry", "r", "l", "v", "v", "v", "v", "v", "nv", "rv", "\u015b", "\u015b", "\u015b", "\u015b", "\u015b", "n\u015b", "r\u015b", "\u1e63", "\u1e63", "\u1e63", "\u1e63", "\u1e63", "n\u1e63", "r\u1e63", "s", "s", "s", "s", "s", "ns", "rs", "g", "g", "g", "g", "g", "ng", "rg", "j", "j", "j", "j", "j", "nj", "rj", "\u1e0d", "\u1e0d", "\u1e0d", "\u1e0d", "\u1e0d", "n\u1e0d", "r\u1e0d", "d", "d", "d", "d", "d", "nd", "rd", "b", "b", "b", "b", "b", "nb", "rb", "gh", "gh", "gh", "gh", "gh", "ngh", "rgh", "jh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "n\u1e0dh", "r\u1e0dh", "dh", "dh", "dh", "dh", "dh", "ndh", "rdh", "bh", "bh", "bh", "bh", "bh", "nbh", "rbh", "\u1e45", "\u00f1", "\u1e47", "n", "m", "m", "m", "m", "m", "nm", "rm", "h", "y", "y", "y", "y", "y", "ny", "ry", "r", "l", "v", "v", "v", "v", "v", "nv", "rv", "\u015b", "\u015b", "\u015b", "\u015b", "\u015b", "n\u015b", "r\u015b", "\u1e63", "\u1e63", "\u1e63", "\u1e63", "\u1e63", "n\u1e63", "r\u1e63", "s", "s", "s", "s", "s", "ns", "rs", "g", "g", "g", "g", "g", "ng", "rg", "j", "j", "j", "j", "j", "nj", "rj", "\u1e0d", "\u1e0d", "\u1e0d", "\u1e0d", "\u1e0d", "n\u1e0d", "r\u1e0d", "d", "d", "d", "d", "d", "nd", "rd", "b", "b", "b", "b", "b", "nb", "rb", "gh", "gh", "gh", "gh", "gh", "ngh", "rgh", "jh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "n\u1e0dh", "r\u1e0dh", "dh", "dh", "dh", "dh", "dh", "ndh", "rdh", "bh", "bh", "bh", "bh", "bh", "nbh", "rbh", "\u1e45", "\u00f1", "\u1e47", "n", "m", "m", "m", "m", "m", "nm", "rm", "h", "y", "y", "y", "y", "y", "ny", "ry", "r", "l", "v", "v", "v", "v", "v", "nv", "rv", "\u015b", "\u015b", "\u015b", "\u015b", "\u015b", "n\u015b", "r\u015b", "\u1e63", "\u1e63", "\u1e63", "\u1e63", "\u1e63", "n\u1e63", "r\u1e63", "s", "s", "s", "s", "s", "ns", "rs", "g", "g", "g", "g", "g", "ng", "rg", "j", "j", "j", "j", "j", "nj", "rj", "\u1e0d", "\u1e0d", "\u1e0d", "\u1e0d", "\u1e0d", "n\u1e0d", "r\u1e0d", "d", "d", "d", "d", "d", "nd", "rd", "b", "b", "b", "b", "b", "nb", "rb", "gh", "gh", "gh", "gh", "gh", "ngh", "rgh", "jh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "n\u1e0dh", "r\u1e0dh", "dh", "dh", "dh", "dh", "dh", "ndh", "rdh", "bh", "bh", "bh", "bh", "bh", "nbh", "rbh", "\u1e45", "\u00f1", "\u1e47", "n", "m", "m", "m", "m", "m", "nm", "rm", "h", "y", "y", "y", "y", "y", "ny", "ry", "r", "l", "v", "v", "v", "v", "v", "nv", "rv", "\u015b", "\u015b", "\u015b", "\u015b", "\u015b", "n\u015b", "r\u015b", "\u1e63", "\u1e63", "\u1e63", "\u1e63", "\u1e63", "n\u1e63", "r\u1e63", "s", "s", "s", "s", "s", "ns", "rs", "g", "g", "g", "g", "g", "ng", "rg", "j", "j", "j", "j", "j", "nj", "rj", "\u1e0d", "\u1e0d", "\u1e0d", "\u1e0d", "\u1e0d", "n\u1e0d", "r\u1e0d", "d", "d", "d", "d", "d", "nd", "rd", "b", "b", "b", "b", "b", "nb", "rb", "gh", "gh", "gh", "gh", "gh", "ngh", "rgh", "jh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "n\u1e0dh", "r\u1e0dh", "dh", "dh", "dh", "dh", "dh", "ndh", "rdh", "bh", "bh", "bh", "bh", "bh", "nbh", "rbh", "\u1e45", "\u00f1", "\u1e47", "n", "m", "m", "m", "m", "m", "nm", "rm", "h", "y", "y", "y", "y", "y", "ny", "ry", "r", "l", "v", "v", "v", "v", "v", "nv", "rv", "\u015b", "\u015b", "\u015b", "\u015b", "\u015b", "n\u015b", "r\u015b", "\u1e63", "\u1e63", "\u1e63", "\u1e63", "\u1e63", "n\u1e63", "r\u1e63", "s", "s", "s", "s", "s", "ns", "rs", "g", "g", "g", "g", "g", "ng", "rg", "j", "j", "j", "j", "j", "nj", "rj", "\u1e0d", "\u1e0d", "\u1e0d", "\u1e0d", "\u1e0d", "n\u1e0d", "r\u1e0d", "d", "d", "d", "d", "d", "nd", "rd", "b", "b", "b", "b", "b", "nb", "rb", "gh", "gh", "gh", "gh", "gh", "ngh", "rgh", "jh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "n\u1e0dh", "r\u1e0dh", "dh", "dh", "dh", "dh", "dh", "ndh", "rdh", "bh", "bh", "bh", "bh", "bh", "nbh", "rbh", "\u1e45", "\u00f1", "\u1e47", "n", "m", "m", "m", "m", "m", "nm", "rm", "h", "y", "y", "y", "y", "y", "ny", "ry", "r", "l", "v", "v", "v", "v", "v", "nv", "rv", "\u015b", "\u015b", "\u015b", "\u015b", "\u015b", "n\u015b", "r\u015b", "\u1e63", "\u1e63", "\u1e63", "\u1e63", "\u1e63", "n\u1e63", "r\u1e63", "s", "s", "s", "s", "s", "ns", "rs", "g", "g", "g", "g", "g", "ng", "rg", "j", "j", "j", "j", "j", "nj", "rj", "\u1e0d", "\u1e0d", "\u1e0d", "\u1e0d", "\u1e0d", "n\u1e0d", "r\u1e0d", "d", "d", "d", "d", "d", "nd", "rd", "b", "b", "b", "b", "b", "nb", "rb", "gh", "gh", "gh", "gh", "gh", "ngh", "rgh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "n\u1e0dh", "r\u1e0dh", "dh", "dh", "dh", "dh", "dh", "ndh", "rdh", "bh", "bh", "bh", "bh", "bh", "nbh", "rbh", "\u1e45", "\u00f1", "\u1e47", "n", "m", "m", "m", "m", "m", "nm", "rm", "h", "y", "y", "y", "y", "y", "ny", "ry", "r", "l", "v", "v", "v", "v", "v", "nv", "rv", "\u015b", "\u015b", "\u015b", "\u015b", "\u015b", "n\u015b", "r\u015b", "\u1e63", "\u1e63", "\u1e63", "\u1e63", "\u1e63", "n\u1e63", "r\u1e63", "s", "s", "s", "s", "s", "ns", "rs", "g", "g", "g", "g", "g", "ng", "rg", "j", "j", "j", "j", "j", "nj", "rj", "\u1e0d", "\u1e0d", "\u1e0d", "\u1e0d", "\u1e0d", "n\u1e0d", "r\u1e0d", "d", "d", "d", "d", "d", "nd", "rd", "b", "b", "b", "b", "b", "nb", "rb", "gh", "gh", "gh", "gh", "gh", "ngh", "rgh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "n\u1e0dh", "r\u1e0dh", "dh", "dh", "dh", "dh", "dh", "ndh", "rdh", "bh", "bh", "bh", "bh", "bh", "nbh", "rbh", "\u1e45", "\u1e47", "n", "m", "m", "m", "m", "m", "nm", "rm", "h", "y", "y", "y", "y", "y", "ny", "ry", "r", "l", "v", "v", "v", "v", "v", "nv", "rv", "\u1e63", "\u1e63", "\u1e63", "\u1e63", "\u1e63", "n\u1e63", "r\u1e63", "s", "s", "s", "s", "s", "ns", "rs", "g", "g", "g", "g", "g", "ng", "rg", "j", "j", "j", "j", "j", "nj", "rj", "\u1e0d", "\u1e0d", "\u1e0d", "\u1e0d", "\u1e0d", "n\u1e0d", "r\u1e0d", "d", "d", "d", "d", "d", "nd", "rd", "b", "b", "b", "b", "b", "nb", "rb", "gh", "gh", "gh", "gh", "gh", "ngh", "rgh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "n\u1e0dh", "r\u1e0dh", "dh", "dh", "dh", "dh", "dh", "ndh", "rdh", "bh", "bh", "bh", "bh", "bh", "nbh", "rbh", "\u1e45", "\u1e47", "n", "m", "m", "m", "m", "m", "nm", "rm", "h", "y", "y", "y", "y", "y", "ny", "ry", "r", "l", "v", "v", "v", "v", "v", "nv", "rv", "\u1e63", "\u1e63", "\u1e63", "\u1e63", "\u1e63", "n\u1e63", "r\u1e63", "s", "s", "s", "s", "s", "ns", "rs", "g", "g", "g", "g", "g", "ng", "rg", "\u1e0d", "\u1e0d", "\u1e0d", "\u1e0d", "\u1e0d", "n\u1e0d", "r\u1e0d", "d", "d", "d", "d", "d", "nd", "rd", "b", "b", "b", "b", "b", "nb", "rb", "gh", "gh", "gh", "gh", "gh", "ngh", "rgh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "\u1e0dh", "n\u1e0dh", "r\u1e0dh", "dh", "dh", "dh", "dh", "dh", "ndh", "rdh", "bh", "bh", "bh", "bh", "bh", "nbh", "rbh", "n", "m", "m", "m", "m", "m", "nm", "rm", "v", "v", "v", "v", "v", "nv", "rv", "s", "s", "s", "s", "s", "ns", "rs", "g", "g", "g", "g", "g", "ng", "rg", "\u1e0d", "\u1e0d", "\u1e0d", "\u1e0d", "\u1e0d", "n\u1e0d", "r\u1e0d", "d", "d", "d", "d", "d", "nd", "rd", "b", "b", "b", "b", "b", "nb", "rb", "g", "g", "g", "g", "g", "ng", "rg", "d", "d", "d", "d", "d", "nd", "rd", "b", "b", "b", "b", "b", "nb", "rb", "dh", "dh", "dh", "dh", "dh", "ndh", "rdh", "bh", "bh", "bh", "bh", "bh", "nbh", "rbh", "n", "m", "m", "m", "m", "m", "nm", "rm", "v", "v", "v", "v", "v", "nv", "rv", "g", "g", "g", "g", "g", "ng", "rg", "\u1e0d", "\u1e0d", "\u1e0d", "\u1e0d", "\u1e0d", "n\u1e0d", "r\u1e0d", "d", "d", "d", "d", "d", "nd", "rd", "b", "b", "b", "b", "b", "nb", "rb", "g", "g", "g", "g", "g", "ng", "rg", "d", "d", "d", "d", "d", "nd", "rd", "b", "b", "b", "b", "b", "nb", "rb", "dh", "dh", "dh", "dh", "dh", "ndh", "rdh", "bh", "bh", "bh", "bh", "bh", "nbh", "rbh", "n", "m", "m", "m", "m", "m", "nm", "rm", "v", "v", "v", "v", "v", "nv", "rv"}, new String[]{"t", "d", "m", "r", "dh", "b", "t", "d", "m", "r", "dh", "bh", "nt", "nt", "nk", "\u1e63"}, new String[]{"it", "it", "ati", "adva", "a\u1e63", "arma", "ardha", "abi", "ab", "aya"}, new String[0], new int[]{1, 2, 3, 4, 5}, new double[]{1.0, 2.0, 3.0, 3.0, 1.0}, 0.15, 0.75, 0.0, 0.12, null, true).addModifiers(Modifier.replacementTable("\u1e5b\u1e5d\u1e37\u1e39\u1e0d\u1e6d\u1e45\u1e47\u1e63\u1e43\u1e25", "\u0157\u0155\u013c\u013a\u0111\u0163\u0144\u0146\u015f\u0115\u012d"));
    public static final Finnegan FANTASY_NAME = GREEK_ROMANIZED.mix(RUSSIAN_ROMANIZED.mix(FRENCH.removeAccents().mix(JAPANESE_ROMANIZED, 0.5), 0.85), 0.925);
    public static final Finnegan FANCY_FANTASY_NAME = FANTASY_NAME.addAccents(0.47, 0.07);

    public String removeAccents(CharSequence str) {
        String alteredString = Normalizer.normalize(str, Normalizer.Form.NFD);
        alteredString = diacritics.matcher(alteredString).replaceAll("").replace('\u00e6', 'a').replace('\u0153', 'o').replace('\u00f8', 'o').replace('\u00c6', 'A').replace('\u0152', 'O').replace('\u00d8', 'O');
        return alteredString;
    }

    public Finnegan() {
        this(new String[]{"a", "a", "a", "a", "o", "o", "o", "e", "e", "e", "e", "e", "i", "i", "i", "i", "u", "a", "a", "a", "a", "o", "o", "o", "e", "e", "e", "e", "e", "i", "i", "i", "i", "u", "a", "a", "a", "o", "o", "e", "e", "e", "i", "i", "i", "u", "a", "a", "a", "o", "o", "e", "e", "e", "i", "i", "i", "u", "au", "ai", "ai", "ou", "ea", "ie", "io", "ei"}, new String[]{"u", "u", "oa", "oo", "oo", "oo", "ee", "ee", "ee", "ee"}, new String[]{"b", "bl", "br", "c", "cl", "cr", "ch", "d", "dr", "f", "fl", "fr", "g", "gl", "gr", "h", "j", "k", "l", "m", "n", "p", "pl", "pr", "qu", "r", "s", "sh", "sk", "st", "sp", "sl", "sm", "sn", "t", "tr", "th", "thr", "v", "w", "y", "z", "b", "bl", "br", "c", "cl", "cr", "ch", "d", "dr", "f", "fl", "fr", "g", "gr", "h", "j", "k", "l", "m", "n", "p", "pl", "pr", "r", "s", "sh", "st", "sp", "sl", "t", "tr", "th", "w", "y", "b", "br", "c", "ch", "d", "dr", "f", "g", "h", "j", "l", "m", "n", "p", "r", "s", "sh", "st", "sl", "t", "tr", "th", "b", "d", "f", "g", "h", "l", "m", "n", "p", "r", "s", "sh", "t", "th", "b", "d", "f", "g", "h", "l", "m", "n", "p", "r", "s", "sh", "t", "th", "r", "s", "t", "l", "n", "str", "spr", "spl", "wr", "kn", "kn", "gn"}, new String[]{"x", "cst", "bs", "ff", "lg", "g", "gs", "ll", "ltr", "mb", "mn", "mm", "ng", "ng", "ngl", "nt", "ns", "nn", "ps", "mbl", "mpr", "pp", "ppl", "ppr", "rr", "rr", "rr", "rl", "rtn", "ngr", "ss", "sc", "rst", "tt", "tt", "ts", "ltr", "zz"}, new String[]{"b", "rb", "bb", "c", "rc", "ld", "d", "ds", "dd", "f", "ff", "lf", "rf", "rg", "gs", "ch", "lch", "rch", "tch", "ck", "ck", "lk", "rk", "l", "ll", "lm", "m", "rm", "mp", "n", "nk", "nch", "nd", "ng", "ng", "nt", "ns", "lp", "rp", "p", "r", "rn", "rts", "s", "s", "s", "s", "ss", "ss", "st", "ls", "t", "t", "ts", "w", "wn", "x", "ly", "lly", "z", "b", "c", "d", "f", "g", "k", "l", "m", "n", "p", "r", "s", "t", "w"}, new String[]{"ate", "ite", "ism", "ist", "er", "er", "er", "ed", "ed", "ed", "es", "es", "ied", "y", "y", "y", "y", "ate", "ite", "ism", "ist", "er", "er", "er", "ed", "ed", "ed", "es", "es", "ied", "y", "y", "y", "y", "ate", "ite", "ism", "ist", "er", "er", "er", "ed", "ed", "ed", "es", "es", "ied", "y", "y", "y", "y", "ay", "ay", "ey", "oy", "ay", "ay", "ey", "oy", "ough", "aught", "ant", "ont", "oe", "ance", "ell", "eal", "oa", "urt", "ut", "iom", "ion", "ion", "ision", "ation", "ation", "ition", "ough", "aught", "ant", "ont", "oe", "ance", "ell", "eal", "oa", "urt", "ut", "iom", "ion", "ion", "ision", "ation", "ation", "ition", "ily", "ily", "ily", "adly", "owly", "oorly", "ardly", "iedly"}, new String[0], new int[]{1, 2, 3, 4}, new double[]{7.0, 8.0, 4.0, 1.0}, 0.22, 0.1, 0.0, 0.25, englishSanityChecks, true);
    }

    public Finnegan(String[] openingVowels, String[] midVowels, String[] openingConsonants, String[] midConsonants, String[] closingConsonants, String[] closingSyllables, String[] vowelSplitters, int[] syllableLengths, double[] syllableFrequencies, double vowelStartFrequency, double vowelEndFrequency, double vowelSplitFrequency, double syllableEndFrequency) {
        this(openingVowels, midVowels, openingConsonants, midConsonants, closingConsonants, closingSyllables, vowelSplitters, syllableLengths, syllableFrequencies, vowelStartFrequency, vowelEndFrequency, vowelSplitFrequency, syllableEndFrequency, englishSanityChecks, true);
    }

    public Finnegan(String[] openingVowels, String[] midVowels, String[] openingConsonants, String[] midConsonants, String[] closingConsonants, String[] closingSyllables, String[] vowelSplitters, int[] syllableLengths, double[] syllableFrequencies, double vowelStartFrequency, double vowelEndFrequency, double vowelSplitFrequency, double syllableEndFrequency, Pattern[] sane, boolean clean) {
        this.rng = new RNG(FNV1a.hash64(openingVowels, midVowels, openingConsonants, midConsonants, closingConsonants, closingSyllables, vowelSplitters) ^ FNV1a.hash64(syllableLengths) ^ FNV1a.hash64(syllableFrequencies) << 31 ^ Double.doubleToLongBits(vowelStartFrequency + 19.0 * (vowelEndFrequency + 19.0 * (vowelSplitFrequency + 19.0 * syllableEndFrequency))));
        this.openingVowels = openingVowels;
        this.midVowels = new String[openingVowels.length + midVowels.length];
        System.arraycopy(midVowels, 0, this.midVowels, 0, midVowels.length);
        System.arraycopy(openingVowels, 0, this.midVowels, midVowels.length, openingVowels.length);
        this.openingConsonants = openingConsonants;
        this.midConsonants = new String[midConsonants.length + closingConsonants.length];
        System.arraycopy(midConsonants, 0, this.midConsonants, 0, midConsonants.length);
        System.arraycopy(closingConsonants, 0, this.midConsonants, midConsonants.length, closingConsonants.length);
        this.closingConsonants = closingConsonants;
        this.vowelSplitters = vowelSplitters;
        this.closingSyllables = closingSyllables;
        this.syllableFrequencies = new LinkedHashMap(syllableLengths.length);
        int i = 0;
        while (i < syllableLengths.length && i < syllableFrequencies.length) {
            this.syllableFrequencies.put(syllableLengths[i], syllableFrequencies[i]);
            ++i;
        }
        for (Double freq : this.syllableFrequencies.values()) {
            this.totalSyllableFrequency += freq.doubleValue();
        }
        this.vowelStartFrequency = vowelStartFrequency > 1.0 ? 1.0 / vowelStartFrequency : vowelStartFrequency;
        this.vowelEndFrequency = vowelEndFrequency > 1.0 ? 1.0 / vowelEndFrequency : vowelEndFrequency;
        this.vowelSplitFrequency = vowelSplitters.length == 0 ? 0.0 : (vowelSplitFrequency > 1.0 ? 1.0 / vowelSplitFrequency : vowelSplitFrequency);
        this.syllableEndFrequency = closingSyllables.length == 0 ? 0.0 : (syllableEndFrequency > 1.0 ? 1.0 / syllableEndFrequency : syllableEndFrequency);
        this.clean = clean;
        this.sanityChecks = sane;
        this.modifiers = new ArrayList(16);
    }

    private Finnegan(String[] openingVowels, String[] midVowels, String[] openingConsonants, String[] midConsonants, String[] closingConsonants, String[] closingSyllables, String[] vowelSplitters, LinkedHashMap<Integer, Double> syllableFrequencies, double vowelStartFrequency, double vowelEndFrequency, double vowelSplitFrequency, double syllableEndFrequency, Pattern[] sanityChecks, boolean clean, RNG rng, Collection<Modifier> modifiers) {
        this.openingVowels = Finnegan.copyStrings(openingVowels);
        this.midVowels = Finnegan.copyStrings(midVowels);
        this.openingConsonants = Finnegan.copyStrings(openingConsonants);
        this.midConsonants = Finnegan.copyStrings(midConsonants);
        this.closingConsonants = Finnegan.copyStrings(closingConsonants);
        this.closingSyllables = Finnegan.copyStrings(closingSyllables);
        this.vowelSplitters = Finnegan.copyStrings(vowelSplitters);
        this.syllableFrequencies = new LinkedHashMap<Integer, Double>(syllableFrequencies);
        this.vowelStartFrequency = vowelStartFrequency;
        this.vowelEndFrequency = vowelEndFrequency;
        this.vowelSplitFrequency = vowelSplitFrequency;
        this.syllableEndFrequency = syllableEndFrequency;
        for (Double freq : this.syllableFrequencies.values()) {
            this.totalSyllableFrequency += freq.doubleValue();
        }
        if (sanityChecks == null) {
            this.sanityChecks = null;
        } else {
            this.sanityChecks = new Pattern[sanityChecks.length];
            System.arraycopy(sanityChecks, 0, this.sanityChecks, 0, sanityChecks.length);
        }
        this.clean = clean;
        this.rng = new RNG(rng.state);
        this.modifiers = new ArrayList<Modifier>(modifiers);
    }

    protected boolean checkAll(CharSequence testing, Pattern[] checks) {
        String fixed = this.removeAccents(testing);
        int i = 0;
        while (i < checks.length) {
            if (checks[i].matcher(fixed).find()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String word(boolean capitalize) {
        return this.word(this.rng.state, capitalize);
    }

    public String word(long seed, boolean capitalize) {
        StringBuffer sb;
        this.rng.state = seed;
        while (true) {
            sb = new StringBuffer(20);
            double syllableChance = this.rng.nextDouble(this.totalSyllableFrequency);
            int syllables = 1;
            int i = 0;
            for (Map.Entry<Integer, Double> kv : this.syllableFrequencies.entrySet()) {
                if (syllableChance < kv.getValue()) {
                    syllables = kv.getKey();
                    break;
                }
                syllableChance -= kv.getValue().doubleValue();
            }
            if (this.rng.nextDouble() < this.vowelStartFrequency) {
                sb.append(this.rng.getRandomElement(this.openingVowels));
                sb.append(this.rng.getRandomElement(this.midConsonants));
                ++i;
            } else {
                sb.append(this.rng.getRandomElement(this.openingConsonants));
            }
            while (i < syllables - 1) {
                sb.append(this.rng.getRandomElement(this.midVowels));
                if (this.rng.nextDouble() < this.vowelSplitFrequency) {
                    sb.append(this.rng.getRandomElement(this.vowelSplitters));
                    sb.append(this.rng.getRandomElement(this.midVowels));
                }
                sb.append(this.rng.getRandomElement(this.midConsonants));
                ++i;
            }
            if (this.rng.nextDouble() < this.syllableEndFrequency) {
                close = this.rng.getRandomElement(this.closingSyllables);
                if (close.contains("@1") && syllables == 1 || close.contains("@2") && syllables == 2 || close.contains("@3") && syllables == 3) {
                    sb.append(close.replaceAll("@\\d", sb.toString()));
                } else if (!close.contains("@")) {
                    sb.append(close);
                } else if (this.rng.nextDouble() < this.vowelEndFrequency) {
                    sb.append(this.rng.getRandomElement(this.midVowels));
                    if (this.rng.nextDouble() < this.vowelSplitFrequency) {
                        sb.append(this.rng.getRandomElement(this.vowelSplitters));
                        sb.append(this.rng.getRandomElement(this.midVowels));
                    }
                }
            } else {
                sb.append(this.rng.getRandomElement(this.midVowels));
                if (this.rng.nextDouble() < this.vowelSplitFrequency) {
                    sb.append(this.rng.getRandomElement(this.vowelSplitters));
                    sb.append(this.rng.getRandomElement(this.midVowels));
                }
                if (this.rng.nextDouble() >= this.vowelEndFrequency) {
                    sb.append(this.rng.getRandomElement(this.closingConsonants));
                    if (this.rng.nextDouble() < this.syllableEndFrequency) {
                        close = this.rng.getRandomElement(this.closingSyllables);
                        if (close.contains("@1") && syllables == 1 || close.contains("@2") && syllables == 2 || close.contains("@3") && syllables == 3) {
                            sb.append(close.replaceAll("@\\d", sb.toString()));
                        } else if (!close.contains("@")) {
                            sb.append(close);
                        }
                    }
                }
            }
            if (this.sanityChecks != null && !this.checkAll(sb, this.sanityChecks)) continue;
            for (Modifier mod : this.modifiers) {
                sb = mod.modify(this.rng, sb);
            }
            if (capitalize) {
                sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
            }
            if (!this.clean || this.checkAll(sb, vulgarChecks)) break;
        }
        return sb.toString();
    }

    public String word(boolean capitalize, int approxSyllables) {
        return this.word(this.rng.state, capitalize, approxSyllables);
    }

    public String word(long seed, boolean capitalize, int approxSyllables) {
        StringBuffer sb;
        this.rng.setState(seed);
        if (approxSyllables <= 0) {
            String finished = this.rng.getRandomElement(this.openingVowels);
            if (capitalize) {
                return finished.substring(0, 1).toUpperCase();
            }
            return finished.substring(0, 1);
        }
        while (true) {
            sb = new StringBuffer(20);
            int i = 0;
            if (this.rng.nextDouble() < this.vowelStartFrequency) {
                sb.append(this.rng.getRandomElement(this.openingVowels));
                sb.append(this.rng.getRandomElement(this.midConsonants));
                ++i;
            } else {
                sb.append(this.rng.getRandomElement(this.openingConsonants));
            }
            while (i < approxSyllables - 1) {
                sb.append(this.rng.getRandomElement(this.midVowels));
                if (this.rng.nextDouble() < this.vowelSplitFrequency) {
                    sb.append(this.rng.getRandomElement(this.vowelSplitters));
                    sb.append(this.rng.getRandomElement(this.midVowels));
                }
                sb.append(this.rng.getRandomElement(this.midConsonants));
                ++i;
            }
            if (this.rng.nextDouble() < this.syllableEndFrequency) {
                close = this.rng.getRandomElement(this.closingSyllables);
                if (close.contains("@1") && approxSyllables == 1 || close.contains("@2") && approxSyllables == 2 || close.contains("@3") && approxSyllables == 3) {
                    sb.append(close.replaceAll("@\\d", sb.toString()));
                } else if (!close.contains("@")) {
                    sb.append(close);
                } else if (this.rng.nextDouble() < this.vowelEndFrequency) {
                    sb.append(this.rng.getRandomElement(this.midVowels));
                    if (this.rng.nextDouble() < this.vowelSplitFrequency) {
                        sb.append(this.rng.getRandomElement(this.vowelSplitters));
                        sb.append(this.rng.getRandomElement(this.midVowels));
                    }
                }
            } else {
                sb.append(this.rng.getRandomElement(this.midVowels));
                if (this.rng.nextDouble() < this.vowelSplitFrequency) {
                    sb.append(this.rng.getRandomElement(this.vowelSplitters));
                    sb.append(this.rng.getRandomElement(this.midVowels));
                }
                if (this.rng.nextDouble() >= this.vowelEndFrequency) {
                    sb.append(this.rng.getRandomElement(this.closingConsonants));
                    if (this.rng.nextDouble() < this.syllableEndFrequency) {
                        close = this.rng.getRandomElement(this.closingSyllables);
                        if (close.contains("@1") && approxSyllables == 1 || close.contains("@2") && approxSyllables == 2 || close.contains("@3") && approxSyllables == 3) {
                            close = close.replaceAll("@\\d", sb.toString());
                            sb.append(close);
                        } else if (!close.contains("@")) {
                            sb.append(close);
                        }
                    }
                }
            }
            if (this.sanityChecks != null && !this.checkAll(sb, this.sanityChecks)) continue;
            for (Modifier mod : this.modifiers) {
                sb = mod.modify(this.rng, sb);
            }
            if (capitalize) {
                sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
            }
            if (!this.clean || this.checkAll(sb, vulgarChecks)) break;
        }
        return sb.toString();
    }

    public String sentence(int minWords, int maxWords) {
        return this.sentence(this.rng.state, minWords, maxWords, new String[]{",", ",", ",", ";"}, new String[]{".", ".", ".", "!", "?", "..."}, 0.2);
    }

    public String sentence(int minWords, int maxWords, String[] midPunctuation, String[] endPunctuation, double midPunctuationFrequency) {
        return this.sentence(this.rng.state, minWords, maxWords, midPunctuation, endPunctuation, midPunctuationFrequency);
    }

    public String sentence(long seed, int minWords, int maxWords, String[] midPunctuation, String[] endPunctuation, double midPunctuationFrequency) {
        this.rng.state = seed;
        if (minWords < 1) {
            minWords = 1;
        }
        if (minWords > maxWords) {
            maxWords = minWords;
        }
        if (midPunctuationFrequency > 1.0) {
            midPunctuationFrequency = 1.0 / midPunctuationFrequency;
        }
        StringBuilder sb = new StringBuilder(12 * maxWords);
        sb.append(this.word(true));
        int i = 1;
        while (i < minWords) {
            if (this.rng.nextDouble() < midPunctuationFrequency) {
                sb.append(this.rng.getRandomElement(midPunctuation));
            }
            sb.append(' ');
            sb.append(this.word(false));
            ++i;
        }
        i = minWords;
        while (i < maxWords && this.rng.nextInt(2 * maxWords) > i) {
            if (this.rng.nextDouble() < midPunctuationFrequency) {
                sb.append(this.rng.getRandomElement(midPunctuation));
            }
            sb.append(' ');
            sb.append(this.word(false));
            ++i;
        }
        sb.append(this.rng.getRandomElement(endPunctuation));
        return sb.toString();
    }

    public String sentence(int minWords, int maxWords, String[] midPunctuation, String[] endPunctuation, double midPunctuationFrequency, int maxChars) {
        return this.sentence(this.rng.state, minWords, maxWords, midPunctuation, endPunctuation, midPunctuationFrequency, maxChars);
    }

    public String sentence(long seed, int minWords, int maxWords, String[] midPunctuation, String[] endPunctuation, double midPunctuationFrequency, int maxChars) {
        this.rng.state = seed;
        if (minWords < 1) {
            minWords = 1;
        }
        if (minWords > maxWords) {
            maxWords = minWords;
        }
        if (midPunctuationFrequency > 1.0) {
            midPunctuationFrequency = 1.0 / midPunctuationFrequency;
        }
        if (maxChars < 4) {
            return "!";
        }
        if (maxChars <= 5 * minWords) {
            minWords = 1;
            maxWords = 1;
        }
        int frustration = 0;
        StringBuilder sb = new StringBuilder(maxChars);
        String next = this.word(true);
        while (next.length() >= maxChars - 1 && frustration < 50) {
            next = this.word(true);
            ++frustration;
        }
        if (frustration >= 50) {
            return "!";
        }
        sb.append(next);
        int i = 1;
        while (i < minWords && frustration < 50 && sb.length() < maxChars - 7) {
            if (this.rng.nextDouble() < midPunctuationFrequency && sb.length() < maxChars - 3) {
                sb.append(this.rng.getRandomElement(midPunctuation));
            }
            next = this.word(false);
            while (sb.length() + next.length() >= maxChars - 2 && frustration < 50) {
                next = this.word(false);
                ++frustration;
            }
            if (frustration >= 50) break;
            sb.append(' ');
            sb.append(next);
            ++i;
        }
        i = minWords;
        while (i < maxWords && sb.length() < maxChars - 7 && this.rng.nextInt(2 * maxWords) > i && frustration < 50) {
            if (this.rng.nextDouble() < midPunctuationFrequency && sb.length() < maxChars - 3) {
                sb.append(this.rng.getRandomElement(midPunctuation));
            }
            next = this.word(false);
            while (sb.length() + next.length() >= maxChars - 2 && frustration < 50) {
                next = this.word(false);
                ++frustration;
            }
            if (frustration >= 50) break;
            sb.append(' ');
            sb.append(next);
            ++i;
        }
        next = this.rng.getRandomElement(endPunctuation);
        if (sb.length() + next.length() >= maxChars) {
            next = ".";
        }
        sb.append(next);
        if (sb.length() > maxChars) {
            return "!";
        }
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    protected String[] merge1000(String[] me, String[] other, double otherInfluence) {
        block5: {
            if (other.length <= 0 && me.length <= 0) {
                return new String[0];
            }
            ret = new String[1000];
            otherCount = (int)(1000.0 * otherInfluence);
            idx = 0;
            if (other.length > 0) {
                tmp = this.rng.shuffle(other);
                idx = 0;
                while (idx < otherCount) {
                    ret[idx] = tmp[idx % tmp.length];
                    ++idx;
                }
            }
            if (me.length <= 0) ** GOTO lbl22
            tmp = this.rng.shuffle(me);
            while (idx < 1000) {
                ret[idx] = tmp[idx % tmp.length];
                ++idx;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                ret[idx] = other[idx % other.length];
                ++idx;
lbl22:
                // 2 sources

                ** while (idx < 1000)
            }
        }
        return ret;
    }

    protected String[] accentVowels(String[] me, double influence) {
        String[] ret = new String[1000];
        int otherCount = (int)(1000.0 * influence);
        int idx = 0;
        if (me.length > 0) {
            String[] tmp = this.rng.shuffle(me);
            idx = 0;
            while (idx < otherCount) {
                ret[idx] = tmp[idx % tmp.length].replace('a', accentedVowels[0][this.rng.nextInt(accentedVowels[0].length)]).replace('e', accentedVowels[1][this.rng.nextInt(accentedVowels[1].length)]).replace('i', accentedVowels[2][this.rng.nextInt(accentedVowels[2].length)]).replace('o', accentedVowels[3][this.rng.nextInt(accentedVowels[3].length)]).replace('u', accentedVowels[4][this.rng.nextInt(accentedVowels[4].length)]);
                Matcher matcher = repeats.matcher(ret[idx]);
                if (matcher.find()) {
                    ret[idx] = matcher.replaceAll(this.rng.getRandomElement(me));
                }
                ++idx;
            }
            while (idx < 1000) {
                ret[idx] = tmp[idx % tmp.length];
                ++idx;
            }
        } else {
            return new String[0];
        }
        return ret;
    }

    protected String[] accentConsonants(String[] me, double influence) {
        String[] ret = new String[1000];
        int otherCount = (int)(1000.0 * influence);
        int idx = 0;
        if (me.length > 0) {
            String[] tmp = this.rng.shuffle(me);
            idx = 0;
            while (idx < otherCount) {
                ret[idx] = tmp[idx % tmp.length].replace('c', accentedConsonants[1][this.rng.nextInt(accentedConsonants[1].length)]).replace('d', accentedConsonants[2][this.rng.nextInt(accentedConsonants[2].length)]).replace('f', accentedConsonants[3][this.rng.nextInt(accentedConsonants[3].length)]).replace('g', accentedConsonants[4][this.rng.nextInt(accentedConsonants[4].length)]).replace('h', accentedConsonants[5][this.rng.nextInt(accentedConsonants[5].length)]).replace('j', accentedConsonants[6][this.rng.nextInt(accentedConsonants[6].length)]).replace('k', accentedConsonants[7][this.rng.nextInt(accentedConsonants[7].length)]).replace('l', accentedConsonants[8][this.rng.nextInt(accentedConsonants[8].length)]).replace('n', accentedConsonants[10][this.rng.nextInt(accentedConsonants[10].length)]).replace('r', accentedConsonants[13][this.rng.nextInt(accentedConsonants[13].length)]).replace('s', accentedConsonants[14][this.rng.nextInt(accentedConsonants[14].length)]).replace('t', accentedConsonants[15][this.rng.nextInt(accentedConsonants[15].length)]).replace('w', accentedConsonants[17][this.rng.nextInt(accentedConsonants[17].length)]).replace('y', accentedConsonants[19][this.rng.nextInt(accentedConsonants[19].length)]).replace('z', accentedConsonants[20][this.rng.nextInt(accentedConsonants[20].length)]);
                Matcher matcher = repeats.matcher(ret[idx]);
                if (matcher.find()) {
                    ret[idx] = matcher.replaceAll(this.rng.getRandomElement(me));
                }
                ++idx;
            }
            while (idx < 1000) {
                ret[idx] = tmp[idx % tmp.length];
                ++idx;
            }
        } else {
            return new String[0];
        }
        return ret;
    }

    protected String[] accentBoth(String[] me, double vowelInfluence, double consonantInfluence) {
        String[] ret = new String[1000];
        int idx = 0;
        if (me.length > 0) {
            String[] tmp = this.rng.shuffle(me);
            idx = 0;
            while (idx < 1000) {
                boolean subCon;
                boolean subVowel = this.rng.nextDouble() < vowelInfluence;
                boolean bl = subCon = this.rng.nextDouble() < consonantInfluence;
                if (subVowel && subCon) {
                    ret[idx] = tmp[idx % tmp.length].replace('a', accentedVowels[0][this.rng.nextInt(accentedVowels[0].length)]).replace('e', accentedVowels[1][this.rng.nextInt(accentedVowels[1].length)]).replace('i', accentedVowels[2][this.rng.nextInt(accentedVowels[2].length)]).replace('o', accentedVowels[3][this.rng.nextInt(accentedVowels[3].length)]).replace('u', accentedVowels[4][this.rng.nextInt(accentedVowels[4].length)]).replace('c', accentedConsonants[1][this.rng.nextInt(accentedConsonants[1].length)]).replace('d', accentedConsonants[2][this.rng.nextInt(accentedConsonants[2].length)]).replace('f', accentedConsonants[3][this.rng.nextInt(accentedConsonants[3].length)]).replace('g', accentedConsonants[4][this.rng.nextInt(accentedConsonants[4].length)]).replace('h', accentedConsonants[5][this.rng.nextInt(accentedConsonants[5].length)]).replace('j', accentedConsonants[6][this.rng.nextInt(accentedConsonants[6].length)]).replace('k', accentedConsonants[7][this.rng.nextInt(accentedConsonants[7].length)]).replace('l', accentedConsonants[8][this.rng.nextInt(accentedConsonants[8].length)]).replace('n', accentedConsonants[10][this.rng.nextInt(accentedConsonants[10].length)]).replace('r', accentedConsonants[13][this.rng.nextInt(accentedConsonants[13].length)]).replace('s', accentedConsonants[14][this.rng.nextInt(accentedConsonants[14].length)]).replace('t', accentedConsonants[15][this.rng.nextInt(accentedConsonants[15].length)]).replace('w', accentedConsonants[17][this.rng.nextInt(accentedConsonants[17].length)]).replace('y', accentedConsonants[19][this.rng.nextInt(accentedConsonants[19].length)]).replace('z', accentedConsonants[20][this.rng.nextInt(accentedConsonants[20].length)]);
                    matcher = repeats.matcher(ret[idx]);
                    if (matcher.find()) {
                        ret[idx] = matcher.replaceAll(this.rng.getRandomElement(me));
                    }
                } else if (subVowel) {
                    ret[idx] = tmp[idx % tmp.length].replace('a', accentedVowels[0][this.rng.nextInt(accentedVowels[0].length)]).replace('e', accentedVowels[1][this.rng.nextInt(accentedVowels[1].length)]).replace('i', accentedVowels[2][this.rng.nextInt(accentedVowels[2].length)]).replace('o', accentedVowels[3][this.rng.nextInt(accentedVowels[3].length)]).replace('u', accentedVowels[4][this.rng.nextInt(accentedVowels[4].length)]);
                    matcher = repeats.matcher(ret[idx]);
                    if (matcher.find()) {
                        ret[idx] = matcher.replaceAll(this.rng.getRandomElement(me));
                    }
                } else if (subCon) {
                    ret[idx] = tmp[idx % tmp.length].replace('c', accentedConsonants[1][this.rng.nextInt(accentedConsonants[1].length)]).replace('d', accentedConsonants[2][this.rng.nextInt(accentedConsonants[2].length)]).replace('f', accentedConsonants[3][this.rng.nextInt(accentedConsonants[3].length)]).replace('g', accentedConsonants[4][this.rng.nextInt(accentedConsonants[4].length)]).replace('h', accentedConsonants[5][this.rng.nextInt(accentedConsonants[5].length)]).replace('j', accentedConsonants[6][this.rng.nextInt(accentedConsonants[6].length)]).replace('k', accentedConsonants[7][this.rng.nextInt(accentedConsonants[7].length)]).replace('l', accentedConsonants[8][this.rng.nextInt(accentedConsonants[8].length)]).replace('n', accentedConsonants[10][this.rng.nextInt(accentedConsonants[10].length)]).replace('r', accentedConsonants[13][this.rng.nextInt(accentedConsonants[13].length)]).replace('s', accentedConsonants[14][this.rng.nextInt(accentedConsonants[14].length)]).replace('t', accentedConsonants[15][this.rng.nextInt(accentedConsonants[15].length)]).replace('w', accentedConsonants[17][this.rng.nextInt(accentedConsonants[17].length)]).replace('y', accentedConsonants[19][this.rng.nextInt(accentedConsonants[19].length)]).replace('z', accentedConsonants[20][this.rng.nextInt(accentedConsonants[20].length)]);
                    matcher = repeats.matcher(ret[idx]);
                    if (matcher.find()) {
                        ret[idx] = matcher.replaceAll(this.rng.getRandomElement(me));
                    }
                } else {
                    ret[idx] = tmp[idx % tmp.length];
                }
                ++idx;
            }
        } else {
            return new String[0];
        }
        return ret;
    }

    public Finnegan mix(Finnegan other, double otherInfluence) {
        otherInfluence = Math.max(0.0, Math.min(otherInfluence, 1.0));
        double myInfluence = 1.0 - otherInfluence;
        long oldState = this.rng.state;
        this.rng.state = (long)this.hashCode() & 0xFFFFFFFFL | ((long)other.hashCode() & 0xFFFFFFFFL) << 32 ^ Double.doubleToLongBits(otherInfluence);
        String[] ov = this.merge1000(this.openingVowels, other.openingVowels, otherInfluence);
        String[] mv = this.merge1000(this.midVowels, other.midVowels, otherInfluence);
        String[] oc = this.merge1000(this.openingConsonants, other.openingConsonants, otherInfluence);
        String[] mc = this.merge1000(this.midConsonants, other.midConsonants, otherInfluence);
        String[] cc = this.merge1000(this.closingConsonants, other.closingConsonants, otherInfluence);
        String[] cs = this.merge1000(this.closingSyllables, other.closingSyllables, otherInfluence);
        String[] splitters = this.merge1000(this.vowelSplitters, other.vowelSplitters, otherInfluence);
        LinkedHashMap<Integer, Double> freqs = new LinkedHashMap<Integer, Double>(this.syllableFrequencies);
        for (Map.Entry<Integer, Double> kv : other.syllableFrequencies.entrySet()) {
            if (freqs.containsKey(kv.getKey())) {
                freqs.put(kv.getKey(), kv.getValue() + freqs.get(kv.getKey()));
                continue;
            }
            freqs.put(kv.getKey(), kv.getValue());
        }
        ArrayList<Modifier> mods = new ArrayList<Modifier>((int)(Math.ceil((double)this.modifiers.size() * myInfluence) + Math.ceil((double)other.modifiers.size() * otherInfluence)));
        mods.addAll(this.rng.randomPortion(this.modifiers, (int)Math.ceil((double)this.modifiers.size() * myInfluence)));
        mods.addAll(this.rng.randomPortion(other.modifiers, (int)Math.ceil((double)other.modifiers.size() * otherInfluence)));
        Finnegan finished = new Finnegan(ov, mv, oc, mc, cc, cs, splitters, freqs, this.vowelStartFrequency * myInfluence + other.vowelStartFrequency * otherInfluence, this.vowelEndFrequency * myInfluence + other.vowelEndFrequency * otherInfluence, this.vowelSplitFrequency * myInfluence + other.vowelSplitFrequency * otherInfluence, this.syllableEndFrequency * myInfluence + other.syllableEndFrequency * otherInfluence, this.sanityChecks == null ? other.sanityChecks : this.sanityChecks, true, new RNG(this.rng.state), mods);
        this.rng.state = oldState;
        return finished;
    }

    public Finnegan addAccents(double vowelInfluence, double consonantInfluence) {
        vowelInfluence = Math.max(0.0, Math.min(vowelInfluence, 1.0));
        consonantInfluence = Math.max(0.0, Math.min(consonantInfluence, 1.0));
        long oldState = this.rng.state;
        this.rng.state = (long)this.hashCode() & 0xFFFFFFFFL ^ (Double.doubleToLongBits(vowelInfluence) & 0xFFFFFFFFL | Double.doubleToLongBits(consonantInfluence) << 32);
        String[] ov = this.accentVowels(this.openingVowels, vowelInfluence);
        String[] mv = this.accentVowels(this.midVowels, vowelInfluence);
        String[] oc = this.accentConsonants(this.openingConsonants, consonantInfluence);
        String[] mc = this.accentConsonants(this.midConsonants, consonantInfluence);
        String[] cc = this.accentConsonants(this.closingConsonants, consonantInfluence);
        String[] cs = this.accentBoth(this.closingSyllables, vowelInfluence, consonantInfluence);
        int[] lens = new int[this.syllableFrequencies.size()];
        double[] odds = new double[this.syllableFrequencies.size()];
        int i = 0;
        for (Map.Entry<Integer, Double> kv : this.syllableFrequencies.entrySet()) {
            lens[i] = kv.getKey();
            odds[i++] = kv.getValue();
        }
        Finnegan finished = new Finnegan(ov, mv, oc, mc, cc, cs, this.vowelSplitters, lens, odds, this.vowelStartFrequency, this.vowelEndFrequency, this.vowelSplitFrequency, this.syllableEndFrequency, this.sanityChecks, this.clean);
        finished.rng.state = this.rng.state;
        this.rng.state = oldState;
        return finished;
    }

    static String[] copyStrings(String[] start) {
        String[] next = new String[start.length];
        System.arraycopy(start, 0, next, 0, start.length);
        return next;
    }

    public Finnegan removeAccents() {
        String[] ov = (String[])this.openingVowels.clone();
        String[] mv = (String[])this.midVowels.clone();
        String[] oc = (String[])this.openingConsonants.clone();
        String[] mc = (String[])this.midConsonants.clone();
        String[] cc = (String[])this.closingConsonants.clone();
        String[] cs = (String[])this.closingSyllables.clone();
        int i = 0;
        while (i < ov.length) {
            ov[i] = this.removeAccents(this.openingVowels[i]);
            ++i;
        }
        i = 0;
        while (i < mv.length) {
            mv[i] = this.removeAccents(this.midVowels[i]);
            ++i;
        }
        i = 0;
        while (i < oc.length) {
            oc[i] = this.removeAccents(this.openingConsonants[i]);
            ++i;
        }
        i = 0;
        while (i < mc.length) {
            mc[i] = this.removeAccents(this.midConsonants[i]);
            ++i;
        }
        i = 0;
        while (i < cc.length) {
            cc[i] = this.removeAccents(this.closingConsonants[i]);
            ++i;
        }
        i = 0;
        while (i < cs.length) {
            cs[i] = this.removeAccents(this.closingSyllables[i]);
            ++i;
        }
        int[] lens = new int[this.syllableFrequencies.size()];
        double[] odds = new double[this.syllableFrequencies.size()];
        int i2 = 0;
        for (Map.Entry<Integer, Double> kv : this.syllableFrequencies.entrySet()) {
            lens[i2] = kv.getKey();
            odds[i2++] = kv.getValue();
        }
        Finnegan finished = new Finnegan(ov, mv, oc, mc, cc, cs, this.vowelSplitters, lens, odds, this.vowelStartFrequency, this.vowelEndFrequency, this.vowelSplitFrequency, this.syllableEndFrequency, this.sanityChecks, this.clean);
        finished.rng.state = this.rng.state;
        return finished;
    }

    public Finnegan addModifiers(Collection<Modifier> mods) {
        Finnegan next = this.copy();
        next.modifiers.addAll(mods);
        return next;
    }

    public Finnegan addModifiers(Modifier ... mods) {
        Finnegan next = this.copy();
        Collections.addAll(next.modifiers, mods);
        return next;
    }

    public Finnegan removeModifiers() {
        Finnegan next = this.copy();
        next.modifiers.clear();
        return next;
    }

    public static Modifier modifier(String pattern, String replacement) {
        return new Modifier(pattern, replacement);
    }

    public static Modifier modifier(String pattern, String replacement, double chance) {
        return new Modifier(pattern, replacement, chance);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Finnegan finnegan = (Finnegan)o;
        if (this.clean != finnegan.clean) {
            return false;
        }
        if (Double.compare(finnegan.totalSyllableFrequency, this.totalSyllableFrequency) != 0) {
            return false;
        }
        if (Double.compare(finnegan.vowelStartFrequency, this.vowelStartFrequency) != 0) {
            return false;
        }
        if (Double.compare(finnegan.vowelEndFrequency, this.vowelEndFrequency) != 0) {
            return false;
        }
        if (Double.compare(finnegan.vowelSplitFrequency, this.vowelSplitFrequency) != 0) {
            return false;
        }
        if (Double.compare(finnegan.syllableEndFrequency, this.syllableEndFrequency) != 0) {
            return false;
        }
        if (!Arrays.equals(this.openingVowels, finnegan.openingVowels)) {
            return false;
        }
        if (!Arrays.equals(this.midVowels, finnegan.midVowels)) {
            return false;
        }
        if (!Arrays.equals(this.openingConsonants, finnegan.openingConsonants)) {
            return false;
        }
        if (!Arrays.equals(this.midConsonants, finnegan.midConsonants)) {
            return false;
        }
        if (!Arrays.equals(this.closingConsonants, finnegan.closingConsonants)) {
            return false;
        }
        if (!Arrays.equals(this.vowelSplitters, finnegan.vowelSplitters)) {
            return false;
        }
        if (!Arrays.equals(this.closingSyllables, finnegan.closingSyllables)) {
            return false;
        }
        if (this.syllableFrequencies != null ? !this.syllableFrequencies.equals(finnegan.syllableFrequencies) : finnegan.syllableFrequencies != null) {
            return false;
        }
        if (!Arrays.equals(this.sanityChecks, finnegan.sanityChecks)) {
            return false;
        }
        if (this.rng != null ? !this.rng.equals(finnegan.rng) : finnegan.rng != null) {
            return false;
        }
        return this.modifiers != null ? this.modifiers.equals(finnegan.modifiers) : finnegan.modifiers == null;
    }

    public int hashCode() {
        long result = FNV1a.hash64(this.openingVowels);
        result = 31L * result + FNV1a.hash64(this.midVowels);
        result = 31L * result + FNV1a.hash64(this.openingConsonants);
        result = 31L * result + FNV1a.hash64(this.midConsonants);
        result = 31L * result + FNV1a.hash64(this.closingConsonants);
        result = 31L * result + FNV1a.hash64(this.vowelSplitters);
        result = 31L * result + FNV1a.hash64(this.closingSyllables);
        result = 31L * result + (long)(this.clean ? 1 : 0);
        result = 31L * result + (long)(this.syllableFrequencies != null ? this.syllableFrequencies.hashCode() : 0);
        long temp = Double.doubleToLongBits(this.totalSyllableFrequency);
        result = 31L * result + (long)((int)(temp ^ temp >>> 32));
        temp = Double.doubleToLongBits(this.vowelStartFrequency);
        result = 31L * result + (long)((int)(temp ^ temp >>> 32));
        temp = Double.doubleToLongBits(this.vowelEndFrequency);
        result = 31L * result + (long)((int)(temp ^ temp >>> 32));
        temp = Double.doubleToLongBits(this.vowelSplitFrequency);
        result = 31L * result + (long)((int)(temp ^ temp >>> 32));
        temp = Double.doubleToLongBits(this.syllableEndFrequency);
        result = 31L * result + (long)((int)(temp ^ temp >>> 32));
        result = 31L * result + (long)(this.sanityChecks != null ? this.sanityChecks.length + 1 : 0);
        result = 31L * result + (long)(this.modifiers != null ? this.modifiers.hashCode() : 0);
        result = 31L * result + (long)(this.rng != null ? this.rng.hashCode() : 0);
        return (int)result;
    }

    public String toString() {
        return "Finnegan{openingVowels=" + Arrays.toString(this.openingVowels) + ", midVowels=" + Arrays.toString(this.midVowels) + ", openingConsonants=" + Arrays.toString(this.openingConsonants) + ", midConsonants=" + Arrays.toString(this.midConsonants) + ", closingConsonants=" + Arrays.toString(this.closingConsonants) + ", vowelSplitters=" + Arrays.toString(this.vowelSplitters) + ", closingSyllables=" + Arrays.toString(this.closingSyllables) + ", syllableFrequencies=" + String.valueOf(this.syllableFrequencies) + ", totalSyllableFrequency=" + this.totalSyllableFrequency + ", vowelStartFrequency=" + this.vowelStartFrequency + ", vowelEndFrequency=" + this.vowelEndFrequency + ", vowelSplitFrequency=" + this.vowelSplitFrequency + ", syllableEndFrequency=" + this.syllableEndFrequency + ", sanityChecks=" + Arrays.toString(this.sanityChecks) + ", clean=" + this.clean + ", modifiers=" + String.valueOf(this.modifiers) + ", RNG=" + String.valueOf(this.rng) + "}";
    }

    public long getSeed() {
        return this.rng.state;
    }

    public void setSeed(long seed) {
        this.rng.state = seed;
    }

    public Finnegan copy() {
        return new Finnegan(this.openingVowels, this.midVowels, this.openingConsonants, this.midConsonants, this.closingConsonants, this.closingSyllables, this.vowelSplitters, this.syllableFrequencies, this.vowelStartFrequency, this.vowelEndFrequency, this.vowelSplitFrequency, this.syllableEndFrequency, this.sanityChecks, this.clean, this.rng, this.modifiers);
    }

    public static class Alteration
    implements Serializable {
        private static final long serialVersionUID = -2138854697837563188L;
        public Pattern pattern;
        public String replacer;
        public double chance;

        public Alteration() {
            this("[s\u015b\u015d\u015f\u0161\u0219]+h?", "th");
        }

        public Alteration(String pattern, String replacement) {
            this.pattern = Pattern.compile(pattern);
            this.replacer = replacement;
            this.chance = 1.0;
        }

        public Alteration(String pattern, String replacement, double chance) {
            this.pattern = Pattern.compile(pattern);
            this.replacer = replacement;
            this.chance = chance;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Alteration that = (Alteration)o;
            if (Double.compare(that.chance, this.chance) != 0) {
                return false;
            }
            return this.replacer.equals(that.replacer);
        }

        public int hashCode() {
            long result = FNV1a.hash64(this.replacer);
            result = 31L * result + (long)this.pattern.hashCode();
            long temp = Double.doubleToLongBits(this.chance);
            result = 31L * result + (temp ^ temp >>> 32);
            return (int)result;
        }

        public String toString() {
            return "Alteration{pattern=" + String.valueOf(this.pattern) + "replacer=" + this.replacer + ", chance=" + this.chance + "}";
        }
    }

    public static class Modifier
    implements Serializable {
        private static final long serialVersionUID = 1734863678490422371L;
        public final Alteration[] alterations;
        public static final Modifier LISP = new Modifier("[s\u015b\u015d\u015f\u0161\u0219]+h?", "th");
        public static final Modifier HISS = new Modifier("(.)([s\u015b\u015d\u015f\u0161\u0219z\u017a\u017c\u017e])+", "$1$2$2$2");
        public static final Modifier STUTTER = new Modifier(new Alteration("^([^a\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u0101\u0103\u0105\u01fb\u01fde\u00e8\u00e9\u00ea\u00eb\u0113\u0115\u0117\u0119\u011bi\u00ec\u00ed\u00ee\u00ef\u0129\u012b\u012d\u012f\u0131o\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u014d\u014f\u0151\u0153\u01ffu\u00f9\u00fa\u00fb\u00fc\u0169\u016b\u016d\u016f\u0171\u0173y\u00fd\u00ff\u0177\u1ef3\u03b1\u03bf\u03b5\u03b9\u03c5\u0430\u0435\u0451\u0438\u0439\u044a\u044b\u044d\u044e\u044f\u043e\u0443]+)", "$1-$1", 0.2), new Alteration("^([a\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u0101\u0103\u0105\u01fb\u01fde\u00e8\u00e9\u00ea\u00eb\u0113\u0115\u0117\u0119\u011bi\u00ec\u00ed\u00ee\u00ef\u0129\u012b\u012d\u012f\u0131o\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u014d\u014f\u0151\u0153\u01ffu\u00f9\u00fa\u00fb\u00fc\u0169\u016b\u016d\u016f\u0171\u0173\u03b1\u03bf\u03b5\u03b9\u03c5\u0430\u0435\u0451\u0438\u0439\u044a\u044b\u044d\u044e\u044f\u043e\u0443]+)", "$1-$1", 0.2));
        public static final Modifier DOUBLE_VOWELS = new Modifier("([a\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u0101\u0103\u0105\u01fb\u01fde\u00e8\u00e9\u00ea\u00eb\u0113\u0115\u0117\u0119\u011b\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u014d\u014f\u0151\u0153\u01ff])([^a\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u0101\u0103\u0105\u01fb\u01fde\u00e8\u00e9\u00ea\u00eb\u0113\u0115\u0117\u0119\u011bi\u00ec\u00ed\u00ee\u00ef\u0129\u012b\u012d\u012f\u0131o\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u014d\u014f\u0151\u0153\u01ffu\u00f9\u00fa\u00fb\u00fc\u0169\u016b\u016d\u016f\u0171\u0173y\u00fd\u00ff\u0177\u1ef3]|$)", "$1$1$2", 0.4);
        public static final Modifier DOUBLE_CONSONANTS = new Modifier("([a\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u0101\u0103\u0105\u01fb\u01fde\u00e8\u00e9\u00ea\u00eb\u0113\u0115\u0117\u0119\u011bi\u00ec\u00ed\u00ee\u00ef\u0129\u012b\u012d\u012f\u0131o\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u014d\u014f\u0151\u0153\u01ffu\u00f9\u00fa\u00fb\u00fc\u0169\u016b\u016d\u016f\u0171\u0173y\u00fd\u00ff\u0177\u1ef3\u03b1\u03bf\u03b5\u03b9\u03c5\u0430\u0435\u0451\u0438\u0439\u044a\u044b\u044d\u044e\u044f\u043e\u0443]|^)([^a\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u0101\u0103\u0105\u01fb\u01fde\u00e8\u00e9\u00ea\u00eb\u0113\u0115\u0117\u0119\u011bi\u00ec\u00ed\u00ee\u00ef\u0129\u012b\u012d\u012f\u0131o\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u014d\u014f\u0151\u0153\u01ffu\u00f9\u00fa\u00fb\u00fc\u0169\u016b\u016d\u016f\u0171\u0173y\u00fd\u00ff\u0177\u1ef3\u03b1\u03bf\u03b5\u03b9\u03c5\u0430\u0435\u0451\u0438\u0439\u044a\u044b\u044d\u044e\u044f\u043e\u0443qwhjx])([a\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u0101\u0103\u0105\u01fb\u01fde\u00e8\u00e9\u00ea\u00eb\u0113\u0115\u0117\u0119\u011bi\u00ec\u00ed\u00ee\u00ef\u0129\u012b\u012d\u012f\u0131o\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u014d\u014f\u0151\u0153\u01ffu\u00f9\u00fa\u00fb\u00fc\u0169\u016b\u016d\u016f\u0171\u0173y\u00fd\u00ff\u0177\u1ef3\u03b1\u03bf\u03b5\u03b9\u03c5\u0430\u0435\u0451\u0438\u0439\u044a\u044b\u044d\u044e\u044f\u043e\u0443]|$)", "$1$2$2$3", 0.5);
        public static final Modifier NO_DOUBLES = new Modifier("(.)\\1", "$1");

        public Modifier() {
            this("sh?", "th");
        }

        public Modifier(String pattern, String replacement) {
            this.alterations = new Alteration[]{new Alteration(pattern, replacement)};
        }

        public Modifier(String pattern, String replacement, double chance) {
            this.alterations = new Alteration[]{new Alteration(pattern, replacement, chance)};
        }

        public Modifier(Alteration ... alts) {
            this.alterations = alts == null ? new Alteration[]{} : alts;
        }

        public StringBuffer modify(RNG rng, StringBuffer sb) {
            Alteration[] alterationArray = this.alterations;
            int n = this.alterations.length;
            int n2 = 0;
            while (n2 < n) {
                Alteration alt = alterationArray[n2];
                Matcher m = alt.pattern.matcher(sb);
                StringBuffer sb2 = new StringBuffer();
                while (m.find()) {
                    if (rng.nextDouble() < alt.chance) {
                        m.appendReplacement(sb2, alt.replacer);
                        continue;
                    }
                    m.appendReplacement(sb2, m.group());
                }
                m.appendTail(sb2);
                sb = sb2;
                ++n2;
            }
            return sb;
        }

        public static Modifier replacementTable(String initial, String change) {
            Alteration[] alts = new Alteration[Math.min(initial.length(), change.length())];
            int i = 0;
            while (i < alts.length) {
                alts[i] = new Alteration("\\Q" + initial.charAt(i) + "\\E", change.substring(i, i + 1));
                ++i;
            }
            return new Modifier(alts);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Modifier modifier = (Modifier)o;
            return Arrays.equals(this.alterations, modifier.alterations);
        }

        public int hashCode() {
            return Arrays.hashCode(this.alterations);
        }

        public String toString() {
            return "Modifier{alterations=" + Arrays.toString(this.alterations) + "}";
        }
    }

    public class RNG
    implements Serializable {
        private static final long serialVersionUID = 4378460257281186371L;
        private static final long DOUBLE_MASK = 0x1FFFFFFFFFFFFFL;
        private static final double NORM_53 = (double)1.110223E-16f;
        public long state;

        public RNG() {
            this.state = Double.doubleToLongBits(Math.random());
        }

        public RNG(long seed) {
            this.state = seed;
        }

        public long nextLong() {
            long z = this.state += -7046029254386353131L;
            z = (z ^ z >>> 30) * -4658895280553007687L;
            z = (z ^ z >>> 27) * -7723592293110705685L;
            return z ^ z >>> 31;
        }

        public int nextInt() {
            return (int)this.nextLong();
        }

        public int nextInt(int n) {
            if (n <= 0) {
                throw new IllegalArgumentException();
            }
            int bits = this.nextInt() >>> 1;
            return bits % n;
        }

        public int nextInt(int lower, int upper) {
            if (upper - lower <= 0) {
                throw new IllegalArgumentException();
            }
            return lower + this.nextInt(upper - lower);
        }

        public long nextLong(long n) {
            if (n <= 0L) {
                throw new IllegalArgumentException();
            }
            long bits = this.nextLong() >>> 1;
            return bits % n;
        }

        public long nextLong(long lower, long upper) {
            if (upper - lower <= 0L) {
                throw new IllegalArgumentException();
            }
            return lower + this.nextLong(upper - lower);
        }

        public double nextDouble() {
            return (double)(this.nextLong() & 0x1FFFFFFFFFFFFFL) * (double)1.110223E-16f;
        }

        public double nextDouble(double outer) {
            return this.nextDouble() * outer;
        }

        public <T> T getRandomElement(T[] array) {
            if (array.length < 1) {
                return null;
            }
            return array[this.nextInt(array.length)];
        }

        public <T> T[] shuffle(T[] elements) {
            Object[] array = (Object[])elements.clone();
            int n = array.length;
            int i = 0;
            while (i < n) {
                int r = i + this.nextInt(n - i);
                Object t = array[r];
                array[r] = array[i];
                array[i] = t;
                ++i;
            }
            return array;
        }

        public <T> ArrayList<T> shuffle(List<T> elements) {
            ArrayList<T> al = new ArrayList<T>(elements);
            int n = al.size();
            int i = 0;
            while (i < n) {
                Collections.swap(al, i + this.nextInt(n - i), i);
                ++i;
            }
            return al;
        }

        public <T> List<T> randomPortion(List<T> data, int count) {
            return this.shuffle(data).subList(0, Math.min(count, data.size()));
        }

        public long getState() {
            return this.state;
        }

        public void setState(long state) {
            this.state = state;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RNG rng = (RNG)o;
            return this.state == rng.state;
        }

        public int hashCode() {
            return (int)(this.state ^ this.state >>> 32);
        }

        public String toString() {
            return "RNG{state=" + this.state + "}";
        }
    }
}

