/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mockdata.engine.model;

import com.dbeaver.ee.mockdata.engine.model.MockGeneratorDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public class MockGeneratorRegistry {
    static final String TAG_GENERATOR = "generator";
    public static final String FK_GENERATOR_ID = "fkGenerator";
    private static final Log log = Log.getLog(MockGeneratorRegistry.class);
    private static MockGeneratorRegistry instance = null;
    private final List<MockGeneratorDescriptor> generators = new ArrayList<MockGeneratorDescriptor>();

    public static synchronized MockGeneratorRegistry getInstance() {
        if (instance == null) {
            instance = new MockGeneratorRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private MockGeneratorRegistry() {
    }

    private void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement[] extConfigs;
        HashSet<String> replacedSet = new HashSet<String>();
        IConfigurationElement[] iConfigurationElementArray = extConfigs = registry.getConfigurationElementsFor("org.jkiss.dbeaver.mockGenerator");
        int n = extConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if (TAG_GENERATOR.equals(ext.getName())) {
                MockGeneratorDescriptor generatorDescriptor = new MockGeneratorDescriptor(ext);
                this.generators.add(generatorDescriptor);
                String[] replaces = generatorDescriptor.getReplaces();
                if (replaces != null) {
                    replacedSet.addAll(Arrays.asList(replaces));
                }
                if (!CommonUtils.isEmpty(generatorDescriptor.getPresets())) {
                    for (MockGeneratorDescriptor.Preset preset : generatorDescriptor.getPresets()) {
                        this.generators.add(new MockGeneratorDescriptor(ext, preset));
                    }
                }
            }
            ++n2;
        }
        for (String replaced : replacedSet) {
            MockGeneratorDescriptor generator = this.getGenerator(replaced);
            if (generator == null) continue;
            this.generators.remove((Object)generator);
        }
    }

    public void dispose() {
        this.generators.clear();
    }

    @Nullable
    public MockGeneratorDescriptor findGenerator(DBPDataSource dataSource, DBSTypedObject typedObject) {
        for (MockGeneratorDescriptor descriptor : this.generators) {
            if ((descriptor.isGlobal() || !descriptor.supportsDataSource(dataSource) || !descriptor.supportsType(typedObject)) && (!descriptor.isGlobal() || !descriptor.supportsType(typedObject))) continue;
            return descriptor;
        }
        return null;
    }

    public List<MockGeneratorDescriptor> findAllGenerators(DBPDataSource dataSource, DBSTypedObject typedObject) {
        ArrayList<MockGeneratorDescriptor> result = new ArrayList<MockGeneratorDescriptor>();
        for (MockGeneratorDescriptor descriptor : this.generators) {
            if (FK_GENERATOR_ID.equalsIgnoreCase(descriptor.getId()) || (descriptor.isGlobal() || !descriptor.supportsDataSource(dataSource) || !descriptor.supportsType(typedObject)) && (!descriptor.isGlobal() || !descriptor.supportsType(typedObject))) continue;
            result.add(descriptor);
        }
        return result;
    }

    public MockGeneratorDescriptor getGenerator(String id) {
        for (MockGeneratorDescriptor descriptor : this.generators) {
            if (!id.equals(descriptor.getId())) continue;
            return descriptor;
        }
        return null;
    }
}

