/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mockdata.engine.model.tasks;

import com.dbeaver.ee.mockdata.engine.model.tasks.EntityProperties;
import com.dbeaver.ee.mockdata.engine.model.tasks.MockDataExecutor;
import com.dbeaver.ee.mockdata.engine.model.tasks.MockDataSettings;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.model.task.DBTTaskHandler;
import org.jkiss.dbeaver.model.task.DBTTaskRunStatus;

public class MockDataTaskHandler
implements DBTTaskHandler {
    @NotNull
    public DBTTaskRunStatus executeTask(@NotNull DBRRunnableContext runnableContext, @NotNull DBTTask task, @NotNull Locale locale, @NotNull Log log, @NotNull PrintStream logStream, @NotNull DBTTaskExecutionListener listener) throws DBException {
        listener.taskStarted(task);
        DBCStatistics statistics = new DBCStatistics();
        MockDataSettings settings = new MockDataSettings();
        MockDataExecutor executor = new MockDataExecutor();
        try {
            runnableContext.run(true, true, monitor -> {
                try {
                    settings.loadFrom(monitor, (List)task.getProperties().get("entities"));
                    for (EntityProperties entityProperties : settings.getEntityPropertiesList()) {
                        executor.generateMockData(monitor, entityProperties, logStream);
                    }
                }
                catch (IOException | DBException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            throw new DBException("Error loading task settings", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            return new DBTTaskRunStatus();
        }
        return DBTTaskRunStatus.makeStatisticsStatus((DBCStatistics)statistics);
    }
}

