/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mockdata.ui;

import com.dbeaver.ee.mockdata.engine.model.tasks.EntityProperties;
import com.dbeaver.ee.mockdata.engine.model.tasks.MockDataExecutor;
import com.dbeaver.ee.mockdata.engine.model.tasks.MockDataSettings;
import com.dbeaver.ee.mockdata.ui.MockDataWizardPageLog;
import com.dbeaver.ee.mockdata.ui.MockDataWizardPageSettings;
import com.dbeaver.ee.mockdata.ui.internal.MockDataUIActivator;
import com.dbeaver.ee.mockdata.ui.internal.MockDataUIMessages;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizard;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizardDialog;
import org.jkiss.dbeaver.ui.DialogSettingsMap;
import org.jkiss.dbeaver.ui.UIUtils;

public class MockDataExecuteWizard
extends TaskConfigurationWizard<MockDataSettings> {
    private static final String WIZARD_DIALOG_SETTINGS = "MockData";
    private MockDataSettings mockDataSettings = new MockDataSettings();
    private MockDataWizardPageSettings settingsPage;
    private MockDataWizardPageLog logPage;
    private final DialogSettingsMap dialogSettingsMap;

    MockDataExecuteWizard(@Nullable DBTTask task) {
        super(task);
        if (task != null && !task.getProperties().isEmpty() && task.getProperties().get("entities") instanceof List) {
            try {
                this.mockDataSettings.loadFrom((DBRProgressMonitor)new VoidProgressMonitor(), (List)task.getProperties().get("entities"));
            }
            catch (DBException e) {
                throw new RuntimeException(e);
            }
        }
        this.setDialogSettings(UIUtils.getSettingsSection((IDialogSettings)MockDataUIActivator.getDefault().getDialogSettings(), (String)WIZARD_DIALOG_SETTINGS));
        this.dialogSettingsMap = new DialogSettingsMap(this.getDialogSettings());
        this.mockDataSettings.saveTo((Map)this.dialogSettingsMap);
    }

    MockDataExecuteWizard(@Nullable DBTTask task, MockDataSettings mockDataSettings) {
        this(task);
        this.mockDataSettings = mockDataSettings;
    }

    protected MockDataSettings getSettings() {
        return this.mockDataSettings;
    }

    protected String getDefaultWindowTitle() {
        return MockDataUIMessages.tools_mockdata_wizard_title;
    }

    public String getTaskTypeId() {
        return "mockDataGenerate";
    }

    public void saveTaskState(DBRRunnableContext runnableContext, DBTTask task, Map<String, Object> state) {
        this.mockDataSettings.saveTo(state);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        ArrayList<EntityProperties> entityPropertiesList = new ArrayList<EntityProperties>();
        if (!selection.isEmpty()) {
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof DBSObject) {
                    DBSObject object = (DBSObject)element;
                    entityPropertiesList.add(new EntityProperties(object));
                }
                ++n2;
            }
            if (!entityPropertiesList.isEmpty()) {
                this.mockDataSettings.setEntityPropertiesList(entityPropertiesList);
            }
        }
        this.settingsPage = new MockDataWizardPageSettings(this.mockDataSettings);
        this.logPage = new MockDataWizardPageLog(this.getDefaultWindowTitle());
    }

    public boolean canFinish() {
        if (this.mockDataSettings == null) {
            return false;
        }
        if (!super.canFinish() || !this.mockDataSettings.isInitialized()) {
            return false;
        }
        for (EntityProperties properties : this.mockDataSettings.getEntityPropertiesList()) {
            if (!properties.getAttributeGenerators().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean performCancel() {
        this.mockDataSettings.saveTo((Map)this.dialogSettingsMap);
        return super.performCancel();
    }

    public boolean performFinish() {
        if (this.getCurrentTask() == null || this.getCurrentTask() != null && this.getCurrentTask().isTemporary()) {
            TaskConfigurationWizardDialog container = this.getContainer();
            container.disableButtonsOnProgress();
            this.logPage.clearLog();
            this.showLogPage();
            try {
                container.run(true, true, monitor1 -> {
                    DefaultProgressMonitor monitor = new DefaultProgressMonitor(monitor1);
                    this.mockDataSettings.sortEntityProperties((DBRProgressMonitor)monitor);
                    try {
                        MockDataExecutor mockDataExecutor = new MockDataExecutor();
                        monitor.beginTask("Generating mock data", this.mockDataSettings.getEntityPropertiesList().size());
                        for (EntityProperties entityProperties : this.mockDataSettings.getEntityPropertiesList()) {
                            mockDataExecutor.generateMockData((DBRProgressMonitor)monitor, entityProperties, this.logPage.getWriter());
                        }
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
            catch (InvocationTargetException e) {
                DBWorkbench.getPlatformUI().showError("Mock data generator", "Mock data generation failed", (Throwable)e);
            }
            catch (InterruptedException interruptedException) {}
            container.enableButtonsAfterProgress();
            container.setCompleteMarkAfterProgress();
            return false;
        }
        return super.performFinish();
    }

    private void showLogPage() {
        if (this.getContainer().getCurrentPage() != this.logPage) {
            this.getContainer().showPage((IWizardPage)this.logPage);
        }
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.settingsPage);
        this.addPage((IWizardPage)this.logPage);
    }

    public boolean isRunTaskOnFinish() {
        return this.getCurrentTask() != null && !this.getCurrentTask().isTemporary();
    }
}

