/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qm.db.impl;

import com.dbeaver.ee.qm.db.impl.QMDBModel;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCTransaction;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.PeriodicJob;
import org.jkiss.utils.CommonUtils;

public class QMDBAIConversationTtlJob
extends PeriodicJob {
    private static final Log log = Log.getLog(QMDBAIConversationTtlJob.class);
    @NotNull
    private final QMDBModel qmdbModel;

    public QMDBAIConversationTtlJob(@NotNull DBPPlatform platform, @NotNull QMDBModel qmdbModel) {
        super("QMDB AI conversation TTL cleanup", platform, Duration.ofDays(1L));
        this.qmdbModel = qmdbModel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doJob(@NotNull DBRProgressMonitor monitor) {
        if (!this.qmdbModel.isInitialized()) {
            return;
        }
        int ttl = CommonUtils.toInt((Object)this.platform.getPreferenceStore().getString("qmdb.ai.conversation.ttl"), (int)7);
        if (ttl <= 0) {
            log.warn((Object)("Invalid AI conversation TTL value: " + ttl + ", value must be greater than 0, skipping cleanup"));
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                Connection dbCon = this.qmdbModel.getDatabaseConnection();
                try {
                    try (JDBCTransaction txn = new JDBCTransaction(dbCon);){
                        Timestamp maxDataTime = Timestamp.from(Instant.now().minus(Duration.ofDays(ttl)));
                        monitor.subTask("Mark AI conversations for deletion");
                        String deleteStatementQuery = "UPDATE {table_prefix}QM_AI_CONVERSATION SET IS_DELETED = ?\nWHERE LAST_MESSAGE_AT < ? AND IS_DELETED = ?\n";
                        Throwable throwable2 = null;
                        Object var10_15 = null;
                        try (PreparedStatement dbStat = dbCon.prepareStatement(deleteStatementQuery);){
                            dbStat.setString(1, "Y");
                            dbStat.setTimestamp(2, maxDataTime);
                            dbStat.setString(3, "N");
                            dbStat.execute();
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable3) throw throwable2;
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                        txn.commit();
                    }
                    if (dbCon == null) return;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (dbCon == null) throw throwable;
                    dbCon.close();
                    throw throwable;
                }
                dbCon.close();
                return;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                } else {
                    if (throwable == throwable5) throw throwable;
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error cleaning up QM database", (Throwable)e);
        }
    }
}

