/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qm.internal;

import com.dbeaver.ee.qm.QMEventListener;
import com.dbeaver.ee.qm.db.impl.QMDBModel;
import com.dbeaver.ee.qm.db.impl.QMEmbeddedService;
import com.dbeaver.model.DBPApplicationExtended;
import com.dbeaver.model.qm.QMService;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.qm.QMMetaListener;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IPluginService;

public class QMPluginService
implements IPluginService {
    private static final Log log = Log.getLog(QMPluginService.class);
    private static final String QM_SERVICE_TYPE_SYSTEM_PROPERTY = "dbeaver.qm.service.type";
    private static QMService qmService;
    private QMEventListener qmHandler;

    public static QMService getQmService() {
        return qmService;
    }

    public void activateService() {
        if (!this.initQMService()) {
            return;
        }
        if (DBWorkbench.getPlatform().getApplication().isPrimaryInstance()) {
            try {
                this.qmHandler = new QMEventListener(qmService);
                QMUtils.registerMetaListener((QMMetaListener)this.qmHandler);
            }
            catch (DBException e) {
                log.error((Object)"Cannot create qm event listener", (Throwable)e);
            }
        }
    }

    private boolean initQMService() {
        DBPApplication application = DBWorkbench.getPlatform().getApplication();
        qmService = application instanceof DBPApplicationExtended ? ((DBPApplicationExtended)application).getQueryManagerService() : new QMEmbeddedService();
        return true;
    }

    public void deactivateService() {
        if (this.qmHandler != null) {
            this.qmHandler.dispose();
            QMUtils.unregisterMetaListener((QMMetaListener)this.qmHandler);
        }
        QMDBModel.shutdown();
    }
}

