/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qmdb.ui.view;

import com.dbeaver.ee.qmdb.ui.QMDBUIMessages;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.qm.filters.QMDateRange;
import org.jkiss.dbeaver.model.qm.filters.QMEventCriteria;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.querylog.QueryLogViewer;
import org.jkiss.dbeaver.ui.navigator.dialogs.SelectDataSourceDialog;
import org.jkiss.dbeaver.ui.views.qm.QueryManagerViewFilter;

public class QueryManagerViewFilterPanel
implements QueryManagerViewFilter {
    private QueryLogViewer viewer;
    private Button fromDateTimeCheck;
    private DateAndTime fromDateTimeEditor;
    private Button toDateTimeCheck;
    private DateAndTime toDateTimeEditor;
    private Combo dataSourceCombo;
    private Text catalogText;
    private Text schemaText;

    public void createControl(@NotNull Composite parent, @NotNull QueryLogViewer viewer) {
        this.viewer = viewer;
        Composite options = new Composite(parent, 0);
        options.setLayout((Layout)new GridLayout());
        ScrolledComposite viewport = new ScrolledComposite(options, 512);
        viewport.setLayout((Layout)new FillLayout());
        viewport.setLayoutData((Object)new GridData(4, 4, true, true));
        viewport.setBackground(viewport.getDisplay().getSystemColor(37));
        Composite container = new Composite((Composite)viewport, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        this.fromDateTimeCheck = UIUtils.createCheckbox((Composite)container, (String)QMDBUIMessages.view_filter_range_from_label, (boolean)false);
        this.fromDateTimeEditor = new DateAndTime(container);
        this.fromDateTimeEditor.setEditable(false);
        this.fromDateTimeCheck.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.fromDateTimeEditor.setEditable(this.fromDateTimeCheck.getSelection())));
        this.toDateTimeCheck = UIUtils.createCheckbox((Composite)container, (String)QMDBUIMessages.view_filter_range_to_label, (boolean)false);
        this.toDateTimeEditor = new DateAndTime(container);
        this.toDateTimeEditor.setEditable(false);
        this.toDateTimeCheck.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.toDateTimeEditor.setEditable(this.toDateTimeCheck.getSelection())));
        this.dataSourceCombo = UIUtils.createLabelCombo((Composite)container, (String)QMDBUIMessages.view_filter_data_source_label, (int)12);
        this.dataSourceCombo.add(QMDBUIMessages.view_filter_data_source_all_label);
        this.dataSourceCombo.add(QMDBUIMessages.view_filter_data_source_choose_label);
        this.dataSourceCombo.select(0);
        this.dataSourceCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.dataSourceCombo.getData() != null && this.dataSourceCombo.getSelectionIndex() != 0) {
                this.dataSourceCombo.setData(null);
                this.dataSourceCombo.remove(0);
            }
            if (this.dataSourceCombo.getSelectionIndex() == this.dataSourceCombo.getItemCount() - 1) {
                DBPDataSourceContainer dataSource;
                DBPProject project = DBWorkbench.getPlatform().getWorkspace().getActiveProject();
                SelectDataSourceDialog dialog = new SelectDataSourceDialog(this.dataSourceCombo.getShell(), project, null);
                DBPDataSourceContainer dBPDataSourceContainer = dataSource = dialog.open() == 0 ? dialog.getDataSource() : null;
                if (dataSource != null) {
                    this.dataSourceCombo.add(dataSource.getName(), 0);
                    this.dataSourceCombo.setData((Object)dataSource);
                }
            }
            this.dataSourceCombo.select(0);
        }));
        this.catalogText = UIUtils.createLabelText((Composite)container, (String)QMDBUIMessages.view_filter_catalog_label, null);
        this.catalogText.setMessage("catalog1,catalog2");
        this.schemaText = UIUtils.createLabelText((Composite)container, (String)QMDBUIMessages.view_filter_schema_label, null);
        this.schemaText.setMessage("schema1,schema2");
        UIUtils.configureScrolledComposite((ScrolledComposite)viewport, (Control)container);
        Composite buttons = new Composite(options, 0);
        buttons.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        buttons.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000008, 0x1000008).grab(true, false).create());
        UIUtils.createDialogButton((Composite)buttons, (String)QMDBUIMessages.view_filter_button_reset_label, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> this.reset()));
        UIUtils.createDialogButton((Composite)buttons, (String)QMDBUIMessages.view_filter_button_apply_label, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> this.apply()));
    }

    private void reset() {
        LocalDateTime input = LocalDateTime.now();
        this.fromDateTimeCheck.setSelection(false);
        this.fromDateTimeCheck.notifyListeners(13, new Event());
        this.fromDateTimeEditor.setInput(input);
        this.toDateTimeCheck.setSelection(false);
        this.toDateTimeCheck.notifyListeners(13, new Event());
        this.toDateTimeEditor.setInput(input);
        if (this.dataSourceCombo.getData() != null) {
            this.dataSourceCombo.setData(null);
            this.dataSourceCombo.remove(0);
            this.dataSourceCombo.select(0);
        }
        this.catalogText.setText("");
        this.schemaText.setText("");
        this.viewer.setCriteria(null);
        this.viewer.refresh();
    }

    private void apply() {
        LocalDateTime fromDateTime = this.fromDateTimeCheck.getSelection() ? this.fromDateTimeEditor.toLocalDateTime() : null;
        LocalDateTime toDateTime = this.toDateTimeCheck.getSelection() ? this.toDateTimeEditor.toLocalDateTime() : null;
        Set dataSourceIds = this.dataSourceCombo.getData() != null ? Set.of(((DBPDataSourceContainer)this.dataSourceCombo.getData()).getId()) : Set.of();
        Set catalogs = !this.catalogText.getText().isBlank() ? Arrays.stream(this.catalogText.getText().split(",")).map(String::trim).collect(Collectors.toSet()) : Set.of();
        Set schemas = !this.schemaText.getText().isBlank() ? Arrays.stream(this.schemaText.getText().split(",")).map(String::trim).collect(Collectors.toSet()) : Set.of();
        QMEventCriteria criteria = QMUtils.createDefaultCriteria((DBPPreferenceStore)DBWorkbench.getPlatform().getPreferenceStore());
        criteria.setDateRange((QMDateRange)(fromDateTime != null || toDateTime != null ? new QMDateRange(fromDateTime, toDateTime) : null));
        criteria.setDataSourceIds(dataSourceIds);
        criteria.setCatalogs(catalogs);
        criteria.setSchemas(schemas);
        this.viewer.setCriteria(criteria);
        this.viewer.refresh();
    }

    private static class DateAndTime
    extends Composite {
        private final DateTime date;
        private final DateTime time;

        DateAndTime(@NotNull Composite parent) {
            super(parent, 0);
            this.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).create());
            this.setLayoutData(new GridData(4, 1, true, false));
            this.date = new DateTime((Composite)this, 36);
            this.date.setLayoutData((Object)new GridData(4, 1, true, false));
            this.time = new DateTime((Composite)this, 65664);
            this.time.setLayoutData((Object)new GridData(4, 1, true, false));
        }

        void setEditable(boolean enabled) {
            this.date.setEnabled(enabled);
            this.time.setEnabled(enabled);
        }

        void setInput(@NotNull LocalDateTime input) {
            this.date.setDate(input.getYear(), input.getMonthValue() - 1, input.getDayOfMonth());
            this.time.setTime(input.getHour(), input.getMinute(), input.getSecond());
        }

        @NotNull
        LocalDateTime toLocalDateTime() {
            return LocalDateTime.of(LocalDate.of(this.date.getYear(), this.date.getMonth() + 1, this.date.getDay()), LocalTime.of(this.time.getHours(), this.time.getMinutes(), this.time.getSeconds()));
        }
    }
}

