/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.impl.liquibase;

import com.dbeaver.ee.scmp.model.CMPOptions;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class LBLogFileManager {
    Path generateLogReport(DBRProgressMonitor monitor, CMPOptions options, String changeLog) throws IOException {
        monitor.beginTask("Generate log report", 5);
        monitor.subTask("Prepare log report file");
        Path logFile = this.createLogFile(monitor, options);
        monitor.subTask("Generate log report");
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (OutputStream stream = Files.newOutputStream(logFile, new OpenOption[0]);){
                OutputStreamWriter writer = new OutputStreamWriter(stream, GeneralUtils.getDefaultFileEncoding());
                if (CommonUtils.isNotEmpty((String)changeLog)) {
                    writer.write(changeLog);
                } else {
                    writer.write("Log report file is empty. You can change the logging level in the preferences (Preferences -> Editors -> Schema Compare).");
                }
                ((Writer)writer).flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            monitor.done();
        }
        return logFile;
    }

    private Path createLogFile(DBRProgressMonitor monitor, CMPOptions options) throws IOException {
        Path tempFolder = DBWorkbench.getPlatform().getTempFolder(monitor, "scmp-diff-reports");
        return tempFolder.resolve("log-report-" + options.getLogLevel().name().toLowerCase(Locale.ENGLISH) + "-" + new SimpleDateFormat("yyyyMMddHHmmss").format(System.currentTimeMillis()) + ".log");
    }
}

