/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.csv;

import com.dbeaver.jdbc.files.FFFileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.csv.CSVReader;

public class CsvCustomReader
implements FFFileReader<Object> {
    private final CSVReader csvReader;
    private final boolean trimWhitespaces;
    private final AtomicBoolean tableOpened = new AtomicBoolean(false);

    public CsvCustomReader(@NotNull CSVReader csvReader, boolean trimWhitespaces) {
        this.csvReader = csvReader;
        this.trimWhitespaces = trimWhitespaces;
    }

    public boolean openNextTable() throws IOException {
        return this.tableOpened.compareAndSet(false, true);
    }

    @Nullable
    public String getCurrentTable() {
        return null;
    }

    @Nullable
    public String[] readRow() throws IOException {
        String[] nextRow = this.csvReader.readNext();
        if (nextRow == null) {
            return null;
        }
        return (String[])Arrays.stream(nextRow).map(this::transformValue).toArray(String[]::new);
    }

    private String transformValue(String value) {
        if (value == null) {
            return null;
        }
        return this.trimWhitespaces ? value.trim() : value;
    }

    public void close() throws IOException {
        this.csvReader.close();
    }
}

