/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.multi;

import com.dbeaver.jdbc.files.FFDataSourceScanner;
import com.dbeaver.jdbc.files.FFDataSourceVisitor;
import com.dbeaver.jdbc.files.FFFileScanner;
import com.dbeaver.jdbc.files.FFResult;
import com.dbeaver.jdbc.files.api.FFDataSource;
import com.dbeaver.jdbc.files.api.FFDataSourceFormat;
import com.dbeaver.jdbc.files.database.FFTable;
import com.dbeaver.jdbc.files.database.FFTableProperties;
import com.dbeaver.jdbc.files.multi.MultiSourceProperties;
import com.dbeaver.jdbc.files.utils.FFIOUtils;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.utils.Pair;

public class MultiSourceDataSourceScanner
implements FFDataSourceScanner<Object, FFTableProperties, MultiSourceProperties> {
    @NotNull
    private final Map<FFDataSourceFormat, FFFileScanner<Object, FFTableProperties>> dataFormatScanner = new HashMap<FFDataSourceFormat, FFFileScanner<Object, FFTableProperties>>();
    @NotNull
    private final List<Pair<PathMatcher, FFFileScanner<Object, FFTableProperties>>> pathMatcherScanner = new ArrayList<Pair<PathMatcher, FFFileScanner<Object, FFTableProperties>>>();

    public void addScanner(@NotNull FFDataSourceFormat format, @NotNull PathMatcher pathMatcher, @NotNull FFFileScanner<Object, FFTableProperties> scanner) {
        this.dataFormatScanner.put(format, scanner);
        this.pathMatcherScanner.add((Pair<PathMatcher, FFFileScanner<Object, FFTableProperties>>)new Pair((Object)pathMatcher, scanner));
    }

    @NotNull
    public FFResult<List<FFTable<Object, FFTableProperties>>, Exception> scan(@NotNull FFDataSource<MultiSourceProperties> dataSource) {
        int maxDepth = ((MultiSourceProperties)dataSource.properties()).scanSubfolders() ? Integer.MAX_VALUE : 1;
        try {
            return this.scan0(dataSource, maxDepth);
        }
        catch (Exception e) {
            return new FFResult(List.of(), List.of(e));
        }
    }

    private FFResult<List<FFTable<Object, FFTableProperties>>, Exception> scan0(@NotNull FFDataSource<MultiSourceProperties> dataSource, int maxDepth) throws IOException {
        FFDataSourceFormat dataFormat = ((MultiSourceProperties)dataSource.properties()).dataFormat();
        Path start = dataSource.path();
        FFDataSourceVisitor visitor = new FFDataSourceVisitor(file -> {
            if (dataFormat != null) {
                return this.dataFormatScanner.get(dataFormat).scan(dataSource, file);
            }
            Path relativisedPath = FFIOUtils.relativePathOrFileName((Path)start, (Path)file);
            for (Pair<PathMatcher, FFFileScanner<Object, FFTableProperties>> pair : this.pathMatcherScanner) {
                if (!((PathMatcher)pair.getFirst()).matches(relativisedPath)) continue;
                return ((FFFileScanner)pair.getSecond()).scan(dataSource, file);
            }
            return List.of();
        });
        Files.walkFileTree(start, EnumSet.noneOf(FileVisitOption.class), maxDepth, (FileVisitor<? super Path>)visitor);
        return visitor.result();
    }
}

