/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.xlsx;

import com.dbeaver.jdbc.base.ColumnInfo;
import com.dbeaver.jdbc.files.FFDataFileMetadataReader;
import com.dbeaver.jdbc.files.database.FFSQLType;
import com.dbeaver.jdbc.files.database.FFSchemaName;
import com.dbeaver.jdbc.files.database.FFTableName;
import com.dbeaver.jdbc.files.database.FFTableProperties;
import com.dbeaver.jdbc.files.database.FFTableStructure;
import com.dbeaver.jdbc.files.utils.FFDataTypeUtils;
import com.dbeaver.jdbc.files.utils.FFMetadataUtils;
import com.dbeaver.jdbc.files.xlsx.XlsxCell;
import com.dbeaver.jdbc.files.xlsx.XlsxProperties;
import com.dbeaver.jdbc.files.xlsx.XlsxReader;
import com.dbeaver.jdbc.files.xlsx.XlsxReaderFactory;
import com.dbeaver.jdbc.files.xlsx.XlsxTableProperties;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.SQLType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;

class XlsxMetadataReader
implements FFDataFileMetadataReader<Object, XlsxTableProperties> {
    @NotNull
    private final XlsxProperties properties;
    @NotNull
    private final XlsxReaderFactory readerFactory;

    XlsxMetadataReader(@NotNull XlsxProperties properties, @NotNull XlsxReaderFactory readerFactory) {
        this.properties = properties;
        this.readerFactory = readerFactory;
    }

    @NotNull
    public FFTableStructure<Object, XlsxTableProperties> getTableStructure(@NotNull FFSchemaName schemaName, @NotNull Path dataPath, @NotNull String tableSourceName) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (XlsxReader reader = this.readerFactory.createReader(dataPath, this.properties);){
            while (reader.openNextTable()) {
                if (!tableSourceName.equals(reader.getCurrentTable())) continue;
                return this.readMetadata0(new FFTableName(schemaName, tableSourceName), reader);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throw new IOException("Sheet not found: " + tableSourceName);
    }

    @NotNull
    public List<String> getTableSourceNames(@NotNull Path dataPath) throws IOException {
        ArrayList<String> tableNames = new ArrayList<String>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (XlsxReader reader = this.readerFactory.createReader(dataPath, this.properties);){
            while (reader.openNextTable()) {
                tableNames.add(reader.getCurrentTable());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return tableNames;
    }

    private FFTableStructure<Object, XlsxTableProperties> readMetadata0(FFTableName tableQualifier, XlsxReader reader) throws IOException {
        String[] header;
        XlsxCell[] firstRow = reader.readRow();
        if (firstRow == null) {
            return new FFTableStructure(List.of(), (FFTableProperties)XlsxTableProperties.EMPTY);
        }
        ArrayList<XlsxCell[]> sampleRows = new ArrayList<XlsxCell[]>();
        if (this.properties.header()) {
            header = FFMetadataUtils.normalizeColumnNames((String[])((String[])Arrays.stream(firstRow).map(cell -> cell == null ? "" : String.valueOf(cell.getCellValue())).toArray(String[]::new)));
        } else {
            header = FFMetadataUtils.generateColumnNames((int)firstRow.length);
            sampleRows.add(firstRow);
        }
        int i = sampleRows.size();
        while (i < this.properties.sampleRows()) {
            XlsxCell[] row = reader.readRow();
            if (row == null) break;
            sampleRows.add(row);
            ++i;
        }
        SQLType[] dataTypes = this.inferDataTypes(sampleRows, header.length);
        ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>(header.length);
        int i2 = 0;
        while (i2 < header.length) {
            columns.add(i2, new ColumnInfo(tableQualifier.schema().name(), tableQualifier.name(), header[i2], header[i2], (SQLType)(dataTypes[i2] == null ? FFSQLType.VARCHAR : dataTypes[i2]), value -> value));
            ++i2;
        }
        return new FFTableStructure(columns, (FFTableProperties)XlsxTableProperties.EMPTY);
    }

    private SQLType[] inferDataTypes(List<XlsxCell[]> sampleRows, int columnCount) {
        SQLType[] dataTypes = new SQLType[columnCount];
        for (XlsxCell[] row : sampleRows) {
            SQLType[] defineDataTypes = this.defineDataTypes(row);
            int j = 0;
            while (j < columnCount) {
                dataTypes[j] = j >= defineDataTypes.length ? FFSQLType.VARCHAR : (dataTypes[j] == null ? defineDataTypes[j] : FFDataTypeUtils.determineCommonDataType((SQLType)dataTypes[j], (SQLType)defineDataTypes[j]));
                ++j;
            }
        }
        return dataTypes;
    }

    @NotNull
    private SQLType[] defineDataTypes(@NotNull XlsxCell[] row) {
        return (SQLType[])Stream.of(row).map(XlsxCell::getJdbcType).toArray(SQLType[]::new);
    }
}

