/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.xlsx;

import com.dbeaver.jdbc.files.FFTableNameFactory;
import com.dbeaver.jdbc.files.GenericTableNameFactory;
import com.dbeaver.jdbc.files.api.FFDataSource;
import com.dbeaver.jdbc.files.database.FFSchemaName;
import com.dbeaver.jdbc.files.database.FFTableName;
import com.dbeaver.jdbc.files.utils.FFIOUtils;
import com.dbeaver.jdbc.files.xlsx.XlsxProperties;
import java.nio.file.Path;
import java.util.List;
import org.jkiss.code.NotNull;

public class XlsxTableNameFactory
implements FFTableNameFactory {
    @NotNull
    private final FFDataSource<XlsxProperties> dataSource;
    @NotNull
    private final GenericTableNameFactory tableNameFactory;

    public XlsxTableNameFactory(@NotNull FFDataSource<XlsxProperties> dataSource, @NotNull GenericTableNameFactory tableNameFactory) {
        this.dataSource = dataSource;
        this.tableNameFactory = tableNameFactory;
    }

    @NotNull
    public List<FFTableName> createTableNames(@NotNull Path file, @NotNull List<String> tableSourceNames) {
        XlsxProperties properties = (XlsxProperties)this.dataSource.properties();
        switch (properties.schemaNameMode()) {
            case RELATIVE_DIR_PATH: {
                String fileName = FFIOUtils.truncateFileExtension((Path)file);
                List<String> adjustedNames = tableSourceNames.stream().map(tableName -> fileName + "_" + tableName).toList();
                return this.tableNameFactory.createTableNames(file, adjustedNames);
            }
            case RELATIVE_FILE_PATH: {
                Path relativized = FFIOUtils.relativePathOrFileName((Path)this.dataSource.path(), (Path)file);
                String concatenated = FFIOUtils.concat((Path)relativized, (String)properties.subfolderNameSeparator());
                FFSchemaName schemaName = new FFSchemaName(concatenated.substring(0, concatenated.lastIndexOf(".")));
                return tableSourceNames.stream().map(it -> new FFTableName(schemaName, it)).toList();
            }
        }
        throw new IllegalArgumentException("Unknown table name mode: " + String.valueOf((Object)properties.schemaNameMode()));
    }
}

