/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.xml;

import com.dbeaver.jdbc.files.FFFileReaderFactory;
import com.dbeaver.jdbc.files.xml.XmlProperties;
import com.dbeaver.jdbc.files.xml.XmlReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jkiss.code.NotNull;

public class XmlFileReaderFactory
implements FFFileReaderFactory<XmlReader, XmlProperties> {
    @NotNull
    public XmlReader createReader(@NotNull Path path, @NotNull XmlProperties properties) throws IOException {
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            XMLStreamReader streamReader = inputFactory.createXMLStreamReader(Files.newBufferedReader(path));
            return new XmlReader(streamReader);
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to parse XML file", e);
        }
    }
}

