/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.odbc;

import com.dbeaver.jdbc.base.BaseJdbcDriver;
import com.dbeaver.jdbc.odbc.JdbcOdbcConnection;
import com.dbeaver.jdbc.odbc.OdbcException;
import com.dbeaver.jdbc.odbc.bridge.OdbcHandle;
import com.dbeaver.jdbc.odbc.bridge.OdbcLibrary;
import com.dbeaver.jdbc.odbc.bridge.OdbcResource;
import com.dbeaver.jdbc.odbc.bridge.util.OdbcUtil;
import com.sun.jna.Pointer;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jkiss.code.NotNull;

public class JdbcOdbcBridgeDriver
extends BaseJdbcDriver {
    public static final String DRIVER_NAME = "DBeaver JDBC-ODBC Bridge";
    public static final String DRIVER_PREFIX = "jdbc:dbodbc:";
    public static final int DRIVER_VERSION_MAJOR = 1;
    public static final int DRIVER_VERSION_MINOR = 2;
    private static final State state = new State();

    static {
        try {
            DriverManager.registerDriver((Driver)((Object)new JdbcOdbcBridgeDriver()));
        }
        catch (SQLException e) {
            throw new RuntimeException("Error registering driver", e);
        }
    }

    public JdbcOdbcBridgeDriver() {
        super(DRIVER_PREFIX, 1, 2);
    }

    public String getDriverIdentifier() {
        return "jdbc-odbc-bridge";
    }

    static State getDriverState() {
        return state;
    }

    public Connection connectImpl(String url, Properties info) throws SQLException {
        Properties properties = (Properties)info.clone();
        JdbcOdbcBridgeDriver.replaceProperty(properties, "user", "UID");
        JdbcOdbcBridgeDriver.replaceProperty(properties, "password", "PWD");
        return state.connect(url, properties);
    }

    public static void disconnect(@NotNull JdbcOdbcConnection connection) throws SQLException {
        state.disconnect(connection);
    }

    @NotNull
    private static String formatURL(@NotNull String url, @NotNull Properties props) {
        StringBuilder sb = new StringBuilder();
        sb.append(url, DRIVER_PREFIX.length(), url.length());
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) != ';') {
            sb.append(';');
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            sb.append(entry.getKey()).append('=').append(entry.getValue()).append(';');
        }
        return sb.toString();
    }

    private static void replaceProperty(@NotNull Properties properties, @NotNull String src, @NotNull String dst) {
        properties.entrySet().removeIf(entry -> {
            if (entry.getKey() instanceof String && ((String)entry.getKey()).equalsIgnoreCase(src)) {
                properties.put(dst, entry.getValue());
                return true;
            }
            return false;
        });
    }

    static class State
    extends OdbcResource<OdbcHandle.Environment> {
        private final Set<JdbcOdbcConnection> connections = new HashSet<JdbcOdbcConnection>();

        private State() {
            super(null, OdbcHandle.Environment.nullHandle());
        }

        @NotNull
        public synchronized Connection connect(@NotNull String url, @NotNull Properties info) throws SQLException {
            this.getHandleAndOpenIfRequired();
            JdbcOdbcConnection connection = new JdbcOdbcConnection(this, JdbcOdbcBridgeDriver.formatURL(url, info));
            this.connections.add(connection);
            return connection;
        }

        public synchronized void disconnect(@NotNull JdbcOdbcConnection connection) throws SQLException {
            if (!this.connections.remove((Object)connection)) {
                throw new OdbcException("Connection is already closed");
            }
            if (this.connections.isEmpty()) {
                ((OdbcHandle.Environment)this.handle).close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        OdbcHandle.Environment getHandleAndOpenIfRequired() throws SQLException {
            if (((OdbcHandle.Environment)this.handle).isClosed()) {
                State state = this;
                synchronized (state) {
                    if (((OdbcHandle.Environment)this.handle).isClosed()) {
                        ((OdbcHandle.Environment)this.handle).open(null);
                        this.init();
                    }
                }
            }
            return (OdbcHandle.Environment)this.handle;
        }

        private void init() throws SQLException {
            OdbcUtil.check(OdbcLibrary.INSTANCE.SQLSetEnvAttr((OdbcHandle.Environment)this.handle, 200, Pointer.createConstant((int)3), 0), this.handle);
        }
    }
}

