/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.salesforce;

import com.dbeaver.jdbc.base.ColumnInfo;
import com.dbeaver.jdbc.model.AbstractJdbcConnection;
import com.dbeaver.jdbc.model.AbstractJdbcStatement;
import com.dbeaver.jdbc.salesforce.SalesForceConnection;
import com.dbeaver.jdbc.salesforce.SalesForceConstants;
import com.dbeaver.jdbc.salesforce.SalesForceResultSet;
import com.dbeaver.jdbc.salesforce.SalesForceResultSetMetaData;
import com.dbeaver.jdbc.salesforce.SalesForceUtils;
import com.dbeaver.jdbc.salesforce.meta.ObjectArrayFieldInfo;
import com.dbeaver.jdbc.salesforce.meta.ObjectElementInfo;
import com.dbeaver.jdbc.salesforce.meta.ObjectRecordExpressionInfo;
import com.dbeaver.jdbc.salesforce.meta.ObjectRecordFieldInfo;
import com.dbeaver.jdbc.salesforce.meta.ObjectRelationInfo;
import com.sforce.soap.partner.FieldType;
import com.sforce.soap.partner.IDescribeSObjectResult;
import com.sforce.soap.partner.IField;
import com.sforce.soap.partner.IQueryResult;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.sobject.ISObject;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.bind.XmlObject;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.IntKeyMap;
import org.jkiss.utils.Pair;

public class SalesForceQueryStatement
extends AbstractJdbcStatement<SalesForceConnection>
implements PreparedStatement {
    private static final Logger log = Logger.getLogger(SalesForceQueryStatement.class.getName());
    private static final Pattern TABLE_NAME_PATTERN = Pattern.compile("\\s+FROM\\s+(\\w+)", 2);
    private static final Pattern COLUMN_NAME_PATTERN = Pattern.compile("SELECT\\s+([\\w\\s,()]+)\\s+FROM", 2);
    private String queryText;
    private IQueryResult queryResult;
    private SalesForceResultSet<ISObject> resultSet;
    private IntKeyMap<Object> indexedParams;
    private Map<String, Object> namedParams;

    public SalesForceQueryStatement(@NotNull SalesForceConnection connection, @NotNull String sql) throws SQLException {
        this(connection);
        this.queryText = sql;
    }

    public SalesForceQueryStatement(@NotNull SalesForceConnection connection) throws SQLException {
        super((AbstractJdbcConnection)connection);
    }

    @Override
    public int getMaxRows() {
        return Math.min((int)this.maxRows, 2000);
    }

    @Override
    public boolean execute() throws SQLException {
        if (this.queryText == null) {
            throw new SQLException("Null query text");
        }
        String soqlText = this.injectParameters(this.queryText);
        try {
            PartnerConnection pc = ((SalesForceConnection)this.connection).getPartnerConnection();
            if (this.getMaxRows() > 0) {
                pc.setQueryOptions(this.getMaxRows());
            }
            try {
                this.queryResult = pc.query(soqlText);
            }
            finally {
                pc.clearQueryOptions();
            }
            Object[] records = this.queryResult.getRecords();
            List<ColumnInfo<ISObject>> columns = !ArrayUtils.isEmpty((Object[])records) ? this.buildColumnsFromRecords((ISObject[])records) : this.buildColumnsFromQuery(soqlText);
            SalesForceResultSetMetaData meta = new SalesForceResultSetMetaData(this, columns.toArray(new ColumnInfo[0]));
            this.resultSet = new SalesForceResultSet<Object>(this, meta, records);
        }
        catch (ConnectionException e) {
            throw new SQLException(e);
        }
        return true;
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        if (this.indexedParams == null) {
            this.indexedParams = new IntKeyMap();
        }
        this.indexedParams.put(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.setObject(parameterIndex, (Object)x, 12, 0);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setObject(parameterIndex, (Object)x, 4, 0);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setObject(parameterIndex, (Object)x, 4, 0);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setObject(parameterIndex, (Object)x, 4, 0);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setObject(parameterIndex, (Object)x, 91, 0);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setObject(parameterIndex, (Object)x, 92, 0);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setObject(parameterIndex, (Object)x, 93, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void extractStructAttributes(ISObject record, ObjectElementInfo attr, List<ObjectElementInfo> nestedAttrs) throws SQLException, ConnectionException {
        Object value = record.getSObjectField(attr.getName());
        if (!(value instanceof SObject)) return;
        SObject object = (SObject)value;
        Object records = object.getSObjectField("records");
        if (SalesForceUtils.isShowFlatStructures((SalesForceConnection)this.getConnection())) {
            if (!(records instanceof SObject)) throw new SQLException("Records is not SObject: " + String.valueOf(records));
            this.createFlatStructAttributes(attr, (SObject)records, nestedAttrs);
            return;
        } else {
            this.createStructArrayAttribute(attr, object, nestedAttrs);
        }
    }

    private void createStructArrayAttribute(ObjectElementInfo attr, SObject object, List<ObjectElementInfo> nestedAttrs) throws SQLException, ConnectionException {
        IDescribeSObjectResult tableInfo = attr.getReferencedTable((SalesForceConnection)this.connection);
        if (tableInfo == null) {
            return;
        }
        if (!(attr instanceof ObjectRelationInfo)) {
            throw new SQLException("Invalid owner element type: " + String.valueOf(attr));
        }
        ObjectArrayFieldInfo element = new ObjectArrayFieldInfo(tableInfo, (ObjectRelationInfo)attr);
        nestedAttrs.add(element);
    }

    private void createFlatStructAttributes(ObjectElementInfo attr, SObject object, List<ObjectElementInfo> nestedAttrs) throws ConnectionException, SQLException {
        Iterator fi = object.getChildren();
        while (fi.hasNext()) {
            XmlObject fieldXml = (XmlObject)fi.next();
            String fieldName = fieldXml.getName().getLocalPart();
            if (SalesForceUtils.isSystemField((ISObject)object, fieldName)) continue;
            String attrName = attr.getName() + "." + fieldName;
            IDescribeSObjectResult tableInfo = attr.getReferencedTable((SalesForceConnection)this.connection);
            if (tableInfo == null) continue;
            IField field = SalesForceUtils.findField(tableInfo, fieldName);
            if (field == null) {
                log.warning("Field '" + fieldName + "' not found in table '" + tableInfo.getName() + "'");
                continue;
            }
            ObjectRecordFieldInfo element = new ObjectRecordFieldInfo(tableInfo, field, attrName);
            nestedAttrs.add(element);
        }
    }

    protected boolean execute(@NotNull String sql, @Nullable int[] columnIndexes, @Nullable String[] columnNames, int autoGeneratedKeys) throws SQLException {
        this.queryText = sql;
        return this.execute();
    }

    protected int executeUpdate(@NotNull String sql, @Nullable int[] columnIndexes, @Nullable String[] columnNames, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.execute(sql, null, null, 2);
        return this.getResultSet();
    }

    @Override
    public void close() throws SQLException {
        this.indexedParams = null;
        this.namedParams = null;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Nullable
    public IQueryResult getQueryResult() {
        return this.queryResult;
    }

    public void setQueryResult(@Nullable IQueryResult queryResult) {
        this.queryResult = queryResult;
    }

    @NotNull
    private String injectParameters(@NotNull String soqlText) throws SQLException {
        if (this.indexedParams == null || this.indexedParams.isEmpty()) {
            return soqlText;
        }
        int i = 0;
        while (i < this.indexedParams.size()) {
            int paramIndex = i + 1;
            if (!this.indexedParams.containsKey(paramIndex)) {
                throw new SQLException("Parameter " + paramIndex + " is not bound");
            }
            Object value = this.indexedParams.get(paramIndex);
            Object strValue = value instanceof String || value instanceof java.util.Date ? "'" + String.valueOf(value) + "'" : value.toString();
            soqlText = soqlText.replaceFirst("\\?", Matcher.quoteReplacement((String)strValue));
            ++i;
        }
        return soqlText;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private List<ColumnInfo<ISObject>> buildColumnsFromRecords(@NotNull ISObject[] records) throws SQLException, ConnectionException {
        void var4_7;
        LinkedHashMap<String, ObjectElementInfo> fields = new LinkedHashMap<String, ObjectElementInfo>();
        ISObject[] iSObjectArray = records;
        int n = records.length;
        boolean n2 = false;
        while (var4_7 < n) {
            ISObject row = iSObjectArray[var4_7];
            this.collectColumns((XmlObject)row, fields, (SalesForceConnection)this.connection);
            if (fields.entrySet().stream().noneMatch(f -> f.getValue() == null)) break;
            ++var4_7;
        }
        ArrayList<ColumnInfo<ISObject>> columns = new ArrayList<ColumnInfo<ISObject>>();
        for (Map.Entry<String, ObjectElementInfo> entry : fields.entrySet()) {
            ObjectElementInfo info = this.getObjectElementInfo(entry);
            columns.add((ColumnInfo<ISObject>)new ColumnInfo(info.getObjectName(), entry.getKey(), entry.getKey(), SalesForceUtils.getFieldDataType(info.getDataType()), info.getDataType() == null ? null : info.getDataType().toString(), o -> SalesForceUtils.readFieldValue((SalesForceConnection)this.getConnection(), o, info, (String)rf.getKey())));
        }
        return columns;
    }

    @NotNull
    private ObjectElementInfo getObjectElementInfo(@NotNull Map.Entry<String, ObjectElementInfo> rowField) {
        if (rowField.getValue() == null) {
            return new ObjectRecordExpressionInfo(rowField.getKey(), null){

                @Override
                public FieldType getDataType() {
                    return null;
                }
            };
        }
        return rowField.getValue();
    }

    @NotNull
    private List<ColumnInfo<ISObject>> buildColumnsFromQuery(@NotNull String soql) throws SQLException, ConnectionException {
        Matcher tableMatcher = TABLE_NAME_PATTERN.matcher(soql);
        Matcher columnMatcher = COLUMN_NAME_PATTERN.matcher(soql);
        ArrayList<String> tableNames = new ArrayList<String>();
        while (tableMatcher.find()) {
            tableNames.add(tableMatcher.group(1));
        }
        if (tableNames.isEmpty()) {
            throw new SQLException("Cannot determine object name");
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        if (columnMatcher.find()) {
            String[] parts;
            String[] stringArray = parts = columnMatcher.group(1).split(",");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                fieldNames.add(part.trim());
                ++n2;
            }
        }
        ArrayList<ObjectElementInfo> allFields = new ArrayList<ObjectElementInfo>();
        for (String table : tableNames) {
            allFields.addAll(((SalesForceConnection)this.connection).getMetaData().getObjectFields(table));
        }
        if (!fieldNames.isEmpty()) {
            allFields.removeIf(f -> !fieldNames.contains(f.getName()));
        }
        for (String name : fieldNames) {
            if (!allFields.stream().noneMatch(f -> f.getName().equals(name))) continue;
            allFields.add(new ObjectRecordExpressionInfo(name, null));
        }
        ArrayList<ColumnInfo<ISObject>> result = new ArrayList<ColumnInfo<ISObject>>();
        for (ObjectElementInfo field : allFields) {
            result.add((ColumnInfo<ISObject>)new ColumnInfo(field.getReferenceTableName(), field.getName(), field.getName(), SalesForceUtils.getFieldDataType(field.getDataType()), field.getDataType().toString(), o -> SalesForceUtils.readFieldValue((SalesForceConnection)this.getConnection(), o, field, field.getName())));
        }
        return result;
    }

    private void collectColumns(@NotNull XmlObject row, @NotNull Map<String, ObjectElementInfo> columns, @NotNull SalesForceConnection connection) throws SQLException, ConnectionException {
        ArrayDeque<Pair<XmlObject, List<String>>> stack = new ArrayDeque<Pair<XmlObject, List<String>>>();
        stack.push(Pair.of((Object)row, new ArrayList()));
        while (!stack.isEmpty()) {
            Pair current = (Pair)stack.pop();
            SalesForceQueryStatement.processNode(columns, connection, (XmlObject)current.getFirst(), (List)current.getSecond(), stack);
        }
    }

    private static void processNode(@NotNull Map<String, ObjectElementInfo> columns, @NotNull SalesForceConnection connection, @NotNull XmlObject node, @NotNull List<String> path, @NotNull Deque<Pair<XmlObject, List<String>>> stack) throws ConnectionException, SQLException {
        String tableName = null;
        Iterator it = node.getChildren();
        while (it.hasNext()) {
            XmlObject child = (XmlObject)it.next();
            String key = child.getName().getLocalPart();
            if ("type".equals(key)) {
                tableName = Optional.ofNullable(child.getValue()).map(Object::toString).orElse(null);
                continue;
            }
            if ("Id".equals(key) && child.getValue() == null || SalesForceConstants.SYSTEM_FILD_NAMES.contains(key)) continue;
            ArrayList<String> newPath = new ArrayList<String>(path);
            newPath.add(key);
            String fieldPath = String.join((CharSequence)".", newPath);
            if (child.hasChildren() && child.getValue() == null) {
                XmlObject records = child.getChild("records");
                if (records == null) {
                    columns.remove(fieldPath);
                    stack.push((Pair<XmlObject, List<String>>)Pair.of((Object)child, newPath));
                    continue;
                }
                XmlObject type = records.getChild("type");
                columns.put(fieldPath, new ObjectArrayFieldInfo(connection.getMetaData().getTableInfo(type.getValue().toString()), null));
                continue;
            }
            SalesForceQueryStatement.updateColumnInfo(columns, connection, tableName, child, key, fieldPath);
        }
    }

    private static void updateColumnInfo(@NotNull Map<String, ObjectElementInfo> columns, @NotNull SalesForceConnection connection, String tableName, @NotNull XmlObject child, @NotNull String key, @NotNull String fieldPath) throws ConnectionException, SQLException {
        if (child.getValue() != null) {
            ObjectElementInfo field = columns.get(fieldPath);
            if (field == null) {
                ObjectElementInfo info = null;
                if (tableName != null) {
                    if ("AggregateResult".equals(tableName)) {
                        info = new ObjectRecordExpressionInfo(fieldPath, child.getValue());
                    } else {
                        List<ObjectElementInfo> fields = connection.getMetaData().getObjectFields(tableName);
                        info = fields.stream().filter(i -> i.getName().equals(key)).findAny().orElse(null);
                    }
                }
                columns.put(fieldPath, info);
            }
        } else {
            columns.putIfAbsent(fieldPath, null);
        }
    }
}

