/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.salesforce.meta;

import com.dbeaver.jdbc.salesforce.SalesForceConstants;
import com.dbeaver.jdbc.salesforce.SalesForceUtils;
import com.sforce.soap.partner.FieldType;
import com.sforce.soap.partner.IDescribeSObjectResult;
import com.sforce.soap.partner.sobject.ISObject;
import com.sforce.ws.bind.XmlObject;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Struct;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.utils.Pair;

public class SFArray
implements Array {
    private final IDescribeSObjectResult tableInfo;
    private final Object[] arrayItems;

    public SFArray(IDescribeSObjectResult tableInfo, XmlObject object) {
        this.tableInfo = tableInfo;
        ArrayList items = new ArrayList();
        Iterator recordIter = object.getChildren("records");
        while (recordIter.hasNext()) {
            XmlObject rd = (XmlObject)recordIter.next();
            LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
            Iterator children = rd.getChildren();
            while (children.hasNext()) {
                XmlObject child = (XmlObject)children.next();
                String name = child.getName().getLocalPart();
                if (SalesForceUtils.isSystemField((ISObject)rd, name)) continue;
                Object value = child.getValue();
                if (child.hasChildren() && value == null) {
                    attributes.putAll(this.fetchValue(child, name));
                    continue;
                }
                attributes.put(name, value);
            }
            items.add(attributes);
        }
        this.arrayItems = items.toArray();
    }

    private Map<String, Object> fetchValue(XmlObject root, String rootPath) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        ArrayDeque<Pair> stack = new ArrayDeque<Pair>();
        stack.push(Pair.of((Object)root, (Object)rootPath));
        while (!stack.isEmpty()) {
            Pair pair = (Pair)stack.pop();
            XmlObject node = (XmlObject)pair.getFirst();
            String path = (String)pair.getSecond();
            node.getChildren().forEachRemaining(child -> {
                String key = child.getName().getLocalPart();
                if ("type".equals(key) || SalesForceConstants.SYSTEM_FILD_NAMES.contains(key) || "Id".equals(key) && child.getValue() == null) {
                    return;
                }
                String fullPath = path + "." + key;
                Object value = child.getValue();
                if (value != null || !child.hasChildren()) {
                    values.put(fullPath, value);
                } else {
                    stack.push(Pair.of((Object)child, (Object)fullPath));
                }
            });
        }
        return values;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.tableInfo.getName();
    }

    @Override
    public int getBaseType() throws SQLException {
        return 2002;
    }

    @Override
    public Object getArray() throws SQLException {
        return this.arrayItems;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        return this.arrayItems;
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        return Arrays.copyOfRange(this.arrayItems, (int)index, count);
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        return Arrays.copyOfRange(this.arrayItems, (int)index, count);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.createResultSet();
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        return this.createResultSet();
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void free() throws SQLException {
    }

    private ResultSet createResultSet() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public class ArrayItem
    implements Struct {
        private final Map<String, Object> attrValues;

        public ArrayItem(Map<String, Object> attrValues) {
            this.attrValues = attrValues;
        }

        @Override
        public String getSQLTypeName() {
            return FieldType.combobox.toString();
        }

        @Override
        public Object[] getAttributes() {
            return this.attrValues.values().toArray(new Object[0]);
        }

        @Override
        public Object[] getAttributes(Map<String, Class<?>> map) throws SQLException {
            return new Object[0];
        }

        public String toString() {
            return this.getSQLTypeName() + "{ " + Arrays.toString(this.getAttributes()) + " }";
        }
    }
}

