/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files;

import com.dbeaver.jdbc.files.FFFileReader;
import com.dbeaver.jdbc.files.FFFileReaderFactory;
import com.dbeaver.jdbc.files.FFTableReader;
import com.dbeaver.jdbc.files.api.FFProperties;
import com.dbeaver.jdbc.files.database.FFTable;
import com.dbeaver.jdbc.files.database.FFTableProperties;
import java.io.IOException;
import java.nio.file.Path;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class MultipartTableReader<T, R extends FFFileReader<T>, TP extends FFTableProperties, P extends FFProperties>
implements FFTableReader<T> {
    @NotNull
    protected final FFTable<T, TP> table;
    @NotNull
    private final FFFileReaderFactory<R, P> fileReaderFactory;
    @NotNull
    private final P driverProperties;
    private final boolean skipFirstRow;
    private R fileReader;
    private int nextFile = 0;
    private boolean closed = false;

    public MultipartTableReader(@NotNull FFTable<T, TP> table, @NotNull FFFileReaderFactory<R, P> fileReaderFactory, @NotNull P driverProperties, boolean skipFirstRow) {
        this.table = table;
        this.fileReaderFactory = fileReaderFactory;
        this.driverProperties = driverProperties;
        this.skipFirstRow = skipFirstRow;
    }

    @Override
    @Nullable
    public T[] readRow() throws IOException {
        this.ensureOpen();
        if (this.fileReader == null && !this.openNextFile()) {
            return null;
        }
        T[] row = this.fileReader.readRow();
        if (row == null) {
            this.fileReader.close();
            if (!this.openNextFile()) {
                return null;
            }
        } else {
            return row;
        }
        return this.fileReader.readRow();
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        if (this.fileReader != null) {
            this.fileReader.close();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    private boolean openNextFile() throws IOException {
        T[] read;
        if (this.fileReader != null) {
            this.fileReader.close();
        }
        if (this.nextFile >= this.table.tableSource().dataFiles().size()) {
            return false;
        }
        Path path = this.table.tableSource().dataFiles().get(this.nextFile);
        this.fileReader = this.fileReaderFactory.createReader(path, this.driverProperties);
        if (!this.fileReader.openNextTable()) {
            return false;
        }
        if (this.skipFirstRow && (read = this.fileReader.readRow()) == null) {
            return false;
        }
        ++this.nextFile;
        return true;
    }

    private void ensureOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException("Reader is closed");
        }
    }
}

