/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.api;

import com.dbeaver.jdbc.model.DriverPropertyInfoBuilder;
import java.sql.DriverPropertyInfo;
import java.util.Arrays;
import java.util.function.Function;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public record FFPropertyInfo<T>(@NotNull String name, @NotNull String description, boolean required, @Nullable T[] choices, @Nullable T value, boolean overridable, Function<String, T> parser) {
    public static <T> FFPropertyInfoBuilder<T> builder() {
        return new FFPropertyInfoBuilder();
    }

    public static <T> FFPropertyInfoBuilder<T> from(@NotNull FFPropertyInfo<T> propertyInfo) {
        return new FFPropertyInfoBuilder().withName(propertyInfo.name).withDescription(propertyInfo.description).isRequired(propertyInfo.overridable).withChoices(propertyInfo.choices).withValue(propertyInfo.value);
    }

    public DriverPropertyInfo toDriverPropertyInfo() {
        String strValue = this.value == null ? null : String.valueOf(this.value);
        String[] strChoices = this.choices == null ? null : (String[])Arrays.stream(this.choices).map(String::valueOf).toArray(String[]::new);
        return DriverPropertyInfoBuilder.from((String)this.name, (String)strValue).withDescription(this.description).isRequired(this.overridable).withChoices(strChoices).build();
    }

    public static class FFPropertyInfoBuilder<T> {
        private String name;
        private String description;
        private boolean required;
        private T[] choices;
        private T value;
        private boolean overridable = true;
        private Function<String, T> parser;

        public FFPropertyInfoBuilder<T> withName(@NotNull String name) {
            this.name = name;
            return this;
        }

        public FFPropertyInfoBuilder<T> withDescription(@NotNull String description) {
            this.description = description;
            return this;
        }

        public FFPropertyInfoBuilder<T> isRequired(boolean required) {
            this.required = required;
            return this;
        }

        public FFPropertyInfoBuilder<T> withChoices(T ... choices) {
            this.choices = choices;
            return this;
        }

        public FFPropertyInfoBuilder<T> withValue(T value) {
            this.value = value;
            return this;
        }

        public FFPropertyInfoBuilder<T> isOverridable(boolean overridable) {
            this.overridable = overridable;
            return this;
        }

        public FFPropertyInfoBuilder<T> withParser(Function<String, T> parser) {
            this.parser = parser;
            return this;
        }

        public FFPropertyInfo<T> build() {
            return new FFPropertyInfo<T>(this.name, this.description, this.required, this.choices, this.value, this.overridable, this.parser);
        }
    }
}

