/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.database;

import com.dbeaver.jdbc.files.database.FFSchemaName;
import com.dbeaver.jdbc.files.database.FFTable;
import com.dbeaver.jdbc.files.database.FFTableName;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class FFSchema {
    private static final Logger log = Logger.getLogger(FFSchema.class.getName());
    @NotNull
    private final FFSchemaName schemaName;
    private final SortedMap<FFTableName, FFTable<?, ?>> schemaTree = new TreeMap();

    public FFSchema(@NotNull FFSchemaName schemaName) {
        this.schemaName = schemaName;
    }

    @NotNull
    public FFSchemaName schemaName() {
        return this.schemaName;
    }

    @NotNull
    public Set<FFTableName> tables() {
        return this.schemaTree.values().stream().map(FFTable::tableName).collect(Collectors.toSet());
    }

    @Nullable
    public FFTable<?, ?> table(FFTableName tableName) {
        return (FFTable)this.schemaTree.get(tableName);
    }

    public void addTable(FFTable<?, ?> table) {
        FFTable<?, ?> ffTable = this.schemaTree.putIfAbsent(table.tableName(), table);
        if (ffTable == null) {
            return;
        }
        String originalTableName = table.tableName().name();
        FFSchemaName schemaName = table.tableName().schema();
        FFTableName uniqueTableName = new FFTableName(schemaName, originalTableName);
        int i = 1;
        while (this.schemaTree.containsKey(uniqueTableName)) {
            uniqueTableName = new FFTableName(schemaName, originalTableName + "_" + i);
            ++i;
        }
        log.warning("Rename duplicated table [oldTable=" + table.tableName().asString() + ", newTable=" + uniqueTableName.asString() + "]");
        FFTable<?, ?> renamed = table.rename(uniqueTableName);
        this.schemaTree.put(uniqueTableName, renamed);
    }
}

