/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.engine;

import com.dbeaver.jdbc.files.database.FFTableName;
import com.dbeaver.jdbc.files.engine.FFQueryAnalysisResult;
import com.dbeaver.jdbc.files.engine.FFQueryType;
import com.dbeaver.jdbc.files.engine.FFTablesNamesCollector;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Set;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParser;
import net.sf.jsqlparser.parser.ParseException;
import net.sf.jsqlparser.parser.Provider;
import net.sf.jsqlparser.parser.StringProvider;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.jkiss.code.NotNull;

public class FFQueryAnalyzer {
    private final String defaultSchemaName;

    public FFQueryAnalyzer(@NotNull String defaultSchemaName) {
        this.defaultSchemaName = defaultSchemaName;
    }

    @NotNull
    public FFQueryAnalysisResult analyze(@NotNull String sql) throws SQLException {
        Statement statement = FFQueryAnalyzer.parseStatement(sql);
        FFQueryType queryType = this.determineQueryType(statement);
        if (queryType == FFQueryType.UNRECOGNIZED) {
            throw new SQLFeatureNotSupportedException("Unsupported SQL statement: " + sql);
        }
        Set<FFTableName> tables = FFTablesNamesCollector.collectTableNames(this.defaultSchemaName, statement);
        return new FFQueryAnalysisResult(statement, queryType, tables);
    }

    @NotNull
    private FFQueryType determineQueryType(@NotNull Statement statement) {
        if (statement instanceof Select) {
            Select select = (Select)statement;
            return this.determineSelectQueryType(select);
        }
        return FFQueryType.UNRECOGNIZED;
    }

    private FFQueryType determineSelectQueryType(Select select) {
        if (this.selectsAllColumns(select)) {
            return FFQueryType.ALL_ROWS;
        }
        if (this.isRowCountSelect(select)) {
            return FFQueryType.ROW_COUNT;
        }
        return FFQueryType.SELECT;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isRowCountSelect(@NotNull Select select) {
        void plainSelect;
        if (!(select instanceof PlainSelect)) {
            return false;
        }
        PlainSelect plainSelect2 = (PlainSelect)select;
        return this.hasSingleCountFunction((PlainSelect)plainSelect) && this.hasNoAdditionalClauses((PlainSelect)plainSelect);
    }

    /*
     * WARNING - void declaration
     */
    private boolean hasSingleCountFunction(@NotNull PlainSelect plainSelect) {
        void function;
        if (plainSelect.getSelectItems().size() != 1) {
            return false;
        }
        SelectItem item = (SelectItem)plainSelect.getSelectItems().get(0);
        Expression expression = item.getExpression();
        if (!(expression instanceof Function)) {
            return false;
        }
        Function function2 = (Function)expression;
        if (!"COUNT".equalsIgnoreCase(function.getName())) {
            return false;
        }
        ExpressionList parameters = function.getParameters();
        if (parameters == null) {
            return true;
        }
        return parameters.size() == 1 && this.isSimpleCountParameter((Expression)parameters.get(0));
    }

    private boolean isSimpleCountParameter(@NotNull Expression expression) {
        return expression instanceof AllColumns || expression instanceof LongValue || expression instanceof StringValue;
    }

    /*
     * WARNING - void declaration
     */
    private boolean selectsAllColumns(@NotNull Select select) {
        void plainSelect;
        if (!(select instanceof PlainSelect)) {
            return false;
        }
        PlainSelect plainSelect2 = (PlainSelect)select;
        return this.selectsAllColumns((PlainSelect)plainSelect) && plainSelect.getFromItem() instanceof Table && this.hasNoAdditionalClauses((PlainSelect)plainSelect);
    }

    private boolean selectsAllColumns(@NotNull PlainSelect plainSelect) {
        if (plainSelect.getSelectItems().size() != 1) {
            return false;
        }
        Expression selectItemExpression = ((SelectItem)plainSelect.getSelectItems().get(0)).getExpression();
        return selectItemExpression instanceof AllColumns;
    }

    private boolean hasNoAdditionalClauses(@NotNull PlainSelect plainSelect) {
        return !(plainSelect.getWhere() != null || plainSelect.getJoins() != null && !plainSelect.getJoins().isEmpty() || plainSelect.getGroupBy() != null || plainSelect.getOrderByElements() != null && !plainSelect.getOrderByElements().isEmpty() || plainSelect.getLimit() != null || plainSelect.getOffset() != null);
    }

    @NotNull
    private static Statement parseStatement(@NotNull String sql) throws SQLException {
        try {
            return new CCJSqlParser((Provider)new StringProvider(sql)).Statement();
        }
        catch (ParseException e) {
            throw new SQLException("Failed to parse SQL statement", e);
        }
    }
}

