/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.engine.sqlite;

import com.dbeaver.jdbc.files.api.FFConnection;
import com.dbeaver.jdbc.files.api.FFStatement;
import com.dbeaver.jdbc.files.database.FFTable;
import com.dbeaver.jdbc.files.database.FFTableName;
import com.dbeaver.jdbc.files.engine.FFQueryAnalysisResult;
import com.dbeaver.jdbc.files.engine.file.FileStatement;
import com.dbeaver.jdbc.files.engine.sqlite.SQLiteTableManager;
import com.dbeaver.jdbc.files.utils.FFDriverUtils;
import com.dbeaver.jdbc.files.utils.FFExceptionUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class SQLiteProxyStatement
extends FFStatement {
    private final Statement sqliteDelegate;
    private final FileStatement fileDelegate;
    private final SQLiteTableManager tableManager;

    SQLiteProxyStatement(@NotNull SQLiteTableManager tableManager, @NotNull FFConnection connection, @NotNull Statement sqliteDelegate, @NotNull FileStatement fileDelegate) throws SQLException {
        super(connection);
        this.tableManager = tableManager;
        this.sqliteDelegate = sqliteDelegate;
        this.fileDelegate = fileDelegate;
    }

    public int getMaxFieldSize() throws SQLException {
        this.ensureOpen();
        return this.sqliteDelegate.getMaxFieldSize();
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.ensureOpen();
        this.sqliteDelegate.setMaxFieldSize(max);
        this.fileDelegate.setMaxFieldSize(max);
    }

    public int getMaxRows() throws SQLException {
        this.ensureOpen();
        return this.sqliteDelegate.getMaxRows();
    }

    public void setMaxRows(int max) throws SQLException {
        this.ensureOpen();
        this.sqliteDelegate.setMaxRows(max);
        this.fileDelegate.setMaxRows(max);
    }

    public SQLWarning getWarnings() throws SQLException {
        this.ensureOpen();
        return this.sqliteDelegate.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.ensureOpen();
        this.sqliteDelegate.clearWarnings();
        this.fileDelegate.clearWarnings();
    }

    public void setFetchSize(int rows) throws SQLException {
        this.ensureOpen();
        this.sqliteDelegate.setFetchSize(rows);
        this.fileDelegate.setFetchSize(rows);
    }

    public int getFetchSize() throws SQLException {
        this.ensureOpen();
        return this.sqliteDelegate.getFetchSize();
    }

    @Override
    protected ResultSet execute0(@Nullable int[] columnIndexes, @Nullable String[] columnNames, int autoGeneratedKeys, @NotNull FFQueryAnalysisResult analysisResult) throws SQLException {
        if (this.areLoaded(analysisResult.tables())) {
            return this.sqliteDelegate.executeQuery(analysisResult.statement().toString());
        }
        try {
            return this.fileDelegate.execute(columnIndexes, columnNames, autoGeneratedKeys, analysisResult);
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            this.tableManager.ensureLoaded(analysisResult.tables(), (FFConnection)this.connection, this.canceled);
            return this.sqliteDelegate.executeQuery(analysisResult.statement().toString());
        }
    }

    @Override
    protected void onClose() throws SQLException {
        try {
            FFDriverUtils.closeAll(new AutoCloseable[]{this.sqliteDelegate, this.fileDelegate});
        }
        catch (Exception e) {
            throw FFExceptionUtils.wrapException(e);
        }
    }

    @Override
    protected void onCancel() throws SQLException {
        this.fileDelegate.cancel();
        this.sqliteDelegate.cancel();
    }

    private boolean areLoaded(Set<FFTableName> tables) throws SQLException {
        boolean allTablesLoaded = true;
        for (FFTableName tableName : tables) {
            FFTable<?, ?> table = ((FFConnection)this.connection).getDatabase().table(tableName);
            if (this.tableManager.isLoaded(table)) continue;
            allTablesLoaded = false;
            break;
        }
        return allTablesLoaded;
    }
}

